Numbas.addExtension('booleanlogic',['math','jme','jme-display'],function(extension) {
debugger;
var boolsimplificationRules = {
	booleanlogic: [
		['not(not?;x)',[],'x'],				//unary not not cancels

		['true and?;x',[],'x'],
		['?;x and true',[],'x'],

		['?;x and false',[],'false'],
		['false and?;x',[],'false'],

		['false or?;x',[],'x'],
		['?;x or false',[],'x'],
		['?;x or true',[],'true'],
		['true or?;x',[],'true'],
		
		['not false',[],'true'],
		['not true',[],'false'],
		
											//collect booleans
		['?;n or ?;m',['n isa "boolean"','m isa "boolean"'],'eval(n or m)'],	//or booleans
		['?;n or ?;x',['n isa "boolean"','!(x isa "boolean")'],'x or n'],		//or booleans last
		['(?;x or ?;n) or ?;m',['n isa "boolean"','m isa "boolean"'],'x or eval(n or m)'],	//collect boolean sums
		['(?;x or ?;n) or ?;y',['n isa "boolean"'],'(x or y) or n'],						//shift booleans to right hand side
		['?;n and ?;m',['n isa "boolean"','m isa "boolean"'],'eval(n and m)'],		//and booleans
		['?;x and ?;n',['n isa "boolean"','!(x isa "boolean")'],'n and x'],			//shift booleans to left hand side

		['?;m and (?;n and ?;x)',['m isa "boolean"','n isa "boolean"'],'eval(n and m) and x'],			//constantsFirst
		['?;x and (?;n and ?;y)',['n isa "boolean"','!(x isa "boolean")'],'n and (x and y)']

	]
};

var allboolean=[];
var nboolsimplificationRules = {};

for(var x in boolsimplificationRules)
{
	nboolsimplificationRules[x] = nboolsimplificationRules[x.toLowerCase()] = Numbas.jme.display.compileRules(boolsimplificationRules[x]);
	allboolean = allboolean.concat(nboolsimplificationRules[x].rules);
}

boolsimplificationRules = nboolsimplificationRules;
boolsimplificationRules['allboolean']=new Numbas.jme.Ruleset(allboolean,{});

if(!('allboolean' in extension.scope.rulesets))
						extension.scope.rulesets['allboolean'] = nboolsimplificationRules['allboolean'];
					else
						extension.scope.rulesets['allboolean'] = mergeRulesets(extension.scope.rulesets['allboolean'],nboolsimplificationRules['allboolean']);
						
var funcObj = Numbas.jme.funcObj;
var TNum = Numbas.jme.types.TNum;
extension.scope.addFunction(new funcObj('dummy',[TNum,TNum],TNum,function(a,b){ return Math.abs(a-b); }, {unwrapValues:true}));
console.log(extension);    

})

