Numbas.addExtension('graph-theory-v1',['jme'],function(extension) {
    const scope = extension.scope;
    var jme = Numbas.jme;

    const connected_components = extension.connected_components = function(adjacency) {
        let components = adjacency.map((_,i) => i);
        for(let i=0;i<components.length;i++) {
            for(let j=0;j<components.length;j++) {
                if(i!=j && adjacency[i][j]) {
                    const keep = Math.min(components[i],components[j]);
                    const remove = Math.max(components[i],components[j]);
                    components = components.map(function(c) { return c==remove ? keep : c; });
                }
            }
        }
        const dict = {};
        components.forEach((c,i) => {
            if(dict[c]===undefined) {
                dict[c] = [];
            }
            dict[c].push(i);
        });
        return Object.values(dict);
    }

    const is_connected = extension.is_connected = function(adjacency) {
        return connected_components(adjacency).length<=1;
    }

    const subgraph = extension.subgraph = function(adjacency,verts) {
        const m =verts.map(function(a) {
            return verts.map(function(b) {
                return adjacency[a][b];
            })
        });
        m.rows = m.columns = verts.length;
        return m;
    }

    const largest_connected_component = extension.largest_connected_component = function(adjacency,labels) {
        const components = connected_components(adjacency);
        let biggest = [];
        for(let c of components) {
            if(c.length>biggest.length) {
                biggest = c;
            }
        }
        const oa = subgraph(adjacency,biggest);
        const ol = labels ? biggest.map(i=>labels[i]) : undefined;
        return {adjacency: oa, labels: ol};
    }

    const adjacency_matrix_from_edges = extension.adjacency_matrix_from_edges = function(edges,directed) {
        let size = 0;
        for(let [v1,v2] of edges) {
            size = Math.max(v1+1,Math.max(v2+1,size));
        }
        const m = [];
        for(let i=0;i<size;i++) {
            const row = [];
            for(let j=0;j<size;j++) {
                row.push(0);
            }
            m.push(row);
        }
        edges.forEach(function(e) {
            const [i,j] = e;
            m[i][j] = 1;
            if(!directed) {
                m[j][i] = 1;
            }
        });
        m.rows = m.columns = size;
        return m;
    }

    /** Create lists of vertices and links for cola
     * @param {Array.<Array.<boolean>>} m - the adjacency matrix; m[i][j] is true-ish if there is an edge between vertices i and j.
     * @returns {Object.<vertices,edges>}
     */
    const from_adjacency_matrix = extension.from_adjacency_matrix = function(m) {
        const vertices = [];
        const edges = [];
        for(let i=0;i<m.length;i++) {
            const w = 2;
            vertices.push({x:Math.random(),y:Math.random(), width: w, height: w});
        }
        for(let i=0;i<m.length;i++) {
            for(let j=0;j<i;j++) {
                if(m[i][j]) {
                    edges.push({source:i,target:j,weight:1})
                }
            }
            if(m[i][i]) {
                vertices.push({x:Math.random(),y:Math.random(), width: 0.2, height: 0.2});
                edges.push({source:i,target:vertices.length-1,weight:0.1})
            }
        }
        return {vertices,edges};
    }

    const draw_graph = extension.draw_graph = function(graph) {
        const draw = SVG();

        /** Draw an arrow between a and b
         */
        function arrow(a,b) {
            let dx = b.x-a.x;
            let dy = b.y-a.y;
            const d = Math.sqrt(dx*dx+dy*dy);
            const l = 0.5;
            const w = 0.4;
            let [nx,ny] = [-dy,dx];
            dx *= l/d;
            dy *= l/d;
            nx *= w/d;
            ny *= w/d;
            const [cx,cy] = [(a.x+b.x)/2, (a.y+b.y)/2];
            return draw.polygon([[cx+dx,cy+dy],[cx-dx+nx,cy-dy+ny],[cx-dx/2,cy-dy/2],[cx-dx-nx,cy-dy-ny]]);
        }

        let {vertices,adjacency,labels} = graph;
        labels = labels || [];
        for(let i=0;i<adjacency.length;i++) {
            labels[i] = ((labels[i] || '')+'').trim();
        }
        let minx=Infinity,miny=Infinity,maxx=-Infinity,maxy=-Infinity;
        let extra = 0;
        for(let i=0;i<adjacency.length;i++) {
            for(let j=0;j<=i;j++) {
                const forward = adjacency[i][j];
                const backward = adjacency[j][i];
                if(forward || backward) {
                    const a = vertices[i];
                    const b = vertices[j];
                    let curve;
                    if(i==j) {
                        const c = vertices[adjacency.length+extra];
                        extra+=1;
                        const dx = c.x-a.x;
                        const dy = c.y-a.y;
                        const d = Math.sqrt(dx*dx+dy*dy);
                        const r = 2;
                        curve = draw.circle(r).center(a.x+dx/d*r/2,a.y+dy/d*r/2);
                    } else {
                        curve = draw.line(a.x, a.y, b.x, b.y);
                    }
                    let label;
                    if(forward && backward) {
                        label = `Edge between vertices ${labels[i]} and ${labels[j]}`;
                    } else if(forward) {
                        arrow(a,b);
                        label = `Edge from vertex ${labels[i]} to vertex ${labels[j]}`;
                    } else {
                        arrow(b,a);
                        label = `Edge from vertex ${labels[j]} to vertex ${labels[i]}`;
                    }
                    curve.fill('none').stroke({width:0.5,color:'white'}).attr({role:'img'});
                    if(labels[i] && labels[j]) {
                        curve.attr({'aria-label': label});
                    }
                    const top = curve.clone();
                    top.addTo(draw);
                    top.fill('none').stroke({width:0.1,color:'black'})
                    if(Math.max(forward,backward)<1) {
                        top.stroke({'dasharray':'0.5 0.5'});
                    }
                }
            }
        }

        const real_vertices = vertices.slice(0,adjacency.length);

        real_vertices.forEach((n,i) => {
            minx = Math.min(minx,n.x);
            miny = Math.min(miny,n.y);
            maxx = Math.max(maxx,n.x);
            maxy = Math.max(maxy,n.y);
            const c = draw.circle(1).center(n.x,n.y).attr({role:'img'});
            const label = ((labels[i] || '')+'').trim();
            if(label) {
                c.attr({'aria-label':'Vertex labelled '+label});
            }
        })

        if(labels) {
            real_vertices.forEach((n,i) => {
                const label = (labels[i]+'').trim();
                if(labels[i]===undefined || label=='') {
                    return;
                }
                let nx = 0;
                let ny = 0;
                adjacency[i].forEach(function(a,j) {
                    if(i!=j && a) {
                        const n2 = vertices[j];
                        const dx = n2.x-n.x;
                        const dy = n2.y-n.y;
                        const d = dx*dx+dy*dy;
                        nx += dx/d;
                        ny += dy/d;
                    }
                });
                if(nx==0 && ny==0) {
                    nx = 1;
                    ny = 1;
                }
                const nd = Math.sqrt(nx*nx+ny*ny);
                const r = 1.5;
                const [cx,cy] = [n.x-r*nx/nd,n.y-r*ny/nd];
                const t = draw.text(label).font({size:1,anchor:'top'}).center(cx,cy);
                const b = t.bbox();
                const pad = 0;
                t.before(draw.line(cx,cy,n.x,n.y).stroke({width:0.05,color:'gray'}));
                t.before(draw.ellipse(b.w+2*pad,b.h+2*pad).move(b.x-pad,b.y-pad).fill('white'))
            })
        }

        const margin = 4;
        draw.viewbox(minx-margin,miny-margin,maxx-minx+2*margin,maxy-miny+2*margin)

        return draw.node;
    }

    const layout_graph = extension.layout_graph = function(graph) {
        const {vertices,edges} = graph;
        const adaptor = cola.adaptor({})
            .avoidOverlaps(true)
            .linkDistance(5)
        //    .jaccardLinkLengths(5)
        ;
        adaptor.nodes(vertices);

        adaptor.links(edges)

        adaptor.start();

        // spend at most 100ms laying out the graph
        const t1 = new Date();
        while(!adaptor.tick() && (new Date())-t1<100) {
        }

        return adaptor.nodes();
    }

    const vertex_degrees = extension.vertex_degrees = function(m) {
        const degrees = [];
        for(let i=0;i<m.rows;i++) {
            let d = 0;
            for(let j=0;j<m.columns;j++) {
                d += m[i][j] != 0 ? 1 : 0;
            }
            degrees.push(d);
        }
        return degrees;
    }

    const graph_union = extension.graph_union = function(m) {
        for(let i=1;i<arguments.length;i++) {
            const b = arguments[i];
            const n = [];
            n.rows = m.rows + b.rows;
            n.columns = m.columns + b.columns;
            for(let y=0;y<m.rows+b.rows;y++) {
                const row = [];
                n.push(row);
                for(let x=0;x<m.columns+b.columns;x++) {
                    let a = 0;
                    if(x<m.columns && y<m.rows) {
                        a = m[y][x];
                    } else if(x>=m.columns && y>=m.rows) {
                        a = b[y-m.rows][x-m.columns];
                    }
                    row.push(a);
                }
            }
            m = n;
        }
        return m;
    }

    const cartesian_product = extension.cartesian_product = function(m) {
        for(let i=1;i<arguments.length;i++) {
            const b = arguments[i];
            const n = [];
            const sm = m.rows;
            const size = m.rows*b.rows;
            console.log(size,m.rows,b.rows);
            n.rows = n.columns = size;
            for(let y=0;y<size;y++) {
                const row = [];
                n.push(row);
                const yk = (y-(y%sm))/sm;
                for(let x=0;x<size;x++) {
                    const xk = (x-(x%sm))/sm;
                    let a = b[yk][xk] && (x%sm)==(y%sm) ? 1 : 0;
                    if(xk==yk) {
                        a = m[y-yk*sm][x-xk*sm];
                    }
                    row.push(a);
                }
            }
            m = n;
        }
        return m;
    }

    const direct_product = extension.direct_product = function(m) {
        for(let i=1;i<arguments.length;i++) {
            const b = arguments[i];
            const n = [];
            const sm = m.rows;
            const size = m.rows*b.rows;
            console.log(size,m.rows,b.rows);
            n.rows = n.columns = size;
            for(let y=0;y<size;y++) {
                const row = [];
                n.push(row);
                const yk = (y-(y%sm))/sm;
                for(let x=0;x<size;x++) {
                    const xk = (x-(x%sm))/sm;
                    let a = b[yk][xk] && m[y%sm][x%sm] ? 1 : 0;
                    row.push(a);
                }
            }
            m = n;
        }
        return m;
    }


    const adjacency_permutation = extension.adjacency_permutation = function(p,m) {
        const n = m.map(function(row,y) { return row.map(function(c,x) { return m[p[y]][p[x]]; }) });
        n.rows = m.rows;
        n.columns = m.columns;
        return n;
    }

    const is_graph_isomorphism = extension.is_graph_isomorphism = function(p,m) {
        if(p.length != m.rows) { 
            return false;
        }
        const pm = adjacency_permutation(p,m);
        for(let y=0;y<m.rows;m++) {
            for(let x=0;x<m.columns;x++) {
                if(m[y][x] - pm[y][x]!=0) {
                    return false;
                }
            }
        }
        return true;
    }

    /** Get a list of edges in a graph, given a matrix of edge weights.
     * @param {matrix} weights - a 2D array, where weights[i][j] gives the weight of the edge between vertices i and j, or -1 if there's no edge.
     * @returns {Array.<edge>}
     */
    const edges_from_weight_matrix = extension.edges_from_weight_matrix = function(weights) {
        const edges = [];
        for(let i=0;i<weights.rows;i++) {
            for(let j=i+1;j<weights.columns;j++) {
                const weight = weights[i][j];
                if(weight>=0) {
                    edges.push({from: i, to: j, weight: weight});
                }
            }
        }
        return edges;
    }

    const kruskals_algorithm = extension.kruskals_algorithm = function(weights) {
        const edges = edges_from_weight_matrix(weights);
        edges.sort(Numbas.util.sortBy('weight'));
        const n = weights.rows;
        let forest = [];
        for(let i=0;i<n;i++) {
            forest.push(i);
        }
        const out = [];
        for(let e of edges) {
            if(forest[e.from]!=forest[e.to]) {
                out.push(e);
                const [from,to] = [forest[e.from], forest[e.to]];
                forest = forest.map(i => i==from ? to : i);
            }
        }
        return out;
    }

    const prims_algorithm = extension.prims_algorithm = function(weights) {
        let edges = edges_from_weight_matrix(weights);
        edges.sort(Numbas.util.sortBy('weight'));
        const n = weights.rows;
        const out = [];
        const included = {};
        included[0] = true;
        while(edges.length) {
            const possible = edges.filter(e => included[e.from] || included[e.to]);
            if(!possible.length) {
                throw(new Error("Prim's algorithm requires a connected graph."));
            }
            const e = possible[0];
            out.push(e);
            console.log(`link ${e.from} to ${e.to} (weight ${e.weight})`);
            included[e.from] = true;
            included[e.to] = true;
            edges = edges.filter(e => !(included[e.from] && included[e.to]));
        }
        return out;
    }

    /** To cover:
     *
     * Folding graphs
     */

    var types = jme.types;
    var TMatrix = types.TMatrix;
    var THTML = types.THTML;
    var TList = types.TList;
    var TVector = types.TVector;
    var TBool = types.TBool;

    scope.addFunction(new jme.funcObj('adjacency_matrix',['list of list of number'],TMatrix,function(edges) {
        const m = adjacency_matrix_from_edges(edges);
        return new TMatrix(m);
    },{unwrapValues: true}));

    scope.addFunction(new jme.funcObj('draw_graph_from_adjacency',['matrix','[list of string]'],THTML,function(m,labels) {
        const graph = from_adjacency_matrix(m);
        const lvertices = layout_graph(graph);
        const drawing = draw_graph({vertices: lvertices, adjacency: m, labels: labels});
        return new THTML(drawing);
    },{unwrapValues: true}));
  
    scope.addFunction(new jme.funcObj('largest_connected_component', [TMatrix], TMatrix, function(adjacency) {
      return largest_connected_component(adjacency).adjacency;
    },{unwrapValues: true}));

    scope.addFunction(new jme.funcObj('draw_graph',['matrix','list of vector','[list of string]'],THTML,function(m,points,labels) {
        const vertices = points.map(function(p) {
            return {x:p[0], y:p[1]}
        });
        const {_,edges} = from_adjacency_matrix(m);
        const drawing = draw_graph({vertices: vertices, adjacency: m, labels: labels});
        return new THTML(drawing);
    },{unwrapValues: true}));

    scope.addFunction(new jme.funcObj('layout_graph',['matrix'],TList,function(m) {
        const graph = from_adjacency_matrix(m);
        const vertices = layout_graph(graph);
        return new TList(vertices.map(function(n) { return new TVector([n.x,n.y]); }));
    },{unwrapValues: true}));

    scope.addFunction(new jme.funcObj('vertex_degrees',['matrix'],TList,function(m) {
        return jme.wrapValue(vertex_degrees(m));
    },{unwrapValues: true}));

    scope.addFunction(new jme.funcObj('graph_union',['matrix','matrix'],TMatrix,function(a,b) {
        return new TMatrix(graph_union(a,b));    
    },{unwrapValues: true}));

    scope.addFunction(new jme.funcObj('cartesian_product',['matrix','matrix'],TMatrix,function(a,b) {
        return new TMatrix(cartesian_product(a,b));    
    },{unwrapValues: true}));

    scope.addFunction(new jme.funcObj('direct_product',['matrix','matrix'],TMatrix,function(a,b) {
        return new TMatrix(direct_product(a,b));    
    },{unwrapValues: true}));

    scope.addFunction(new jme.funcObj('adjacency_permutation',['permutation','matrix'], TMatrix,function(p,m) {
        return new TMatrix(adjacency_permutation(p.to,m));
    },{unwrapValues: true}));

    scope.addFunction(new jme.funcObj('is_graph_isomorphism',['permutation','matrix'], TBool,function(p,m) {
        return is_graph_isomorphism(p.to,m);
    }));

    scope.addFunction(new jme.funcObj('kruskals_algorithm', ['matrix'], TList, function(weights) {
        var edges = kruskals_algorithm(weights);
        return edges.map(function(e) { return jme.wrapValue([e.from, e.to]); });
    }));

    scope.addFunction(new jme.funcObj('prims_algorithm', ['matrix'], TList, function(weights) {
        var edges = prims_algorithm(weights);
        return edges.map(function(e) { return jme.wrapValue([e.from, e.to]); });
    }));
});

!function(a){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=a();else if("function"==typeof define&&define.amd)define([],a);else{var b;b="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,b.cola=a()}}(function(){return function(){function a(b,c,d){function e(g,h){if(!c[g]){if(!b[g]){var i="function"==typeof require&&require;if(!h&&i)return i(g,!0);if(f)return f(g,!0);var j=new Error("Cannot find module '"+g+"'");throw j.code="MODULE_NOT_FOUND",j}var k=c[g]={exports:{}};b[g][0].call(k.exports,function(a){return e(b[g][1][a]||a)},k,k.exports,a,b,c,d)}return c[g].exports}for(var f="function"==typeof require&&require,g=0;g<d.length;g++)e(d[g]);return e}return a}()({1:[function(a,b,c){"use strict";function d(a){for(var b in a)c.hasOwnProperty(b)||(c[b]=a[b])}Object.defineProperty(c,"__esModule",{value:!0}),d(a("./src/adaptor")),d(a("./src/d3adaptor")),d(a("./src/descent")),d(a("./src/geom")),d(a("./src/gridrouter")),d(a("./src/handledisconnected")),d(a("./src/layout")),d(a("./src/layout3d")),d(a("./src/linklengths")),d(a("./src/powergraph")),d(a("./src/pqueue")),d(a("./src/rbtree")),d(a("./src/rectangle")),d(a("./src/shortestpaths")),d(a("./src/vpsc")),d(a("./src/batch"))},{"./src/adaptor":2,"./src/batch":3,"./src/d3adaptor":4,"./src/descent":7,"./src/geom":8,"./src/gridrouter":9,"./src/handledisconnected":10,"./src/layout":11,"./src/layout3d":12,"./src/linklengths":13,"./src/powergraph":14,"./src/pqueue":15,"./src/rbtree":16,"./src/rectangle":17,"./src/shortestpaths":18,"./src/vpsc":19}],2:[function(a,b,c){"use strict";function d(a){return new g(a)}var e=this&&this.__extends||function(){var a=function(b,c){return(a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])})(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c),b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}();Object.defineProperty(c,"__esModule",{value:!0});var f=a("./layout"),g=function(a){function b(b){var c=a.call(this)||this,d=b;return d.trigger&&(c.trigger=d.trigger),d.kick&&(c.kick=d.kick),d.drag&&(c.drag=d.drag),d.on&&(c.on=d.on),c.dragstart=c.dragStart=f.Layout.dragStart,c.dragend=c.dragEnd=f.Layout.dragEnd,c}return e(b,a),b.prototype.trigger=function(a){},b.prototype.kick=function(){},b.prototype.drag=function(){},b.prototype.on=function(a,b){return this},b}(f.Layout);c.LayoutAdaptor=g,c.adaptor=d},{"./layout":11}],3:[function(a,b,c){"use strict";function d(a,b,c,d){return a.cola.start(0,0,0,10,!1),e(a.cola.nodes(),a.cola.groups(),c,d).routeEdges(a.powerGraph.powerEdges,b,function(a){return a.source.routerNode.id},function(a){return a.target.routerNode.id})}function e(a,b,c,d){a.forEach(function(a){a.routerNode={name:a.name,bounds:a.bounds.inflate(-c)}}),b.forEach(function(b){b.routerNode={bounds:b.bounds.inflate(-d),children:(void 0!==b.groups?b.groups.map(function(b){return a.length+b.id}):[]).concat(void 0!==b.leaves?b.leaves.map(function(a){return a.index}):[])}});var e=a.concat(b).map(function(a,b){return a.routerNode.id=b,a.routerNode});return new h.GridRouter(e,{getChildren:function(a){return a.children},getBounds:function(a){return a.bounds}},c-d)}function f(a,b,c){var d;a.nodes.forEach(function(a,b){return a.index=b}),(new g.Layout).avoidOverlaps(!1).nodes(a.nodes).links(a.links).powerGraphGroups(function(a){d=a,d.groups.forEach(function(a){return a.padding=c})});var e=a.nodes.length,f=[],h=a.nodes.slice(0);return h.forEach(function(a,b){return a.index=b}),d.groups.forEach(function(a){var b=a.index=a.id+e;h.push(a),void 0!==a.leaves&&a.leaves.forEach(function(a){return f.push({source:b,target:a.index})}),void 0!==a.groups&&a.groups.forEach(function(a){return f.push({source:b,target:a.id+e})})}),d.powerEdges.forEach(function(a){f.push({source:a.source.index,target:a.target.index})}),(new g.Layout).size(b).nodes(h).links(f).avoidOverlaps(!1).linkDistance(30).symmetricDiffLinkLengths(5).convergenceThreshold(1e-4).start(100,0,0,0,!1),{cola:(new g.Layout).convergenceThreshold(.001).size(b).avoidOverlaps(!0).nodes(a.nodes).links(a.links).groupCompactness(1e-4).linkDistance(30).symmetricDiffLinkLengths(5).powerGraphGroups(function(a){d=a,d.groups.forEach(function(a){a.padding=c})}).start(50,0,100,0,!1),powerGraph:d}}Object.defineProperty(c,"__esModule",{value:!0});var g=a("./layout"),h=a("./gridrouter");c.gridify=d,c.powerGraphGridLayout=f},{"./gridrouter":9,"./layout":11}],4:[function(a,b,c){"use strict";function d(a){return!a||e(a)?new f.D3StyleLayoutAdaptor:new g.D3StyleLayoutAdaptor(a)}function e(a){var b=/^3\./;return a.version&&null!==a.version.match(b)}Object.defineProperty(c,"__esModule",{value:!0});var f=a("./d3v3adaptor"),g=a("./d3v4adaptor");c.d3adaptor=d},{"./d3v3adaptor":5,"./d3v4adaptor":6}],5:[function(a,b,c){"use strict";function d(){return new g}var e=this&&this.__extends||function(){var a=function(b,c){return(a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])})(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c),b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}();Object.defineProperty(c,"__esModule",{value:!0});var f=a("./layout"),g=function(a){function b(){var b=a.call(this)||this;b.event=d3.dispatch(f.EventType[f.EventType.start],f.EventType[f.EventType.tick],f.EventType[f.EventType.end]);var c=b;return b.drag=function(){if(!a)var a=d3.behavior.drag().origin(f.Layout.dragOrigin).on("dragstart.d3adaptor",f.Layout.dragStart).on("drag.d3adaptor",function(a){f.Layout.drag(a,d3.event),c.resume()}).on("dragend.d3adaptor",f.Layout.dragEnd);if(!arguments.length)return a;this.call(a)},b}return e(b,a),b.prototype.trigger=function(a){var b={type:f.EventType[a.type],alpha:a.alpha,stress:a.stress};this.event[b.type](b)},b.prototype.kick=function(){var b=this;d3.timer(function(){return a.prototype.tick.call(b)})},b.prototype.on=function(a,b){return"string"==typeof a?this.event.on(a,b):this.event.on(f.EventType[a],b),this},b}(f.Layout);c.D3StyleLayoutAdaptor=g,c.d3adaptor=d},{"./layout":11}],6:[function(a,b,c){"use strict";var d=this&&this.__extends||function(){var a=function(b,c){return(a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])})(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c),b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}();Object.defineProperty(c,"__esModule",{value:!0});var e=a("./layout"),f=function(a){function b(b){var c=a.call(this)||this;c.d3Context=b,c.event=b.dispatch(e.EventType[e.EventType.start],e.EventType[e.EventType.tick],e.EventType[e.EventType.end]);var d=c;return c.drag=function(){if(!a)var a=b.drag().subject(e.Layout.dragOrigin).on("start.d3adaptor",e.Layout.dragStart).on("drag.d3adaptor",function(a){e.Layout.drag(a,b.event),d.resume()}).on("end.d3adaptor",e.Layout.dragEnd);if(!arguments.length)return a;arguments[0].call(a)},c}return d(b,a),b.prototype.trigger=function(a){var b={type:e.EventType[a.type],alpha:a.alpha,stress:a.stress};this.event.call(b.type,b)},b.prototype.kick=function(){var b=this,c=this.d3Context.timer(function(){return a.prototype.tick.call(b)&&c.stop()})},b.prototype.on=function(a,b){return"string"==typeof a?this.event.on(a,b):this.event.on(e.EventType[a],b),this},b}(e.Layout);c.D3StyleLayoutAdaptor=f},{"./layout":11}],7:[function(a,b,c){"use strict";Object.defineProperty(c,"__esModule",{value:!0});var d=function(){function a(){this.locks={}}return a.prototype.add=function(a,b){this.locks[a]=b},a.prototype.clear=function(){this.locks={}},a.prototype.isEmpty=function(){for(var a in this.locks)return!1;return!0},a.prototype.apply=function(a){for(var b in this.locks)a(Number(b),this.locks[b])},a}();c.Locks=d;var e=function(){function a(a,b,c){void 0===c&&(c=null),this.D=b,this.G=c,this.threshold=1e-4,this.numGridSnapNodes=0,this.snapGridSize=100,this.snapStrength=1e3,this.scaleSnapByMaxH=!1,this.random=new f,this.project=null,this.x=a,this.k=a.length;var e=this.n=a[0].length;this.H=new Array(this.k),this.g=new Array(this.k),this.Hd=new Array(this.k),this.a=new Array(this.k),this.b=new Array(this.k),this.c=new Array(this.k),this.d=new Array(this.k),this.e=new Array(this.k),this.ia=new Array(this.k),this.ib=new Array(this.k),this.xtmp=new Array(this.k),this.locks=new d,this.minD=Number.MAX_VALUE;for(var g,h=e;h--;)for(g=e;--g>h;){var i=b[h][g];i>0&&i<this.minD&&(this.minD=i)}for(this.minD===Number.MAX_VALUE&&(this.minD=1),h=this.k;h--;){for(this.g[h]=new Array(e),this.H[h]=new Array(e),g=e;g--;)this.H[h][g]=new Array(e);this.Hd[h]=new Array(e),this.a[h]=new Array(e),this.b[h]=new Array(e),this.c[h]=new Array(e),this.d[h]=new Array(e),this.e[h]=new Array(e),this.ia[h]=new Array(e),this.ib[h]=new Array(e),this.xtmp[h]=new Array(e)}}return a.createSquareMatrix=function(a,b){for(var c=new Array(a),d=0;d<a;++d){c[d]=new Array(a);for(var e=0;e<a;++e)c[d][e]=b(d,e)}return c},a.prototype.offsetDir=function(){for(var a=this,b=new Array(this.k),c=0,d=0;d<this.k;++d){var e=b[d]=this.random.getNextBetween(.01,1)-.5;c+=e*e}return c=Math.sqrt(c),b.map(function(b){return b*=a.minD/c})},a.prototype.computeDerivatives=function(a){var b=this,c=this.n;if(!(c<1)){for(var d,e=new Array(this.k),f=new Array(this.k),g=new Array(this.k),h=0,i=0;i<c;++i){for(d=0;d<this.k;++d)g[d]=this.g[d][i]=0;for(var j=0;j<c;++j)if(i!==j){for(var k=c,l=0;k--;){for(l=0,d=0;d<this.k;++d){var m=e[d]=a[d][i]-a[d][j];l+=f[d]=m*m}if(l>1e-9)break;var n=this.offsetDir();for(d=0;d<this.k;++d)a[d][j]+=n[d]}var o=Math.sqrt(l),p=this.D[i][j],q=null!=this.G?this.G[i][j]:1;if(q>1&&o>p||!isFinite(p))for(d=0;d<this.k;++d)this.H[d][i][j]=0;else{q>1&&(q=1);var r=p*p,s=2*q*(o-p)/(r*o),t=l*o,u=2*-q/(r*t);for(isFinite(s)||console.log(s),d=0;d<this.k;++d)this.g[d][i]+=e[d]*s,g[d]-=this.H[d][i][j]=u*(2*t+p*(f[d]-l))}}for(d=0;d<this.k;++d)h=Math.max(h,this.H[d][i][i]=g[d])}for(var v=this.snapGridSize/2,w=this.snapGridSize,x=this.snapStrength,y=x/(v*v),z=this.numGridSnapNodes,A=0;A<z;++A)for(d=0;d<this.k;++d){var B=this.x[d][A],C=B/w,D=C%1,E=C-D,F=Math.abs(D),G=F<=.5?B-E*w:B>0?B-(E+1)*w:B-(E-1)*w;-v<G&&G<=v&&(this.scaleSnapByMaxH?(this.g[d][A]+=h*y*G,this.H[d][A][A]+=h*y):(this.g[d][A]+=y*G,this.H[d][A][A]+=y))}this.locks.isEmpty()||this.locks.apply(function(c,e){for(d=0;d<b.k;++d)b.H[d][c][c]+=h,b.g[d][c]-=h*(e[d]-a[d][c])})}},a.dotProd=function(a,b){for(var c=0,d=a.length;d--;)c+=a[d]*b[d];return c},a.rightMultiply=function(b,c,d){for(var e=b.length;e--;)d[e]=a.dotProd(b[e],c)},a.prototype.computeStepSize=function(b){for(var c=0,d=0,e=0;e<this.k;++e)c+=a.dotProd(this.g[e],b[e]),a.rightMultiply(this.H[e],b[e],this.Hd[e]),d+=a.dotProd(b[e],this.Hd[e]);return 0!==d&&isFinite(d)?1*c/d:0},a.prototype.reduceStress=function(){this.computeDerivatives(this.x);for(var a=this.computeStepSize(this.g),b=0;b<this.k;++b)this.takeDescentStep(this.x[b],this.g[b],a);return this.computeStress()},a.copy=function(a,b){for(var c=a.length,d=b[0].length,e=0;e<c;++e)for(var f=0;f<d;++f)b[e][f]=a[e][f]},a.prototype.stepAndProject=function(b,c,d,e){a.copy(b,c),this.takeDescentStep(c[0],d[0],e),this.project&&this.project[0](b[0],b[1],c[0]),this.takeDescentStep(c[1],d[1],e),this.project&&this.project[1](c[0],b[1],c[1]);for(var f=2;f<this.k;f++)this.takeDescentStep(c[f],d[f],e)},a.mApply=function(a,b,c){for(var d=a;d-- >0;)for(var e=b;e-- >0;)c(d,e)},a.prototype.matrixApply=function(b){a.mApply(this.k,this.n,b)},a.prototype.computeNextPosition=function(a,b){var c=this;this.computeDerivatives(a);var d=this.computeStepSize(this.g);if(this.stepAndProject(a,b,this.g,d),this.project){this.matrixApply(function(d,e){return c.e[d][e]=a[d][e]-b[d][e]});var e=this.computeStepSize(this.e);e=Math.max(.2,Math.min(e,1)),this.stepAndProject(a,b,this.e,e)}},a.prototype.run=function(a){for(var b=Number.MAX_VALUE,c=!1;!c&&a-- >0;){var d=this.rungeKutta();c=Math.abs(b/d-1)<this.threshold,b=d}return b},a.prototype.rungeKutta=function(){var b=this;this.computeNextPosition(this.x,this.a),a.mid(this.x,this.a,this.ia),this.computeNextPosition(this.ia,this.b),a.mid(this.x,this.b,this.ib),this.computeNextPosition(this.ib,this.c),this.computeNextPosition(this.c,this.d);var c=0;return this.matrixApply(function(a,d){var e=(b.a[a][d]+2*b.b[a][d]+2*b.c[a][d]+b.d[a][d])/6,f=b.x[a][d]-e;c+=f*f,b.x[a][d]=e}),c},a.mid=function(b,c,d){a.mApply(b.length,b[0].length,function(a,e){return d[a][e]=b[a][e]+(c[a][e]-b[a][e])/2})},a.prototype.takeDescentStep=function(a,b,c){for(var d=0;d<this.n;++d)a[d]=a[d]-c*b[d]},a.prototype.computeStress=function(){for(var a=0,b=0,c=this.n-1;b<c;++b)for(var d=b+1,e=this.n;d<e;++d){for(var f=0,g=0;g<this.k;++g){var h=this.x[g][b]-this.x[g][d];f+=h*h}f=Math.sqrt(f);var i=this.D[b][d];if(isFinite(i)){var j=i-f,k=i*i;a+=j*j/k}}return a},a.zeroDistance=1e-10,a}();c.Descent=e;var f=function(){function a(a){void 0===a&&(a=1),this.seed=a,this.a=214013,this.c=2531011,this.m=2147483648,this.range=32767}return a.prototype.getNext=function(){return this.seed=(this.seed*this.a+this.c)%this.m,(this.seed>>16)/this.range},a.prototype.getNextBetween=function(a,b){return a+this.getNext()*(b-a)},a}();c.PseudoRandom=f},{}],8:[function(a,b,c){"use strict";function d(a,b,c){return(b.x-a.x)*(c.y-a.y)-(c.x-a.x)*(b.y-a.y)}function e(a,b,c){return d(a,b,c)>0}function f(a,b,c){return d(a,b,c)<0}function g(a){var b,c=a.slice(0).sort(function(a,b){return a.x!==b.x?b.x-a.x:b.y-a.y}),e=a.length,f=c[0].x;for(b=1;b<e&&c[b].x===f;++b);var g=b-1,h=[];if(h.push(c[0]),g===e-1)c[g].y!==c[0].y&&h.push(c[g]);else{var i,j=e-1,k=c[e-1].x;for(b=e-2;b>=0&&c[b].x===k;b--);for(i=b+1,b=g;++b<=i;)if(!(d(c[0],c[i],c[b])>=0&&b<i)){for(;h.length>1&&!(d(h[h.length-2],h[h.length-1],c[b])>0);)h.length-=1;0!=b&&h.push(c[b])}j!=i&&h.push(c[j]);var l=h.length;for(b=i;--b>=g;)if(!(d(c[j],c[g],c[b])>=0&&b>g)){for(;h.length>l&&!(d(h[h.length-2],h[h.length-1],c[b])>0);)h.length-=1;0!=b&&h.push(c[b])}}return h}function h(a,b,c){b.slice(0).sort(function(b,c){return Math.atan2(b.y-a.y,b.x-a.x)-Math.atan2(c.y-a.y,c.x-a.x)}).forEach(c)}function i(a,b){var c=b.slice(0);return c.push(b[0]),{rtan:j(a,c),ltan:k(a,c)}}function j(a,b){var c,d,g,h,i,j=b.length-1;if(f(a,b[1],b[0])&&!e(a,b[j-1],b[0]))return 0;for(c=0,d=j;;){if(d-c==1)return e(a,b[c],b[d])?c:d;if(g=Math.floor((c+d)/2),(i=f(a,b[g+1],b[g]))&&!e(a,b[g-1],b[g]))return g;h=e(a,b[c+1],b[c]),h?i?d=g:e(a,b[c],b[g])?d=g:c=g:i&&f(a,b[c],b[g])?d=g:c=g}}function k(a,b){var c,d,g,h,i,j=b.length-1;if(e(a,b[j-1],b[0])&&!f(a,b[1],b[0]))return 0;for(c=0,d=j;;){if(d-c==1)return f(a,b[c],b[d])?c:d;if(g=Math.floor((c+d)/2),i=f(a,b[g+1],b[g]),e(a,b[g-1],b[g])&&!i)return g;h=f(a,b[c+1],b[c]),h?i?f(a,b[c],b[g])?d=g:c=g:d=g:i?c=g:e(a,b[c],b[g])?d=g:c=g}}function l(a,b,c,d,e,f){var g,h;g=c(b[0],a),h=d(a[g],b);for(var i=!1;!i;){for(i=!0;;){if(g===a.length-1&&(g=0),e(b[h],a[g],a[g+1]))break;++g}for(;;){if(0===h&&(h=b.length-1),f(a[g],b[h],b[h-1]))break;--h,i=!1}}return{t1:g,t2:h}}function m(a,b){var c=n(b,a);return{t1:c.t2,t2:c.t1}}function n(a,b){return l(a,b,j,k,e,f)}function o(a,b){return l(a,b,k,k,f,f)}function p(a,b){return l(a,b,j,j,e,e)}function q(a,b){for(var c=[],d=1,e=b.length;d<e;++d){var f=w.Rectangle.lineIntersection(a.x1,a.y1,a.x2,a.y2,b[d-1].x,b[d-1].y,b[d].x,b[d].y);f&&c.push(f)}return c}function r(a,b){for(var c=a.length-1,e=b.length-1,f=new B,g=0;g<=c;++g)for(var h=0;h<=e;++h){var i=a[0==g?c:g-1],j=a[g],k=a[g==c?0:g+1],l=b[0==h?e:h-1],m=b[h],n=b[h==e?0:h+1],o=d(i,j,m),p=d(j,l,m),q=d(j,m,n),r=d(l,m,j),s=d(m,i,j),t=d(m,j,k);o>=0&&p>=0&&q<0&&r>=0&&s>=0&&t<0?f.ll=new A(g,h):o<=0&&p<=0&&q>0&&r<=0&&s<=0&&t>0?f.rr=new A(g,h):o<=0&&p>0&&q<=0&&r>=0&&s<0&&t>=0?f.rl=new A(g,h):o>=0&&p<0&&q>=0&&r<=0&&s>0&&t<=0&&(f.lr=new A(g,h))}return f}function s(a,b){for(var c=1,d=b.length;c<d;++c)if(f(b[c-1],b[c],a))return!1;return!0}function t(a,b){return!a.every(function(a){return!s(a,b)})}function u(a,b){if(t(a,b))return!0;if(t(b,a))return!0;for(var c=1,d=a.length;c<d;++c){var e=a[c],f=a[c-1];if(q(new y(f.x,f.y,e.x,e.y),b).length>0)return!0}return!1}var v=this&&this.__extends||function(){var a=function(b,c){return(a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])})(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c),b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}();Object.defineProperty(c,"__esModule",{value:!0});var w=a("./rectangle"),x=function(){function a(){}return a}();c.Point=x;var y=function(){function a(a,b,c,d){this.x1=a,this.y1=b,this.x2=c,this.y2=d}return a}();c.LineSegment=y;var z=function(a){function b(){return null!==a&&a.apply(this,arguments)||this}return v(b,a),b}(x);c.PolyPoint=z,c.isLeft=d,c.ConvexHull=g,c.clockwiseRadialSweep=h,c.tangent_PolyPolyC=l,c.LRtangent_PolyPolyC=m,c.RLtangent_PolyPolyC=n,c.LLtangent_PolyPolyC=o,c.RRtangent_PolyPolyC=p;var A=function(){function a(a,b){this.t1=a,this.t2=b}return a}();c.BiTangent=A;var B=function(){function a(){}return a}();c.BiTangents=B;var C=function(a){function b(){return null!==a&&a.apply(this,arguments)||this}return v(b,a),b}(x);c.TVGPoint=C;var D=function(){function a(a,b,c,d){this.id=a,this.polyid=b,this.polyvertid=c,this.p=d,d.vv=this}return a}();c.VisibilityVertex=D;var E=function(){function a(a,b){this.source=a,this.target=b}return a.prototype.length=function(){var a=this.source.p.x-this.target.p.x,b=this.source.p.y-this.target.p.y;return Math.sqrt(a*a+b*b)},a}();c.VisibilityEdge=E;var F=function(){function a(a,b){if(this.P=a,this.V=[],this.E=[],b)this.V=b.V.slice(0),this.E=b.E.slice(0);else{for(var c=a.length,d=0;d<c;d++){for(var e=a[d],f=0;f<e.length;++f){var g=e[f],h=new D(this.V.length,d,f,g);this.V.push(h),f>0&&this.E.push(new E(e[f-1].vv,h))}e.length>1&&this.E.push(new E(e[0].vv,e[e.length-1].vv))}for(var d=0;d<c-1;d++)for(var i=a[d],f=d+1;f<c;f++){var j=a[f],k=r(i,j);for(var l in k){var m=k[l],n=i[m.t1],o=j[m.t2];this.addEdgeIfVisible(n,o,d,f)}}}}return a.prototype.addEdgeIfVisible=function(a,b,c,d){this.intersectsPolys(new y(a.x,a.y,b.x,b.y),c,d)||this.E.push(new E(a.vv,b.vv))},a.prototype.addPoint=function(a,b){var c=this.P.length;this.V.push(new D(this.V.length,c,0,a));for(var d=0;d<c;++d)if(d!==b){var e=this.P[d],f=i(a,e);this.addEdgeIfVisible(a,e[f.ltan],b,d),this.addEdgeIfVisible(a,e[f.rtan],b,d)}return a.vv},a.prototype.intersectsPolys=function(a,b,c){for(var d=0,e=this.P.length;d<e;++d)if(d!=b&&d!=c&&q(a,this.P[d]).length>0)return!0;return!1},a}();c.TangentVisibilityGraph=F,c.tangents=r,c.polysOverlap=u},{"./rectangle":17}],9:[function(a,b,c){"use strict";Object.defineProperty(c,"__esModule",{value:!0});var d=a("./rectangle"),e=a("./vpsc"),f=a("./shortestpaths"),g=function(){function a(a,b,c){this.id=a,this.rect=b,this.children=c,this.leaf=void 0===c||0===c.length}return a}();c.NodeWrapper=g;var h=function(){function a(a,b,c,d,e){void 0===d&&(d=null),void 0===e&&(e=null),this.id=a,this.x=b,this.y=c,this.node=d,this.line=e}return a}();c.Vert=h;var i=function(){function a(b,c){this.s=b,this.t=c;var d=a.findMatch(b,c),e=c.slice(0).reverse(),f=a.findMatch(b,e);d.length>=f.length?(this.length=d.length,this.si=d.si,this.ti=d.ti,this.reversed=!1):(this.length=f.length,this.si=f.si,this.ti=c.length-f.ti-f.length,this.reversed=!0)}return a.findMatch=function(a,b){for(var c=a.length,d=b.length,e={length:0,si:-1,ti:-1},f=new Array(c),g=0;g<c;g++){f[g]=new Array(d);for(var h=0;h<d;h++)if(a[g]===b[h]){var i=f[g][h]=0===g||0===h?1:f[g-1][h-1]+1;i>e.length&&(e.length=i,e.si=g-i+1,e.ti=h-i+1)}else f[g][h]=0}return e},a.prototype.getSequence=function(){return this.length>=0?this.s.slice(this.si,this.si+this.length):[]},a}();c.LongestCommonSubsequence=i;var j=function(){function a(a,b,c){var e=this;void 0===c&&(c=12),this.originalnodes=a,this.groupPadding=c,this.leaves=null,this.nodes=a.map(function(a,c){return new g(c,b.getBounds(a),b.getChildren(a))}),this.leaves=this.nodes.filter(function(a){return a.leaf}),this.groups=this.nodes.filter(function(a){return!a.leaf}),this.cols=this.getGridLines("x"),this.rows=this.getGridLines("y"),this.groups.forEach(function(a){return a.children.forEach(function(b){return e.nodes[b].parent=a})}),this.root={children:[]},this.nodes.forEach(function(a){void 0===a.parent&&(a.parent=e.root,e.root.children.push(a.id)),a.ports=[]}),this.backToFront=this.nodes.slice(0),this.backToFront.sort(function(a,b){return e.getDepth(a)-e.getDepth(b)}),this.backToFront.slice(0).reverse().filter(function(a){return!a.leaf}).forEach(function(a){var b=d.Rectangle.empty();a.children.forEach(function(a){return b=b.union(e.nodes[a].rect)}),a.rect=b.inflate(e.groupPadding)});var f=this.midPoints(this.cols.map(function(a){return a.pos})),i=this.midPoints(this.rows.map(function(a){return a.pos})),j=f[0],k=f[f.length-1],l=i[0],m=i[i.length-1],n=this.rows.map(function(a){return{x1:j,x2:k,y1:a.pos,y2:a.pos}}).concat(i.map(function(a){return{x1:j,x2:k,y1:a,y2:a}})),o=this.cols.map(function(a){return{x1:a.pos,x2:a.pos,y1:l,y2:m}}).concat(f.map(function(a){return{x1:a,x2:a,y1:l,y2:m}})),p=n.concat(o);p.forEach(function(a){return a.verts=[]}),this.verts=[],this.edges=[],n.forEach(function(a){return o.forEach(function(b){var c=new h(e.verts.length,b.x1,a.y1);a.verts.push(c),b.verts.push(c),e.verts.push(c);for(var d=e.backToFront.length;d-- >0;){var f=e.backToFront[d],g=f.rect,i=Math.abs(c.x-g.cx()),j=Math.abs(c.y-g.cy());if(i<g.width()/2&&j<g.height()/2){c.node=f;break}}})}),p.forEach(function(a,b){e.nodes.forEach(function(b,c){b.rect.lineIntersections(a.x1,a.y1,a.x2,a.y2).forEach(function(c,d){var f=new h(e.verts.length,c.x,c.y,b,a);e.verts.push(f),a.verts.push(f),b.ports.push(f)})});var c=Math.abs(a.y1-a.y2)<.1,d=function(a,b){return c?b.x-a.x:b.y-a.y};a.verts.sort(d);for(var f=1;f<a.verts.length;f++){var g=a.verts[f-1],i=a.verts[f];g.node&&g.node===i.node&&g.node.leaf||e.edges.push({source:g.id,target:i.id,length:Math.abs(d(g,i))})}})}return a.prototype.avg=function(a){return a.reduce(function(a,b){return a+b})/a.length},a.prototype.getGridLines=function(a){for(var b=[],c=this.leaves.slice(0,this.leaves.length);c.length>0;){var d=c.filter(function(b){return b.rect["overlap"+a.toUpperCase()](c[0].rect)}),e={nodes:d,pos:this.avg(d.map(function(b){return b.rect["c"+a]()}))};b.push(e),e.nodes.forEach(function(a){return c.splice(c.indexOf(a),1)})}return b.sort(function(a,b){return a.pos-b.pos}),b},a.prototype.getDepth=function(a){for(var b=0;a.parent!==this.root;)b++,a=a.parent;return b},a.prototype.midPoints=function(a){for(var b=a[1]-a[0],c=[a[0]-b/2],d=1;d<a.length;d++)c.push((a[d]+a[d-1])/2);return c.push(a[a.length-1]+b/2),c},a.prototype.findLineage=function(a){var b=[a];do{a=a.parent,b.push(a)}while(a!==this.root);return b.reverse()},a.prototype.findAncestorPathBetween=function(a,b){for(var c=this.findLineage(a),d=this.findLineage(b),e=0;c[e]===d[e];)e++;return{commonAncestor:c[e-1],lineages:c.slice(e).concat(d.slice(e))}},a.prototype.siblingObstacles=function(a,b){var c=this,d=this.findAncestorPathBetween(a,b),e={};d.lineages.forEach(function(a){return e[a.id]={}});var f=d.commonAncestor.children.filter(function(a){return!(a in e)});return d.lineages.filter(function(a){return a.parent!==d.commonAncestor}).forEach(function(a){return f=f.concat(a.parent.children.filter(function(b){return b!==a.id}))}),f.map(function(a){return c.nodes[a]})},a.getSegmentSets=function(a,b,c){for(var d=[],e=0;e<a.length;e++)for(var f=a[e],g=0;g<f.length;g++){var h=f[g];h.edgeid=e,h.i=g;var i=h[1][b]-h[0][b];Math.abs(i)<.1&&d.push(h)}d.sort(function(a,c){return a[0][b]-c[0][b]});for(var j=[],k=null,l=0;l<d.length;l++){var h=d[l];(!k||Math.abs(h[0][b]-k.pos)>.1)&&(k={pos:h[0][b],segments:[]},j.push(k)),k.segments.push(h)}return j},a.nudgeSegs=function(a,b,c,d,f,g){var h=d.length;if(!(h<=1)){for(var i=d.map(function(b){return new e.Variable(b[0][a])}),j=[],k=0;k<h;k++)for(var l=0;l<h;l++)if(k!==l){var m=d[k],n=d[l],o=m.edgeid,p=n.edgeid,q=-1,r=-1;"x"==a?f(o,p)&&(m[0][b]<m[1][b]?(q=l,r=k):(q=k,r=l)):f(o,p)&&(m[0][b]<m[1][b]?(q=k,r=l):(q=l,r=k)),q>=0&&j.push(new e.Constraint(i[q],i[r],g))}new e.Solver(i,j).solve(),i.forEach(function(b,e){var f=d[e],g=b.position();f[0][a]=f[1][a]=g;var h=c[f.edgeid];f.i>0&&(h[f.i-1][1][a]=g),f.i<h.length-1&&(h[f.i+1][0][a]=g)})}},a.nudgeSegments=function(b,c,d,e,f){for(var g=a.getSegmentSets(b,c,d),h=0;h<g.length;h++){for(var i=g[h],j=[],k=0;k<i.segments.length;k++){var l=i.segments[k];j.push({type:0,s:l,pos:Math.min(l[0][d],l[1][d])}),j.push({type:1,s:l,pos:Math.max(l[0][d],l[1][d])})}j.sort(function(a,b){return a.pos-b.pos+a.type-b.type});var m=[],n=0;j.forEach(function(g){0===g.type?(m.push(g.s),n++):n--,0==n&&(a.nudgeSegs(c,d,b,m,e,f),m=[])})}},a.prototype.routeEdges=function(b,c,d,e){var f=this,g=b.map(function(a){return f.route(d(a),e(a))}),h=a.orderEdges(g),i=g.map(function(b){return a.makeSegments(b)});return a.nudgeSegments(i,"x","y",h,c),a.nudgeSegments(i,"y","x",h,c),a.unreverseEdges(i,g),i},a.unreverseEdges=function(a,b){a.forEach(function(a,c){b[c].reversed&&(a.reverse(),a.forEach(function(a){a.reverse()}))})},a.angleBetween2Lines=function(a,b){var c=Math.atan2(a[0].y-a[1].y,a[0].x-a[1].x),d=Math.atan2(b[0].y-b[1].y,b[0].x-b[1].x),e=c-d;return(e>Math.PI||e<-Math.PI)&&(e=d-c),e},a.isLeft=function(a,b,c){return(b.x-a.x)*(c.y-a.y)-(b.y-a.y)*(c.x-a.x)<=0},a.getOrder=function(a){for(var b={},c=0;c<a.length;c++){var d=a[c];void 0===b[d.l]&&(b[d.l]={}),b[d.l][d.r]=!0}return function(a,c){return void 0!==b[a]&&b[a][c]}},a.orderEdges=function(b){for(var c=[],d=0;d<b.length-1;d++)for(var e=d+1;e<b.length;e++){var f,g,h,j=b[d],k=b[e],l=new i(j,k);0!==l.length&&(l.reversed&&(k.reverse(),k.reversed=!0,l=new i(j,k)),(l.si<=0||l.ti<=0)&&(l.si+l.length>=j.length||l.ti+l.length>=k.length)?c.push({l:d,r:e}):(l.si+l.length>=j.length||l.ti+l.length>=k.length?(f=j[l.si+1],h=j[l.si-1],g=k[l.ti-1]):(f=j[l.si+l.length-2],g=j[l.si+l.length],h=k[l.ti+l.length]),a.isLeft(f,g,h)?c.push({l:e,r:d}):c.push({l:d,r:e})))}return a.getOrder(c)},a.makeSegments=function(a){function b(a){return{x:a.x,y:a.y}}for(var c=[],d=b(a[0]),e=1;e<a.length;e++){var f=b(a[e]),g=e<a.length-1?a[e+1]:null;g&&function(a,b,c){return Math.abs((b.x-a.x)*(c.y-a.y)-(b.y-a.y)*(c.x-a.x))<.001}(d,f,g)||(c.push([d,f]),d=f)}return c},a.prototype.route=function(a,b){var c=this,d=this.nodes[a],e=this.nodes[b];this.obstacles=this.siblingObstacles(d,e);var g={};this.obstacles.forEach(function(a){return g[a.id]=a}),this.passableEdges=this.edges.filter(function(a){var b=c.verts[a.source],d=c.verts[a.target];return!(b.node&&b.node.id in g||d.node&&d.node.id in g)});for(var h=1;h<d.ports.length;h++){var i=d.ports[0].id,j=d.ports[h].id;this.passableEdges.push({source:i,target:j,length:0})}for(var h=1;h<e.ports.length;h++){var i=e.ports[0].id,j=e.ports[h].id;this.passableEdges.push({source:i,target:j,length:0})}var k=function(a){return a.source},l=function(a){return a.target},m=function(a){return a.length},n=new f.Calculator(this.verts.length,this.passableEdges,k,l,m),o=function(a,b,f){var g=c.verts[a],h=c.verts[b],i=c.verts[f],j=Math.abs(i.x-g.x),k=Math.abs(i.y-g.y);return g.node===d&&g.node===h.node||h.node===e&&h.node===i.node?0:j>1&&k>1?1e3:0},p=n.PathFromNodeToNodeWithPrevCost(d.ports[0].id,e.ports[0].id,o),q=p.reverse().map(function(a){return c.verts[a]});return q.push(this.nodes[e.id].ports[0]),q.filter(function(a,b){return!(b<q.length-1&&q[b+1].node===d&&a.node===d||b>0&&a.node===e&&q[b-1].node===e)})},a.getRoutePath=function(b,c,d,e){var f={routepath:"M "+b[0][0].x+" "+b[0][0].y+" ",arrowpath:""};if(b.length>1)for(var g=0;g<b.length;g++){var h=b[g],i=h[1].x,j=h[1].y,k=i-h[0].x,l=j-h[0].y;if(g<b.length-1){Math.abs(k)>0?i-=k/Math.abs(k)*c:j-=l/Math.abs(l)*c,f.routepath+="L "+i+" "+j+" ";var m=b[g+1],n=m[0].x,o=m[0].y,p=m[1].x,q=m[1].y;k=p-n,l=q-o;var r,s,t=a.angleBetween2Lines(h,m)<0?1:0;Math.abs(k)>0?(r=n+k/Math.abs(k)*c,s=o):(r=n,s=o+l/Math.abs(l)*c);var u=Math.abs(r-i),v=Math.abs(s-j);f.routepath+="A "+u+" "+v+" 0 0 "+t+" "+r+" "+s+" "}else{var w,x,y=[i,j];Math.abs(k)>0?(i-=k/Math.abs(k)*e,w=[i,j+d],x=[i,j-d]):(j-=l/Math.abs(l)*e,w=[i+d,j],x=[i-d,j]),f.routepath+="L "+i+" "+j+" ",e>0&&(f.arrowpath="M "+y[0]+" "+y[1]+" L "+w[0]+" "+w[1]+" L "+x[0]+" "+x[1])}}else{var w,x,h=b[0],i=h[1].x,j=h[1].y,k=i-h[0].x,l=j-h[0].y,y=[i,j];Math.abs(k)>0?(i-=k/Math.abs(k)*e,w=[i,j+d],x=[i,j-d]):(j-=l/Math.abs(l)*e,w=[i+d,j],x=[i-d,j]),f.routepath+="L "+i+" "+j+" ",e>0&&(f.arrowpath="M "+y[0]+" "+y[1]+" L "+w[0]+" "+w[1]+" L "+x[0]+" "+x[1])}return f},a}();c.GridRouter=j},{"./rectangle":17,"./shortestpaths":18,"./vpsc":19}],10:[function(a,b,c){"use strict";function d(a,b,c,d,e,g){function h(a,b){t=[],p=0,q=0,s=m;for(var c=0;c<a.length;c++){i(a[c],b)}return Math.abs(k()-e)}function i(a,b){for(var c=void 0,d=0;d<t.length;d++)if(t[d].space_left>=a.height&&t[d].x+t[d].width+a.width+f.PADDING-b<=f.FLOAT_EPSILON){c=t[d];break}t.push(a),void 0!==c?(a.x=c.x+c.width+f.PADDING,a.y=c.bottom,a.space_left=a.height,a.bottom=a.y,c.space_left-=a.height+f.PADDING,c.bottom+=a.height+f.PADDING):(a.y=s,s+=a.height+f.PADDING,a.x=l,a.bottom=a.y,a.space_left=a.height),a.y+a.height-q>-f.FLOAT_EPSILON&&(q=a.y+a.height-m),a.x+a.width-p>-f.FLOAT_EPSILON&&(p=a.x+a.width-l)}function j(a){var b=0;return a.forEach(function(a){return b+=a.width+f.PADDING}),b}function k(){return p/q}void 0===e&&(e=1),void 0===g&&(g=!0);var l=0,m=0,n=b,o=c,e=void 0!==e?e:1,d=void 0!==d?d:0,p=0,q=0,r=0,s=0,t=[];0!=a.length&&(function(a){function b(a){var b=Number.MAX_VALUE,c=Number.MAX_VALUE,e=0,f=0;a.array.forEach(function(a){var g=void 0!==a.width?a.width:d,h=void 0!==a.height?a.height:d;g/=2,h/=2,e=Math.max(a.x+g,e),b=Math.min(a.x-g,b),f=Math.max(a.y+h,f),c=Math.min(a.y-h,c)}),a.width=e-b,a.height=f-c}a.forEach(function(a){b(a)})}(a),function(a,b){var c=Number.POSITIVE_INFINITY,d=0;a.sort(function(a,b){return b.height-a.height}),r=a.reduce(function(a,b){return a.width<b.width?a.width:b.width});for(var e=p=r,g=q=j(a),i=0,k=Number.MAX_VALUE,l=Number.MAX_VALUE,m=-1,n=Number.MAX_VALUE,o=Number.MAX_VALUE;n>r||o>f.FLOAT_EPSILON;){if(1!=m)var p=g-(g-e)/f.GOLDEN_SECTION,k=h(a,p);if(0!=m)var q=e+(g-e)/f.GOLDEN_SECTION,l=h(a,q);if(n=Math.abs(p-q),o=Math.abs(k-l),k<c&&(c=k,d=p),l<c&&(c=l,d=q),k>l?(e=p,p=q,k=l,m=1):(g=q,q=p,l=k,m=0),i++>100)break}h(a,d)}(a),g&&function(a){a.forEach(function(a){var b={x:0,y:0};a.array.forEach(function(a){b.x+=a.x,b.y+=a.y}),b.x/=a.array.length,b.y/=a.array.length;var c={x:b.x-a.width/2,y:b.y-a.height/2},d={x:a.x-c.x+n/2-p/2,y:a.y-c.y+o/2-q/2};a.array.forEach(function(a){a.x+=d.x,a.y+=d.y})})}(a))}function e(a,b){function c(a,b){if(void 0===d[a.index]){b&&(g++,f.push({array:[]})),d[a.index]=g,f[g-1].array.push(a);var h=e[a.index];if(h)for(var i=0;i<h.length;i++)c(h[i],!1)}}for(var d={},e={},f=[],g=0,h=0;h<b.length;h++){var i=b[h],j=i.source,k=i.target;e[j.index]?e[j.index].push(k):e[j.index]=[k],e[k.index]?e[k.index].push(j):e[k.index]=[j]}for(var h=0;h<a.length;h++){var l=a[h];d[l.index]||c(l,!0)}return f}Object.defineProperty(c,"__esModule",{value:!0});var f={PADDING:10,GOLDEN_SECTION:(1+Math.sqrt(5))/2,FLOAT_EPSILON:1e-4,MAX_INERATIONS:100};c.applyPacking=d,c.separateGraphs=e},{}],11:[function(a,b,c){"use strict";function d(a){return void 0!==a.leaves||void 0!==a.groups}Object.defineProperty(c,"__esModule",{value:!0});var e,f=a("./powergraph"),g=a("./linklengths"),h=a("./descent"),i=a("./rectangle"),j=a("./shortestpaths"),k=a("./geom"),l=a("./handledisconnected");!function(a){a[a.start=0]="start",a[a.tick=1]="tick",a[a.end=2]="end"}(e=c.EventType||(c.EventType={}));var m=function(){function a(){var b=this;this._canvasSize=[1,1],this._linkDistance=20,this._defaultNodeSize=10,this._linkLengthCalculator=null,this._linkType=null,this._avoidOverlaps=!1,this._handleDisconnected=!0,this._running=!1,this._nodes=[],
this._groups=[],this._rootGroup=null,this._links=[],this._constraints=[],this._distanceMatrix=null,this._descent=null,this._directedLinkConstraints=null,this._threshold=.01,this._visibilityGraph=null,this._groupCompactness=1e-6,this.event=null,this.linkAccessor={getSourceIndex:a.getSourceIndex,getTargetIndex:a.getTargetIndex,setLength:a.setLinkLength,getType:function(a){return"function"==typeof b._linkType?b._linkType(a):0}}}return a.prototype.on=function(a,b){return this.event||(this.event={}),"string"==typeof a?this.event[e[a]]=b:this.event[a]=b,this},a.prototype.trigger=function(a){this.event&&void 0!==this.event[a.type]&&this.event[a.type](a)},a.prototype.kick=function(){for(;!this.tick(););},a.prototype.tick=function(){if(this._alpha<this._threshold)return this._running=!1,this.trigger({type:e.end,alpha:this._alpha=0,stress:this._lastStress}),!0;var a,b,c=this._nodes.length;this._links.length;for(this._descent.locks.clear(),b=0;b<c;++b)if(a=this._nodes[b],a.fixed){void 0!==a.px&&void 0!==a.py||(a.px=a.x,a.py=a.y);var d=[a.px,a.py];this._descent.locks.add(b,d)}var f=this._descent.rungeKutta();return 0===f?this._alpha=0:void 0!==this._lastStress&&(this._alpha=f),this._lastStress=f,this.updateNodePositions(),this.trigger({type:e.tick,alpha:this._alpha,stress:this._lastStress}),!1},a.prototype.updateNodePositions=function(){for(var a,b=this._descent.x[0],c=this._descent.x[1],d=this._nodes.length;d--;)a=this._nodes[d],a.x=b[d],a.y=c[d]},a.prototype.nodes=function(a){if(!a){if(0===this._nodes.length&&this._links.length>0){var b=0;this._links.forEach(function(a){b=Math.max(b,a.source,a.target)}),this._nodes=new Array(++b);for(var c=0;c<b;++c)this._nodes[c]={}}return this._nodes}return this._nodes=a,this},a.prototype.groups=function(a){var b=this;return a?(this._groups=a,this._rootGroup={},this._groups.forEach(function(a){void 0===a.padding&&(a.padding=1),void 0!==a.leaves&&a.leaves.forEach(function(c,d){"number"==typeof c&&((a.leaves[d]=b._nodes[c]).parent=a)}),void 0!==a.groups&&a.groups.forEach(function(c,d){"number"==typeof c&&((a.groups[d]=b._groups[c]).parent=a)})}),this._rootGroup.leaves=this._nodes.filter(function(a){return void 0===a.parent}),this._rootGroup.groups=this._groups.filter(function(a){return void 0===a.parent}),this):this._groups},a.prototype.powerGraphGroups=function(a){var b=f.getGroups(this._nodes,this._links,this.linkAccessor,this._rootGroup);return this.groups(b.groups),a(b),this},a.prototype.avoidOverlaps=function(a){return arguments.length?(this._avoidOverlaps=a,this):this._avoidOverlaps},a.prototype.handleDisconnected=function(a){return arguments.length?(this._handleDisconnected=a,this):this._handleDisconnected},a.prototype.flowLayout=function(a,b){return arguments.length||(a="y"),this._directedLinkConstraints={axis:a,getMinSeparation:"number"==typeof b?function(){return b}:b},this},a.prototype.links=function(a){return arguments.length?(this._links=a,this):this._links},a.prototype.constraints=function(a){return arguments.length?(this._constraints=a,this):this._constraints},a.prototype.distanceMatrix=function(a){return arguments.length?(this._distanceMatrix=a,this):this._distanceMatrix},a.prototype.size=function(a){return a?(this._canvasSize=a,this):this._canvasSize},a.prototype.defaultNodeSize=function(a){return a?(this._defaultNodeSize=a,this):this._defaultNodeSize},a.prototype.groupCompactness=function(a){return a?(this._groupCompactness=a,this):this._groupCompactness},a.prototype.linkDistance=function(a){return a?(this._linkDistance="function"==typeof a?a:+a,this._linkLengthCalculator=null,this):this._linkDistance},a.prototype.linkType=function(a){return this._linkType=a,this},a.prototype.convergenceThreshold=function(a){return a?(this._threshold="function"==typeof a?a:+a,this):this._threshold},a.prototype.alpha=function(a){return arguments.length?(a=+a,this._alpha?this._alpha=a>0?a:0:a>0&&(this._running||(this._running=!0,this.trigger({type:e.start,alpha:this._alpha=a}),this.kick())),this):this._alpha},a.prototype.getLinkLength=function(a){return"function"==typeof this._linkDistance?+this._linkDistance(a):this._linkDistance},a.setLinkLength=function(a,b){a.length=b},a.prototype.getLinkType=function(a){return"function"==typeof this._linkType?this._linkType(a):0},a.prototype.symmetricDiffLinkLengths=function(a,b){var c=this;return void 0===b&&(b=1),this.linkDistance(function(b){return a*b.length}),this._linkLengthCalculator=function(){return g.symmetricDiffLinkLengths(c._links,c.linkAccessor,b)},this},a.prototype.jaccardLinkLengths=function(a,b){var c=this;return void 0===b&&(b=1),this.linkDistance(function(b){return a*b.length}),this._linkLengthCalculator=function(){return g.jaccardLinkLengths(c._links,c.linkAccessor,b)},this},a.prototype.start=function(b,c,d,e,f,k){var l=this;void 0===b&&(b=0),void 0===c&&(c=0),void 0===d&&(d=0),void 0===e&&(e=0),void 0===f&&(f=!0),void 0===k&&(k=!0);var m,n=this.nodes().length,o=n+2*this._groups.length,p=(this._links.length,this._canvasSize[0]),q=this._canvasSize[1],r=new Array(o),s=new Array(o),t=null,u=this._avoidOverlaps;this._nodes.forEach(function(a,b){a.index=b,void 0===a.x&&(a.x=p/2,a.y=q/2),r[b]=a.x,s[b]=a.y}),this._linkLengthCalculator&&this._linkLengthCalculator();var v;this._distanceMatrix?v=this._distanceMatrix:(v=new j.Calculator(o,this._links,a.getSourceIndex,a.getTargetIndex,function(a){return l.getLinkLength(a)}).DistanceMatrix(),t=h.Descent.createSquareMatrix(o,function(){return 2}),this._links.forEach(function(a){"number"==typeof a.source&&(a.source=l._nodes[a.source]),"number"==typeof a.target&&(a.target=l._nodes[a.target])}),this._links.forEach(function(b){var c=a.getSourceIndex(b),d=a.getTargetIndex(b);t[c][d]=t[d][c]=b.weight||1}));var w=h.Descent.createSquareMatrix(o,function(a,b){return v[a][b]});if(this._rootGroup&&void 0!==this._rootGroup.groups){var m=n,x=function(a,b,c,d){t[a][b]=t[b][a]=c,w[a][b]=w[b][a]=d};this._groups.forEach(function(a){x(m,m+1,l._groupCompactness,.1),void 0===a.bounds?(r[m]=p/2,s[m++]=q/2,r[m]=p/2,s[m++]=q/2):(r[m]=a.bounds.x,s[m++]=a.bounds.y,r[m]=a.bounds.X,s[m++]=a.bounds.Y)})}else this._rootGroup={leaves:this._nodes,groups:[]};var y=this._constraints||[];this._directedLinkConstraints&&(this.linkAccessor.getMinSeparation=this._directedLinkConstraints.getMinSeparation,y=y.concat(g.generateDirectedEdgeConstraints(n,this._links,this._directedLinkConstraints.axis,this.linkAccessor))),this.avoidOverlaps(!1),this._descent=new h.Descent([r,s],w),this._descent.locks.clear();for(var m=0;m<n;++m){var z=this._nodes[m];if(z.fixed){z.px=z.x,z.py=z.y;var A=[z.x,z.y];this._descent.locks.add(m,A)}}if(this._descent.threshold=this._threshold,this.initialLayout(b,r,s),y.length>0&&(this._descent.project=new i.Projection(this._nodes,this._groups,this._rootGroup,y).projectFunctions()),this._descent.run(c),this.separateOverlappingComponents(p,q,k),this.avoidOverlaps(u),u&&(this._nodes.forEach(function(a,b){a.x=r[b],a.y=s[b]}),this._descent.project=new i.Projection(this._nodes,this._groups,this._rootGroup,y,!0).projectFunctions(),this._nodes.forEach(function(a,b){r[b]=a.x,s[b]=a.y})),this._descent.G=t,this._descent.run(d),e){this._descent.snapStrength=1e3,this._descent.snapGridSize=this._nodes[0].width,this._descent.numGridSnapNodes=n,this._descent.scaleSnapByMaxH=n!=o;var B=h.Descent.createSquareMatrix(o,function(a,b){return a>=n||b>=n?t[a][b]:0});this._descent.G=B,this._descent.run(e)}return this.updateNodePositions(),this.separateOverlappingComponents(p,q,k),f?this.resume():this},a.prototype.initialLayout=function(b,c,d){if(this._groups.length>0&&b>0){var e=this._nodes.length,f=this._links.map(function(a){return{source:a.source.index,target:a.target.index}}),g=this._nodes.map(function(a){return{index:a.index}});this._groups.forEach(function(a,b){g.push({index:a.index=e+b})}),this._groups.forEach(function(a,b){void 0!==a.leaves&&a.leaves.forEach(function(b){return f.push({source:a.index,target:b.index})}),void 0!==a.groups&&a.groups.forEach(function(b){return f.push({source:a.index,target:b.index})})}),(new a).size(this.size()).nodes(g).links(f).avoidOverlaps(!1).linkDistance(this.linkDistance()).symmetricDiffLinkLengths(5).convergenceThreshold(1e-4).start(b,0,0,0,!1),this._nodes.forEach(function(a){c[a.index]=g[a.index].x,d[a.index]=g[a.index].y})}else this._descent.run(b)},a.prototype.separateOverlappingComponents=function(a,b,c){var d=this;if(void 0===c&&(c=!0),!this._distanceMatrix&&this._handleDisconnected){var e=this._descent.x[0],f=this._descent.x[1];this._nodes.forEach(function(a,b){a.x=e[b],a.y=f[b]});var g=l.separateGraphs(this._nodes,this._links);l.applyPacking(g,a,b,this._defaultNodeSize,1,c),this._nodes.forEach(function(a,b){d._descent.x[0][b]=a.x,d._descent.x[1][b]=a.y,a.bounds&&(a.bounds.setXCentre(a.x),a.bounds.setYCentre(a.y))})}},a.prototype.resume=function(){return this.alpha(.1)},a.prototype.stop=function(){return this.alpha(0)},a.prototype.prepareEdgeRouting=function(a){void 0===a&&(a=0),this._visibilityGraph=new k.TangentVisibilityGraph(this._nodes.map(function(b){return b.bounds.inflate(-a).vertices()}))},a.prototype.routeEdge=function(a,b,c){void 0===b&&(b=5);var d=[],e=new k.TangentVisibilityGraph(this._visibilityGraph.P,{V:this._visibilityGraph.V,E:this._visibilityGraph.E}),f={x:a.source.x,y:a.source.y},g={x:a.target.x,y:a.target.y},h=e.addPoint(f,a.source.index),l=e.addPoint(g,a.target.index);e.addEdgeIfVisible(f,g,a.source.index,a.target.index),void 0!==c&&c(e);var m=function(a){return a.source.id},n=function(a){return a.target.id},o=function(a){return a.length()},p=new j.Calculator(e.V.length,e.E,m,n,o),q=p.PathFromNodeToNode(h.id,l.id);if(1===q.length||q.length===e.V.length){var r=i.makeEdgeBetween(a.source.innerBounds,a.target.innerBounds,b);d=[r.sourceIntersection,r.arrowStart]}else{for(var s=q.length-2,t=e.V[q[s]].p,u=e.V[q[0]].p,d=[a.source.innerBounds.rayIntersection(t.x,t.y)],v=s;v>=0;--v)d.push(e.V[q[v]].p);d.push(i.makeEdgeTo(u,a.target.innerBounds,b))}return d},a.getSourceIndex=function(a){return"number"==typeof a.source?a.source:a.source.index},a.getTargetIndex=function(a){return"number"==typeof a.target?a.target:a.target.index},a.linkId=function(b){return a.getSourceIndex(b)+"-"+a.getTargetIndex(b)},a.dragStart=function(b){d(b)?a.storeOffset(b,a.dragOrigin(b)):(a.stopNode(b),b.fixed|=2)},a.stopNode=function(a){a.px=a.x,a.py=a.y},a.storeOffset=function(b,c){void 0!==b.leaves&&b.leaves.forEach(function(b){b.fixed|=2,a.stopNode(b),b._dragGroupOffsetX=b.x-c.x,b._dragGroupOffsetY=b.y-c.y}),void 0!==b.groups&&b.groups.forEach(function(b){return a.storeOffset(b,c)})},a.dragOrigin=function(a){return d(a)?{x:a.bounds.cx(),y:a.bounds.cy()}:a},a.drag=function(b,c){d(b)?(void 0!==b.leaves&&b.leaves.forEach(function(a){b.bounds.setXCentre(c.x),b.bounds.setYCentre(c.y),a.px=a._dragGroupOffsetX+c.x,a.py=a._dragGroupOffsetY+c.y}),void 0!==b.groups&&b.groups.forEach(function(b){return a.drag(b,c)})):(b.px=c.x,b.py=c.y)},a.dragEnd=function(b){d(b)?(void 0!==b.leaves&&b.leaves.forEach(function(b){a.dragEnd(b),delete b._dragGroupOffsetX,delete b._dragGroupOffsetY}),void 0!==b.groups&&b.groups.forEach(a.dragEnd)):b.fixed&=-7},a.mouseOver=function(a){a.fixed|=4,a.px=a.x,a.py=a.y},a.mouseOut=function(a){a.fixed&=-5},a}();c.Layout=m},{"./descent":7,"./geom":8,"./handledisconnected":10,"./linklengths":13,"./powergraph":14,"./rectangle":17,"./shortestpaths":18}],12:[function(a,b,c){"use strict";Object.defineProperty(c,"__esModule",{value:!0});var d=a("./shortestpaths"),e=a("./descent"),f=a("./rectangle"),g=a("./linklengths"),h=function(){function a(a,b){this.source=a,this.target=b}return a.prototype.actualLength=function(a){var b=this;return Math.sqrt(a.reduce(function(a,c){var d=c[b.target]-c[b.source];return a+d*d},0))},a}();c.Link3D=h;var i=function(){function a(a,b,c){void 0===a&&(a=0),void 0===b&&(b=0),void 0===c&&(c=0),this.x=a,this.y=b,this.z=c}return a}();c.Node3D=i;var j=function(){function a(b,c,d){var e=this;void 0===d&&(d=1),this.nodes=b,this.links=c,this.idealLinkLength=d,this.constraints=null,this.useJaccardLinkLengths=!0,this.result=new Array(a.k);for(var f=0;f<a.k;++f)this.result[f]=new Array(b.length);b.forEach(function(b,c){for(var d=0,f=a.dims;d<f.length;d++){var g=f[d];void 0===b[g]&&(b[g]=Math.random())}e.result[0][c]=b.x,e.result[1][c]=b.y,e.result[2][c]=b.z})}return a.prototype.linkLength=function(a){return a.actualLength(this.result)},a.prototype.start=function(a){var b=this;void 0===a&&(a=100);var c=this.nodes.length,h=new k;this.useJaccardLinkLengths&&g.jaccardLinkLengths(this.links,h,1.5),this.links.forEach(function(a){return a.length*=b.idealLinkLength});var i=new d.Calculator(c,this.links,function(a){return a.source},function(a){return a.target},function(a){return a.length}).DistanceMatrix(),j=e.Descent.createSquareMatrix(c,function(a,b){return i[a][b]}),l=e.Descent.createSquareMatrix(c,function(){return 2});this.links.forEach(function(a){var b=a.source,c=a.target;return l[b][c]=l[c][b]=1}),this.descent=new e.Descent(this.result,j),this.descent.threshold=.001,this.descent.G=l,this.constraints&&(this.descent.project=new f.Projection(this.nodes,null,null,this.constraints).projectFunctions());for(var m=0;m<this.nodes.length;m++){var n=this.nodes[m];n.fixed&&this.descent.locks.add(m,[n.x,n.y,n.z])}return this.descent.run(a),this},a.prototype.tick=function(){this.descent.locks.clear();for(var a=0;a<this.nodes.length;a++){var b=this.nodes[a];b.fixed&&this.descent.locks.add(a,[b.x,b.y,b.z])}return this.descent.rungeKutta()},a.dims=["x","y","z"],a.k=a.dims.length,a}();c.Layout3D=j;var k=function(){function a(){}return a.prototype.getSourceIndex=function(a){return a.source},a.prototype.getTargetIndex=function(a){return a.target},a.prototype.getLength=function(a){return a.length},a.prototype.setLength=function(a,b){a.length=b},a}()},{"./descent":7,"./linklengths":13,"./rectangle":17,"./shortestpaths":18}],13:[function(a,b,c){"use strict";function d(a,b){var c={};for(var d in a)c[d]={};for(var d in b)c[d]={};return Object.keys(c).length}function e(a,b){var c=0;for(var d in a)void 0!==b[d]&&++c;return c}function f(a,b){var c={},d=function(a,b){void 0===c[a]&&(c[a]={}),c[a][b]={}};return a.forEach(function(a){var c=b.getSourceIndex(a),e=b.getTargetIndex(a);d(c,e),d(e,c)}),c}function g(a,b,c,d){var e=f(a,d);a.forEach(function(a){var f=e[d.getSourceIndex(a)],g=e[d.getTargetIndex(a)];d.setLength(a,1+b*c(f,g))})}function h(a,b,c){void 0===c&&(c=1),g(a,c,function(a,b){return Math.sqrt(d(a,b)-e(a,b))},b)}function i(a,b,c){void 0===c&&(c=1),g(a,c,function(a,b){return Math.min(Object.keys(a).length,Object.keys(b).length)<1.1?0:e(a,b)/d(a,b)},b)}function j(a,b,c,d){var e=k(a,b,d),f={};e.forEach(function(a,b){return a.forEach(function(a){return f[a]=b})});var g=[];return b.forEach(function(a){var b=d.getSourceIndex(a),e=d.getTargetIndex(a);f[b]!==f[e]&&g.push({axis:c,left:b,right:e,gap:d.getMinSeparation(a)})}),g}function k(a,b,c){function d(a){a.index=a.lowlink=f++,g.push(a),a.onStack=!0;for(var b=0,c=a.out;b<c.length;b++){var e=c[b];void 0===e.index?(d(e),a.lowlink=Math.min(a.lowlink,e.lowlink)):e.onStack&&(a.lowlink=Math.min(a.lowlink,e.index))}if(a.lowlink===a.index){for(var i=[];g.length&&(e=g.pop(),e.onStack=!1,i.push(e),e!==a););h.push(i.map(function(a){return a.id}))}}for(var e=[],f=0,g=[],h=[],i=0;i<a;i++)e.push({id:i,out:[]});for(var j=0,k=b;j<k.length;j++){var l=k[j],m=e[c.getSourceIndex(l)],n=e[c.getTargetIndex(l)];m.out.push(n)}for(var o=0,p=e;o<p.length;o++){var q=p[o];void 0===q.index&&d(q)}return h}Object.defineProperty(c,"__esModule",{value:!0}),c.symmetricDiffLinkLengths=h,c.jaccardLinkLengths=i,c.generateDirectedEdgeConstraints=j,c.stronglyConnectedComponents=k},{}],14:[function(a,b,c){"use strict";function d(a,b,c){a.forAll(function(a){if(a.isLeaf())b.leaves||(b.leaves=[]),b.leaves.push(a.id);else{var e=b;if(a.gid=c.length,!a.isIsland()||a.isPredefined()){if(e={id:a.gid},a.isPredefined())for(var f in a.definition)e[f]=a.definition[f];b.groups||(b.groups=[]),b.groups.push(a.gid),c.push(e)}d(a.children,e,c)}})}function e(a,b){var c={};for(var d in a)d in b&&(c[d]=a[d]);return c}function f(a,b,c,d){for(var e=a.length,f=new h(e,b,c,d);f.greedyMerge(););var g=[],i=f.getGroupHierarchy(g);return g.forEach(function(b){var c=function(c){var d=b[c];"number"==typeof d&&(b[c]=a[d])};c("source"),c("target")}),{groups:i,powerEdges:g}}Object.defineProperty(c,"__esModule",{value:!0});var g=function(){function a(a,b,c){this.source=a,this.target=b,this.type=c}return a}();c.PowerEdge=g;var h=function(){function a(a,b,c,d){var e=this;if(this.linkAccessor=c,this.modules=new Array(a),this.roots=[],d)this.initModulesFromGroup(d);else{this.roots.push(new j);for(var f=0;f<a;++f)this.roots[0].add(this.modules[f]=new i(f))}this.R=b.length,b.forEach(function(a){var b=e.modules[c.getSourceIndex(a)],d=e.modules[c.getTargetIndex(a)],f=c.getType(a);b.outgoing.add(f,d),d.incoming.add(f,b)})}return a.prototype.initModulesFromGroup=function(a){var b=new j;this.roots.push(b);for(var c=0;c<a.leaves.length;++c){var d=a.leaves[c],e=new i(d.id);this.modules[d.id]=e,b.add(e)}if(a.groups)for(var f=0;f<a.groups.length;++f){var g=a.groups[f],h={};for(var l in g)"leaves"!==l&&"groups"!==l&&g.hasOwnProperty(l)&&(h[l]=g[l]);b.add(new i(-1-f,new k,new k,this.initModulesFromGroup(g),h))}return b},a.prototype.merge=function(a,b,c){void 0===c&&(c=0);var d=a.incoming.intersection(b.incoming),e=a.outgoing.intersection(b.outgoing),f=new j;f.add(a),f.add(b);var g=new i(this.modules.length,e,d,f);this.modules.push(g);var h=function(c,d,e){c.forAll(function(c,f){c.forAll(function(c){var h=c[d];h.add(f,g),h.remove(f,a),h.remove(f,b),a[e].remove(f,c),b[e].remove(f,c)})})};return h(e,"incoming","outgoing"),h(d,"outgoing","incoming"),this.R-=d.count()+e.count(),this.roots[c].remove(a),this.roots[c].remove(b),this.roots[c].add(g),g},a.prototype.rootMerges=function(a){void 0===a&&(a=0);for(var b=this.roots[a].modules(),c=b.length,d=new Array(c*(c-1)),e=0,f=0,g=c-1;f<g;++f)for(var h=f+1;h<c;++h){var i=b[f],j=b[h];d[e]={id:e,nEdges:this.nEdges(i,j),a:i,b:j},e++}return d},a.prototype.greedyMerge=function(){for(var a=0;a<this.roots.length;++a)if(!(this.roots[a].modules().length<2)){var b=this.rootMerges(a).sort(function(a,b){return a.nEdges==b.nEdges?a.id-b.id:a.nEdges-b.nEdges}),c=b[0];if(!(c.nEdges>=this.R))return this.merge(c.a,c.b,a),!0}},a.prototype.nEdges=function(a,b){var c=a.incoming.intersection(b.incoming),d=a.outgoing.intersection(b.outgoing);return this.R-c.count()-d.count()},a.prototype.getGroupHierarchy=function(a){var b=this,c=[],e={};return d(this.roots[0],e,c),this.allEdges().forEach(function(d){var e=b.modules[d.source],f=b.modules[d.target];a.push(new g(void 0===e.gid?d.source:c[e.gid],void 0===f.gid?d.target:c[f.gid],d.type))}),c},a.prototype.allEdges=function(){var b=[];return a.getEdges(this.roots[0],b),b},a.getEdges=function(b,c){b.forAll(function(b){b.getEdges(c),a.getEdges(b.children,c)})},a}();c.Configuration=h;var i=function(){function a(a,b,c,d,e){void 0===b&&(b=new k),void 0===c&&(c=new k),void 0===d&&(d=new j),this.id=a,this.outgoing=b,this.incoming=c,this.children=d,this.definition=e}return a.prototype.getEdges=function(a){var b=this;this.outgoing.forAll(function(c,d){c.forAll(function(c){a.push(new g(b.id,c.id,d))})})},a.prototype.isLeaf=function(){return 0===this.children.count()},a.prototype.isIsland=function(){return 0===this.outgoing.count()&&0===this.incoming.count()},a.prototype.isPredefined=function(){return void 0!==this.definition},a}();c.Module=i;var j=function(){function a(){this.table={}}return a.prototype.count=function(){return Object.keys(this.table).length},a.prototype.intersection=function(b){var c=new a;return c.table=e(this.table,b.table),c},a.prototype.intersectionCount=function(a){return this.intersection(a).count()},a.prototype.contains=function(a){return a in this.table},a.prototype.add=function(a){this.table[a.id]=a},a.prototype.remove=function(a){delete this.table[a.id]},a.prototype.forAll=function(a){for(var b in this.table)a(this.table[b])},a.prototype.modules=function(){var a=[];return this.forAll(function(b){b.isPredefined()||a.push(b)}),a},a}();c.ModuleSet=j;var k=function(){function a(){this.sets={},this.n=0}return a.prototype.count=function(){return this.n},a.prototype.contains=function(a){var b=!1;return this.forAllModules(function(c){b||c.id!=a||(b=!0)}),b},a.prototype.add=function(a,b){(a in this.sets?this.sets[a]:this.sets[a]=new j).add(b),++this.n},a.prototype.remove=function(a,b){var c=this.sets[a];c.remove(b),0===c.count()&&delete this.sets[a],--this.n},a.prototype.forAll=function(a){for(var b in this.sets)a(this.sets[b],Number(b))},a.prototype.forAllModules=function(a){this.forAll(function(b,c){return b.forAll(a)})},a.prototype.intersection=function(b){var c=new a;return this.forAll(function(a,d){if(d in b.sets){var e=a.intersection(b.sets[d]),f=e.count();f>0&&(c.sets[d]=e,c.n+=f)}}),c},a}();c.LinkSets=k,c.getGroups=f},{}],15:[function(a,b,c){"use strict";Object.defineProperty(c,"__esModule",{value:!0});var d=function(){function a(a){this.elem=a,this.subheaps=[]}return a.prototype.toString=function(a){for(var b="",c=!1,d=0;d<this.subheaps.length;++d){var e=this.subheaps[d];e.elem?(c&&(b+=","),b+=e.toString(a),c=!0):c=!1}return""!==b&&(b="("+b+")"),(this.elem?a(this.elem):"")+b},a.prototype.forEach=function(a){this.empty()||(a(this.elem,this),this.subheaps.forEach(function(b){return b.forEach(a)}))},a.prototype.count=function(){return this.empty()?0:1+this.subheaps.reduce(function(a,b){return a+b.count()},0)},a.prototype.min=function(){return this.elem},a.prototype.empty=function(){return null==this.elem},a.prototype.contains=function(a){if(this===a)return!0;for(var b=0;b<this.subheaps.length;b++)if(this.subheaps[b].contains(a))return!0;return!1},a.prototype.isHeap=function(a){var b=this;return this.subheaps.every(function(c){return a(b.elem,c.elem)&&c.isHeap(a)})},a.prototype.insert=function(b,c){return this.merge(new a(b),c)},a.prototype.merge=function(a,b){return this.empty()?a:a.empty()?this:b(this.elem,a.elem)?(this.subheaps.push(a),this):(a.subheaps.push(this),a)},a.prototype.removeMin=function(a){return this.empty()?null:this.mergePairs(a)},a.prototype.mergePairs=function(b){if(0==this.subheaps.length)return new a(null);if(1==this.subheaps.length)return this.subheaps[0];var c=this.subheaps.pop().merge(this.subheaps.pop(),b),d=this.mergePairs(b);return c.merge(d,b)},a.prototype.decreaseKey=function(b,c,d,e){var f=b.removeMin(e);b.elem=f.elem,b.subheaps=f.subheaps,null!==d&&null!==f.elem&&d(b.elem,b);var g=new a(c);return null!==d&&d(c,g),this.merge(g,e)},a}();c.PairingHeap=d;var e=function(){function a(a){this.lessThan=a}return a.prototype.top=function(){return this.empty()?null:this.root.elem},a.prototype.push=function(){for(var a=[],b=0;b<arguments.length;b++)a[b]=arguments[b];for(var c,e,f=0;e=a[f];++f)c=new d(e),this.root=this.empty()?c:this.root.merge(c,this.lessThan);return c},a.prototype.empty=function(){return!this.root||!this.root.elem},a.prototype.isHeap=function(){return this.root.isHeap(this.lessThan)},a.prototype.forEach=function(a){this.root.forEach(a)},a.prototype.pop=function(){if(this.empty())return null;var a=this.root.min();return this.root=this.root.removeMin(this.lessThan),a},a.prototype.reduceKey=function(a,b,c){void 0===c&&(c=null),this.root=this.root.decreaseKey(a,b,c,this.lessThan)},a.prototype.toString=function(a){return this.root.toString(a)},a.prototype.count=function(){return this.root.count()},a}();c.PriorityQueue=e},{}],16:[function(a,b,c){"use strict";var d=this&&this.__extends||function(){var a=function(b,c){return(a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])})(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c),b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}();Object.defineProperty(c,"__esModule",{value:!0});var e=function(){function a(){this.findIter=function(a){for(var b=this._root,c=this.iterator();null!==b;){var d=this._comparator(a,b.data);if(0===d)return c._cursor=b,c;c._ancestors.push(b),b=b.get_child(d>0)}return null}}return a.prototype.clear=function(){this._root=null,this.size=0},a.prototype.find=function(a){for(var b=this._root;null!==b;){var c=this._comparator(a,b.data);if(0===c)return b.data;b=b.get_child(c>0)}return null},a.prototype.lowerBound=function(a){return this._bound(a,this._comparator)},a.prototype.upperBound=function(a){function b(a,b){return c(b,a)}var c=this._comparator;return this._bound(a,b)},a.prototype.min=function(){var a=this._root;if(null===a)return null;for(;null!==a.left;)a=a.left;return a.data},a.prototype.max=function(){var a=this._root;if(null===a)return null;for(;null!==a.right;)a=a.right;return a.data},a.prototype.iterator=function(){return new f(this)},a.prototype.each=function(a){for(var b,c=this.iterator();null!==(b=c.next());)a(b)},a.prototype.reach=function(a){for(var b,c=this.iterator();null!==(b=c.prev());)a(b)},a.prototype._bound=function(a,b){for(var c=this._root,d=this.iterator();null!==c;){var e=this._comparator(a,c.data);if(0===e)return d._cursor=c,d;d._ancestors.push(c),c=c.get_child(e>0)}for(var f=d._ancestors.length-1;f>=0;--f)if(c=d._ancestors[f],b(a,c.data)>0)return d._cursor=c,d._ancestors.length=f,d;return d._ancestors.length=0,d},a}();c.TreeBase=e;var f=function(){function a(a){this._tree=a,this._ancestors=[],this._cursor=null}return a.prototype.data=function(){return null!==this._cursor?this._cursor.data:null},a.prototype.next=function(){if(null===this._cursor){var a=this._tree._root;null!==a&&this._minNode(a)}else if(null===this._cursor.right){var b;do{if(b=this._cursor,!this._ancestors.length){this._cursor=null;break}this._cursor=this._ancestors.pop()}while(this._cursor.right===b)}else this._ancestors.push(this._cursor),this._minNode(this._cursor.right);return null!==this._cursor?this._cursor.data:null},a.prototype.prev=function(){if(null===this._cursor){var a=this._tree._root;null!==a&&this._maxNode(a)}else if(null===this._cursor.left){var b;do{if(b=this._cursor,!this._ancestors.length){this._cursor=null;break}this._cursor=this._ancestors.pop()}while(this._cursor.left===b)}else this._ancestors.push(this._cursor),this._maxNode(this._cursor.left);return null!==this._cursor?this._cursor.data:null},a.prototype._minNode=function(a){for(;null!==a.left;)this._ancestors.push(a),a=a.left;this._cursor=a},a.prototype._maxNode=function(a){for(;null!==a.right;)this._ancestors.push(a),a=a.right;this._cursor=a},a}();c.Iterator=f;var g=function(){function a(a){this.data=a,this.left=null,this.right=null,this.red=!0}return a.prototype.get_child=function(a){return a?this.right:this.left},a.prototype.set_child=function(a,b){a?this.right=b:this.left=b},a}(),h=function(a){function b(b){var c=a.call(this)||this;return c._root=null,c._comparator=b,c.size=0,c}return d(b,a),b.prototype.insert=function(a){var c=!1;if(null===this._root)this._root=new g(a),c=!0,this.size++;else{var d=new g(void 0),e=!1,f=!1,h=null,i=d,j=null,k=this._root;for(i.right=this._root;;){if(null===k?(k=new g(a),j.set_child(e,k),c=!0,this.size++):b.is_red(k.left)&&b.is_red(k.right)&&(k.red=!0,k.left.red=!1,k.right.red=!1),b.is_red(k)&&b.is_red(j)){var l=i.right===h;k===j.get_child(f)?i.set_child(l,b.single_rotate(h,!f)):i.set_child(l,b.double_rotate(h,!f))}var m=this._comparator(k.data,a);if(0===m)break;f=e,e=m<0,null!==h&&(i=h),h=j,j=k,k=k.get_child(e)}this._root=d.right}return this._root.red=!1,c},b.prototype.remove=function(a){if(null===this._root)return!1;var c=new g(void 0),d=c;d.right=this._root;for(var e=null,f=null,h=null,i=!0;null!==d.get_child(i);){var j=i;f=e,e=d,d=d.get_child(i);var k=this._comparator(a,d.data);if(i=k>0,0===k&&(h=d),!b.is_red(d)&&!b.is_red(d.get_child(i)))if(b.is_red(d.get_child(!i))){var l=b.single_rotate(d,i);e.set_child(j,l),e=l}else if(!b.is_red(d.get_child(!i))){var m=e.get_child(!j);if(null!==m)if(b.is_red(m.get_child(!j))||b.is_red(m.get_child(j))){var n=f.right===e;b.is_red(m.get_child(j))?f.set_child(n,b.double_rotate(e,j)):b.is_red(m.get_child(!j))&&f.set_child(n,b.single_rotate(e,j));var o=f.get_child(n);o.red=!0,d.red=!0,o.left.red=!1,o.right.red=!1}else e.red=!1,m.red=!0,d.red=!0}}return null!==h&&(h.data=d.data,e.set_child(e.right===d,d.get_child(null===d.left)),this.size--),this._root=c.right,null!==this._root&&(this._root.red=!1),null!==h},b.is_red=function(a){return null!==a&&a.red},b.single_rotate=function(a,b){var c=a.get_child(!b);return a.set_child(!b,c.get_child(b)),c.set_child(b,a),a.red=!0,c.red=!1,c},b.double_rotate=function(a,c){return a.set_child(!c,b.single_rotate(a.get_child(!c),!c)),b.single_rotate(a,c)},b}(e);c.RBTree=h},{}],17:[function(a,b,c){"use strict";function d(a){return a.bounds=void 0!==a.leaves?a.leaves.reduce(function(a,b){return b.bounds.union(a)},u.empty()):u.empty(),void 0!==a.groups&&(a.bounds=a.groups.reduce(function(a,b){return d(b).union(a)},a.bounds)),a.bounds=a.bounds.inflate(a.padding),a.bounds}function e(a,b,c){var d=a.rayIntersection(b.cx(),b.cy())||{x:a.cx(),y:a.cy()},e=b.rayIntersection(a.cx(),a.cy())||{x:b.cx(),y:b.cy()},f=e.x-d.x,g=e.y-d.y,h=Math.sqrt(f*f+g*g),i=h-c;return{sourceIntersection:d,targetIntersection:e,arrowStart:{x:d.x+i*f/h,y:d.y+i*g/h}}}function f(a,b,c){var d=b.rayIntersection(a.x,a.y);d||(d={x:b.cx(),y:b.cy()});var e=d.x-a.x,f=d.y-a.y,g=Math.sqrt(e*e+f*f);return{x:d.x-c*e/g,y:d.y-c*f/g}}function g(a,b){return a.pos>b.pos?1:a.pos<b.pos?-1:a.isOpen?-1:b.isOpen?1:0}function h(){return new t.RBTree(function(a,b){return a.pos-b.pos})}function i(a,b,c,d){void 0===d&&(d=!1);var e=a.padding,f=void 0!==a.groups?a.groups.length:0,g=void 0!==a.leaves?a.leaves.length:0,h=f?a.groups.reduce(function(a,d){return a.concat(i(d,b,c,!0))},[]):[],k=(d?2:0)+g+f,l=new Array(k),m=new Array(k),n=0,o=function(a,b){m[n]=a,l[n++]=b};if(d){var p=a.bounds,q=b.getCentre(p),r=b.getSize(p)/2,s=b.getOpen(p),t=b.getClose(p),u=q-r+e/2,v=q+r-e/2;a.minVar.desiredPosition=u,o(b.makeRect(s,t,u,e),a.minVar),a.maxVar.desiredPosition=v,o(b.makeRect(s,t,v,e),a.maxVar)}g&&a.leaves.forEach(function(a){return o(a.bounds,a.variable)}),f&&a.groups.forEach(function(a){var c=a.bounds;o(b.makeRect(b.getOpen(c),b.getClose(c),b.getCentre(c),b.getSize(c)),a.minVar)});var w=j(m,l,b,c);return f&&(l.forEach(function(a){a.cOut=[],a.cIn=[]}),w.forEach(function(a){a.left.cOut.push(a),a.right.cIn.push(a)}),a.groups.forEach(function(a){var c=(a.padding-b.getSize(a.bounds))/2;a.minVar.cIn.forEach(function(a){return a.gap+=c}),a.minVar.cOut.forEach(function(b){b.left=a.maxVar,b.gap+=c})})),h.concat(w)}function j(a,b,c,d){var e,f=a.length,i=2*f;console.assert(b.length>=f);var j=new Array(i);for(e=0;e<f;++e){var k=a[e],l=new v(b[e],k,c.getCentre(k));j[e]=new w(!0,l,c.getOpen(k)),j[e+f]=new w(!1,l,c.getClose(k))}j.sort(g);var m=new Array,n=h();for(e=0;e<i;++e){var o=j[e],l=o.v;if(o.isOpen)n.insert(l),c.findNeighbours(l,n);else{n.remove(l);var p=function(a,b){var e=(c.getSize(a.r)+c.getSize(b.r))/2+d;m.push(new s.Constraint(a.v,b.v,e))},q=function(a,b,c){for(var d,e=l[a].iterator();null!==(d=e[a]());)c(d,l),d[b].remove(l)};q("prev","next",function(a,b){return p(a,b)}),q("next","prev",function(a,b){return p(b,a)})}}return console.assert(0===n.size),m}function k(a,b){var c=function(c,d){for(var e,f=b.findIter(a);null!==(e=f[c]());){var g=e.r.overlapX(a.r);if((g<=0||g<=e.r.overlapY(a.r))&&(a[c].insert(e),e[d].insert(a)),g<=0)break}};c("next","prev"),c("prev","next")}function l(a,b){var c=function(c,d){var e=b.findIter(a)[c]();null!==e&&e.r.overlapX(a.r)>0&&(a[c].insert(e),e[d].insert(a))};c("next","prev"),c("prev","next")}function m(a,b){return j(a,b,x,1e-6)}function n(a,b){return j(a,b,y,1e-6)}function o(a){return i(a,x,1e-6)}function p(a){return i(a,y,1e-6)}function q(a){var b=a.map(function(a){return new s.Variable(a.cx())}),c=m(a,b),d=new s.Solver(b,c);d.solve(),b.forEach(function(b,c){
return a[c].setXCentre(b.position())}),b=a.map(function(a){return new s.Variable(a.cy())}),c=n(a,b),d=new s.Solver(b,c),d.solve(),b.forEach(function(b,c){return a[c].setYCentre(b.position())})}var r=this&&this.__extends||function(){var a=function(b,c){return(a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])})(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c),b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}();Object.defineProperty(c,"__esModule",{value:!0});var s=a("./vpsc"),t=a("./rbtree");c.computeGroupBounds=d;var u=function(){function a(a,b,c,d){this.x=a,this.X=b,this.y=c,this.Y=d}return a.empty=function(){return new a(Number.POSITIVE_INFINITY,Number.NEGATIVE_INFINITY,Number.POSITIVE_INFINITY,Number.NEGATIVE_INFINITY)},a.prototype.cx=function(){return(this.x+this.X)/2},a.prototype.cy=function(){return(this.y+this.Y)/2},a.prototype.overlapX=function(a){var b=this.cx(),c=a.cx();return b<=c&&a.x<this.X?this.X-a.x:c<=b&&this.x<a.X?a.X-this.x:0},a.prototype.overlapY=function(a){var b=this.cy(),c=a.cy();return b<=c&&a.y<this.Y?this.Y-a.y:c<=b&&this.y<a.Y?a.Y-this.y:0},a.prototype.setXCentre=function(a){var b=a-this.cx();this.x+=b,this.X+=b},a.prototype.setYCentre=function(a){var b=a-this.cy();this.y+=b,this.Y+=b},a.prototype.width=function(){return this.X-this.x},a.prototype.height=function(){return this.Y-this.y},a.prototype.union=function(b){return new a(Math.min(this.x,b.x),Math.max(this.X,b.X),Math.min(this.y,b.y),Math.max(this.Y,b.Y))},a.prototype.lineIntersections=function(b,c,d,e){for(var f=[[this.x,this.y,this.X,this.y],[this.X,this.y,this.X,this.Y],[this.X,this.Y,this.x,this.Y],[this.x,this.Y,this.x,this.y]],g=[],h=0;h<4;++h){var i=a.lineIntersection(b,c,d,e,f[h][0],f[h][1],f[h][2],f[h][3]);null!==i&&g.push({x:i.x,y:i.y})}return g},a.prototype.rayIntersection=function(a,b){var c=this.lineIntersections(this.cx(),this.cy(),a,b);return c.length>0?c[0]:null},a.prototype.vertices=function(){return[{x:this.x,y:this.y},{x:this.X,y:this.y},{x:this.X,y:this.Y},{x:this.x,y:this.Y}]},a.lineIntersection=function(a,b,c,d,e,f,g,h){var i=c-a,j=g-e,k=d-b,l=h-f,m=l*i-j*k;if(0==m)return null;var n=a-e,o=b-f,p=j*o-l*n,q=p/m,r=i*o-k*n,s=r/m;return q>=0&&q<=1&&s>=0&&s<=1?{x:a+q*i,y:b+q*k}:null},a.prototype.inflate=function(b){return new a(this.x-b,this.X+b,this.y-b,this.Y+b)},a}();c.Rectangle=u,c.makeEdgeBetween=e,c.makeEdgeTo=f;var v=function(){function a(a,b,c){this.v=a,this.r=b,this.pos=c,this.prev=h(),this.next=h()}return a}(),w=function(){function a(a,b,c){this.isOpen=a,this.v=b,this.pos=c}return a}(),x={getCentre:function(a){return a.cx()},getOpen:function(a){return a.y},getClose:function(a){return a.Y},getSize:function(a){return a.width()},makeRect:function(a,b,c,d){return new u(c-d/2,c+d/2,a,b)},findNeighbours:k},y={getCentre:function(a){return a.cy()},getOpen:function(a){return a.x},getClose:function(a){return a.X},getSize:function(a){return a.height()},makeRect:function(a,b,c,d){return new u(a,b,c-d/2,c+d/2)},findNeighbours:l};c.generateXConstraints=m,c.generateYConstraints=n,c.generateXGroupConstraints=o,c.generateYGroupConstraints=p,c.removeOverlaps=q;var z=function(a){function b(b,c){var d=a.call(this,0,c)||this;return d.index=b,d}return r(b,a),b}(s.Variable);c.IndexedVariable=z;var A=function(){function a(a,b,c,e,f){var g=this;if(void 0===c&&(c=null),void 0===e&&(e=null),void 0===f&&(f=!1),this.nodes=a,this.groups=b,this.rootGroup=c,this.avoidOverlaps=f,this.variables=a.map(function(a,b){return a.variable=new z(b,1)}),e&&this.createConstraints(e),f&&c&&void 0!==c.groups){a.forEach(function(a){if(!a.width||!a.height)return void(a.bounds=new u(a.x,a.x,a.y,a.y));var b=a.width/2,c=a.height/2;a.bounds=new u(a.x-b,a.x+b,a.y-c,a.y+c)}),d(c);var h=a.length;b.forEach(function(a){g.variables[h]=a.minVar=new z(h++,void 0!==a.stiffness?a.stiffness:.01),g.variables[h]=a.maxVar=new z(h++,void 0!==a.stiffness?a.stiffness:.01)})}}return a.prototype.createSeparation=function(a){return new s.Constraint(this.nodes[a.left].variable,this.nodes[a.right].variable,a.gap,void 0!==a.equality&&a.equality)},a.prototype.makeFeasible=function(a){var b=this;if(this.avoidOverlaps){var c="x",d="width";"x"===a.axis&&(c="y",d="height");var e=a.offsets.map(function(a){return b.nodes[a.node]}).sort(function(a,b){return a[c]-b[c]}),f=null;e.forEach(function(a){if(f){var b=f[c]+f[d];b>a[c]&&(a[c]=b)}f=a})}},a.prototype.createAlignment=function(a){var b=this,c=this.nodes[a.offsets[0].node].variable;this.makeFeasible(a);var d="x"===a.axis?this.xConstraints:this.yConstraints;a.offsets.slice(1).forEach(function(a){var e=b.nodes[a.node].variable;d.push(new s.Constraint(c,e,a.offset,!0))})},a.prototype.createConstraints=function(a){var b=this,c=function(a){return void 0===a.type||"separation"===a.type};this.xConstraints=a.filter(function(a){return"x"===a.axis&&c(a)}).map(function(a){return b.createSeparation(a)}),this.yConstraints=a.filter(function(a){return"y"===a.axis&&c(a)}).map(function(a){return b.createSeparation(a)}),a.filter(function(a){return"alignment"===a.type}).forEach(function(a){return b.createAlignment(a)})},a.prototype.setupVariablesAndBounds=function(a,b,c,d){this.nodes.forEach(function(e,f){e.fixed?(e.variable.weight=e.fixedWeight?e.fixedWeight:1e3,c[f]=d(e)):e.variable.weight=1;var g=(e.width||0)/2,h=(e.height||0)/2,i=a[f],j=b[f];e.bounds=new u(i-g,i+g,j-h,j+h)})},a.prototype.xProject=function(a,b,c){(this.rootGroup||this.avoidOverlaps||this.xConstraints)&&this.project(a,b,a,c,function(a){return a.px},this.xConstraints,o,function(a){return a.bounds.setXCentre(c[a.variable.index]=a.variable.position())},function(a){var b=c[a.minVar.index]=a.minVar.position(),d=c[a.maxVar.index]=a.maxVar.position(),e=a.padding/2;a.bounds.x=b-e,a.bounds.X=d+e})},a.prototype.yProject=function(a,b,c){(this.rootGroup||this.yConstraints)&&this.project(a,b,b,c,function(a){return a.py},this.yConstraints,p,function(a){return a.bounds.setYCentre(c[a.variable.index]=a.variable.position())},function(a){var b=c[a.minVar.index]=a.minVar.position(),d=c[a.maxVar.index]=a.maxVar.position(),e=a.padding/2;a.bounds.y=b-e,a.bounds.Y=d+e})},a.prototype.projectFunctions=function(){var a=this;return[function(b,c,d){return a.xProject(b,c,d)},function(b,c,d){return a.yProject(b,c,d)}]},a.prototype.project=function(a,b,c,e,f,g,h,i,j){this.setupVariablesAndBounds(a,b,e,f),this.rootGroup&&this.avoidOverlaps&&(d(this.rootGroup),g=g.concat(h(this.rootGroup))),this.solve(this.variables,g,c,e),this.nodes.forEach(i),this.rootGroup&&this.avoidOverlaps&&(this.groups.forEach(j),d(this.rootGroup))},a.prototype.solve=function(a,b,c,d){var e=new s.Solver(a,b);e.setStartingPositions(c),e.setDesiredPositions(d),e.solve()},a}();c.Projection=A},{"./rbtree":16,"./vpsc":19}],18:[function(a,b,c){"use strict";Object.defineProperty(c,"__esModule",{value:!0});var d=a("./pqueue"),e=function(){function a(a,b){this.id=a,this.distance=b}return a}(),f=function(){function a(a){this.id=a,this.neighbours=[]}return a}(),g=function(){function a(a,b,c){this.node=a,this.prev=b,this.d=c}return a}(),h=function(){function a(a,b,c,d,g){this.n=a,this.es=b,this.neighbours=new Array(this.n);for(var h=this.n;h--;)this.neighbours[h]=new f(h);for(h=this.es.length;h--;){var i=this.es[h],j=c(i),k=d(i),l=g(i);this.neighbours[j].neighbours.push(new e(k,l)),this.neighbours[k].neighbours.push(new e(j,l))}}return a.prototype.DistanceMatrix=function(){for(var a=new Array(this.n),b=0;b<this.n;++b)a[b]=this.dijkstraNeighbours(b);return a},a.prototype.DistancesFromNode=function(a){return this.dijkstraNeighbours(a)},a.prototype.PathFromNodeToNode=function(a,b){return this.dijkstraNeighbours(a,b)},a.prototype.PathFromNodeToNodeWithPrevCost=function(a,b,c){var e=new d.PriorityQueue(function(a,b){return a.d<=b.d}),f=this.neighbours[a],h=new g(f,null,0),i={};for(e.push(h);!e.empty()&&(h=e.pop(),f=h.node,f.id!==b);)for(var j=f.neighbours.length;j--;){var k=f.neighbours[j],l=this.neighbours[k.id];if(!h.prev||l.id!==h.prev.node.id){var m=l.id+","+f.id;if(!(m in i&&i[m]<=h.d)){var n=h.prev?c(h.prev.node.id,f.id,l.id):0,o=h.d+k.distance+n;i[m]=o,e.push(new g(l,h,o))}}}for(var p=[];h.prev;)h=h.prev,p.push(h.node.id);return p},a.prototype.dijkstraNeighbours=function(a,b){void 0===b&&(b=-1);for(var c=new d.PriorityQueue(function(a,b){return a.d<=b.d}),e=this.neighbours.length,f=new Array(e);e--;){var g=this.neighbours[e];g.d=e===a?0:Number.POSITIVE_INFINITY,g.q=c.push(g)}for(;!c.empty();){var h=c.pop();if(f[h.id]=h.d,h.id===b){for(var i=[],j=h;void 0!==j.prev;)i.push(j.prev.id),j=j.prev;return i}for(e=h.neighbours.length;e--;){var k=h.neighbours[e],j=this.neighbours[k.id],l=h.d+k.distance;h.d!==Number.MAX_VALUE&&j.d>l&&(j.d=l,j.prev=h,c.reduceKey(j.q,j,function(a,b){return a.q=b}))}}return f},a}();c.Calculator=h},{"./pqueue":15}],19:[function(a,b,c){"use strict";function d(a,b,c){for(var d=a.map(function(a){return new g(a.desiredCenter)}),e=[],h=a.length,i=0;i<h-1;i++){var k=a[i],l=a[i+1];e.push(new f(d[i],d[i+1],(k.size+l.size)/2))}var m=d[0],n=d[h-1],o=a[0].size/2,p=a[h-1].size/2,q=null,r=null;return b&&(q=new g(b,1e3*m.weight),d.push(q),e.push(new f(q,m,o))),c&&(r=new g(c,1e3*n.weight),d.push(r),e.push(new f(n,r,p))),new j(d,e).solve(),{newCenters:d.slice(0,a.length).map(function(a){return a.position()}),lowerBound:q?q.position():m.position()-o,upperBound:r?r.position():n.position()+p}}Object.defineProperty(c,"__esModule",{value:!0});var e=function(){function a(a){this.scale=a,this.AB=0,this.AD=0,this.A2=0}return a.prototype.addVariable=function(a){var b=this.scale/a.scale,c=a.offset/a.scale,d=a.weight;this.AB+=d*b*c,this.AD+=d*b*a.desiredPosition,this.A2+=d*b*b},a.prototype.getPosn=function(){return(this.AD-this.AB)/this.A2},a}();c.PositionStats=e;var f=function(){function a(a,b,c,d){void 0===d&&(d=!1),this.left=a,this.right=b,this.gap=c,this.equality=d,this.active=!1,this.unsatisfiable=!1,this.left=a,this.right=b,this.gap=c,this.equality=d}return a.prototype.slack=function(){return this.unsatisfiable?Number.MAX_VALUE:this.right.scale*this.right.position()-this.gap-this.left.scale*this.left.position()},a}();c.Constraint=f;var g=function(){function a(a,b,c){void 0===b&&(b=1),void 0===c&&(c=1),this.desiredPosition=a,this.weight=b,this.scale=c,this.offset=0}return a.prototype.dfdv=function(){return 2*this.weight*(this.position()-this.desiredPosition)},a.prototype.position=function(){return(this.block.ps.scale*this.block.posn+this.offset)/this.scale},a.prototype.visitNeighbours=function(a,b){var c=function(c,d){return c.active&&a!==d&&b(c,d)};this.cOut.forEach(function(a){return c(a,a.right)}),this.cIn.forEach(function(a){return c(a,a.left)})},a}();c.Variable=g;var h=function(){function a(a){this.vars=[],a.offset=0,this.ps=new e(a.scale),this.addVariable(a)}return a.prototype.addVariable=function(a){a.block=this,this.vars.push(a),this.ps.addVariable(a),this.posn=this.ps.getPosn()},a.prototype.updateWeightedPosition=function(){this.ps.AB=this.ps.AD=this.ps.A2=0;for(var a=0,b=this.vars.length;a<b;++a)this.ps.addVariable(this.vars[a]);this.posn=this.ps.getPosn()},a.prototype.compute_lm=function(a,b,c){var d=this,e=a.dfdv();return a.visitNeighbours(b,function(b,f){var g=d.compute_lm(f,a,c);f===b.right?(e+=g*b.left.scale,b.lm=g):(e+=g*b.right.scale,b.lm=-g),c(b)}),e/a.scale},a.prototype.populateSplitBlock=function(a,b){var c=this;a.visitNeighbours(b,function(b,d){d.offset=a.offset+(d===b.right?b.gap:-b.gap),c.addVariable(d),c.populateSplitBlock(d,a)})},a.prototype.traverse=function(a,b,c,d){var e=this;void 0===c&&(c=this.vars[0]),void 0===d&&(d=null),c.visitNeighbours(d,function(d,f){b.push(a(d)),e.traverse(a,b,f,c)})},a.prototype.findMinLM=function(){var a=null;return this.compute_lm(this.vars[0],null,function(b){!b.equality&&(null===a||b.lm<a.lm)&&(a=b)}),a},a.prototype.findMinLMBetween=function(a,b){this.compute_lm(a,null,function(){});var c=null;return this.findPath(a,null,b,function(a,b){!a.equality&&a.right===b&&(null===c||a.lm<c.lm)&&(c=a)}),c},a.prototype.findPath=function(a,b,c,d){var e=this,f=!1;return a.visitNeighbours(b,function(b,g){f||g!==c&&!e.findPath(g,a,c,d)||(f=!0,d(b,g))}),f},a.prototype.isActiveDirectedPathBetween=function(a,b){if(a===b)return!0;for(var c=a.cOut.length;c--;){var d=a.cOut[c];if(d.active&&this.isActiveDirectedPathBetween(d.right,b))return!0}return!1},a.split=function(b){return b.active=!1,[a.createSplitBlock(b.left),a.createSplitBlock(b.right)]},a.createSplitBlock=function(b){var c=new a(b);return c.populateSplitBlock(b,null),c},a.prototype.splitBetween=function(b,c){var d=this.findMinLMBetween(b,c);if(null!==d){var e=a.split(d);return{constraint:d,lb:e[0],rb:e[1]}}return null},a.prototype.mergeAcross=function(a,b,c){b.active=!0;for(var d=0,e=a.vars.length;d<e;++d){var f=a.vars[d];f.offset+=c,this.addVariable(f)}this.posn=this.ps.getPosn()},a.prototype.cost=function(){for(var a=0,b=this.vars.length;b--;){var c=this.vars[b],d=c.position()-c.desiredPosition;a+=d*d*c.weight}return a},a}();c.Block=h;var i=function(){function a(a){this.vs=a;var b=a.length;for(this.list=new Array(b);b--;){var c=new h(a[b]);this.list[b]=c,c.blockInd=b}}return a.prototype.cost=function(){for(var a=0,b=this.list.length;b--;)a+=this.list[b].cost();return a},a.prototype.insert=function(a){a.blockInd=this.list.length,this.list.push(a)},a.prototype.remove=function(a){var b=this.list.length-1,c=this.list[b];this.list.length=b,a!==c&&(this.list[a.blockInd]=c,c.blockInd=a.blockInd)},a.prototype.merge=function(a){var b=a.left.block,c=a.right.block,d=a.right.offset-a.left.offset-a.gap;b.vars.length<c.vars.length?(c.mergeAcross(b,a,d),this.remove(b)):(b.mergeAcross(c,a,-d),this.remove(c))},a.prototype.forEach=function(a){this.list.forEach(a)},a.prototype.updateBlockPositions=function(){this.list.forEach(function(a){return a.updateWeightedPosition()})},a.prototype.split=function(a){var b=this;this.updateBlockPositions(),this.list.forEach(function(c){var d=c.findMinLM();null!==d&&d.lm<j.LAGRANGIAN_TOLERANCE&&(c=d.left.block,h.split(d).forEach(function(a){return b.insert(a)}),b.remove(c),a.push(d))})},a}();c.Blocks=i;var j=function(){function a(a,b){this.vs=a,this.cs=b,this.vs=a,a.forEach(function(a){a.cIn=[],a.cOut=[]}),this.cs=b,b.forEach(function(a){a.left.cOut.push(a),a.right.cIn.push(a)}),this.inactive=b.map(function(a){return a.active=!1,a}),this.bs=null}return a.prototype.cost=function(){return this.bs.cost()},a.prototype.setStartingPositions=function(a){this.inactive=this.cs.map(function(a){return a.active=!1,a}),this.bs=new i(this.vs),this.bs.forEach(function(b,c){return b.posn=a[c]})},a.prototype.setDesiredPositions=function(a){this.vs.forEach(function(b,c){return b.desiredPosition=a[c]})},a.prototype.mostViolated=function(){for(var b=Number.MAX_VALUE,c=null,d=this.inactive,e=d.length,f=e,g=0;g<e;++g){var h=d[g];if(!h.unsatisfiable){var i=h.slack();if((h.equality||i<b)&&(b=i,c=h,f=g,h.equality))break}}return f!==e&&(b<a.ZERO_UPPERBOUND&&!c.active||c.equality)&&(d[f]=d[e-1],d.length=e-1),c},a.prototype.satisfy=function(){null==this.bs&&(this.bs=new i(this.vs)),this.bs.split(this.inactive);for(var b=null;(b=this.mostViolated())&&(b.equality||b.slack()<a.ZERO_UPPERBOUND&&!b.active);){var c=b.left.block;if(c!==b.right.block)this.bs.merge(b);else{if(c.isActiveDirectedPathBetween(b.right,b.left)){b.unsatisfiable=!0;continue}var d=c.splitBetween(b.left,b.right);if(null===d){b.unsatisfiable=!0;continue}this.bs.insert(d.lb),this.bs.insert(d.rb),this.bs.remove(c),this.inactive.push(d.constraint),b.slack()>=0?this.inactive.push(b):this.bs.merge(b)}}},a.prototype.solve=function(){this.satisfy();for(var a=Number.MAX_VALUE,b=this.bs.cost();Math.abs(a-b)>1e-4;)this.satisfy(),a=b,b=this.bs.cost();return b},a.LAGRANGIAN_TOLERANCE=-1e-4,a.ZERO_UPPERBOUND=-1e-10,a}();c.Solver=j,c.removeOverlapInOneDimension=d},{}]},{},[1])(1)});

/*! @svgdotjs/svg.js v3.0.16 MIT*/;
var SVG=function(){"use strict";var t="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function e(t,e){return t(e={exports:{}},e.exports),e.exports}var n,r,i,o=function(t){return t&&t.Math==Math&&t},y=o("object"==typeof globalThis&&globalThis)||o("object"==typeof window&&window)||o("object"==typeof self&&self)||o("object"==typeof t&&t)||Function("return this")(),m=function(t){try{return!!t()}catch(t){return!0}},f=!m(function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a}),s={}.propertyIsEnumerable,u=Object.getOwnPropertyDescriptor,v={f:u&&!s.call({1:2},1)?function(t){var e=u(this,t);return!!e&&e.enumerable}:s},b=function(t,e){return{enumerable:!(1&t),configurable:!(2&t),writable:!(4&t),value:e}},a={}.toString,h=function(t){return a.call(t).slice(8,-1)},l="".split,_=m(function(){return!Object("z").propertyIsEnumerable(0)})?function(t){return"String"==h(t)?l.call(t,""):Object(t)}:Object,c=function(t){if(null==t)throw TypeError("Can't call method on "+t);return t},d=function(t){return _(c(t))},g=function(t){return"object"==typeof t?null!==t:"function"==typeof t},p=function(t,e){if(!g(t))return t;var n,r;if(e&&"function"==typeof(n=t.toString)&&!g(r=n.call(t)))return r;if("function"==typeof(n=t.valueOf)&&!g(r=n.call(t)))return r;if(!e&&"function"==typeof(n=t.toString)&&!g(r=n.call(t)))return r;throw TypeError("Can't convert object to primitive value")},w={}.hasOwnProperty,x=function(t,e){return w.call(t,e)},k=y.document,O=g(k)&&g(k.createElement),S=function(t){return O?k.createElement(t):{}},j=!f&&!m(function(){return 7!=Object.defineProperty(S("div"),"a",{get:function(){return 7}}).a}),M=Object.getOwnPropertyDescriptor,E={f:f?M:function(t,e){if(t=d(t),e=p(e,!0),j)try{return M(t,e)}catch(t){}if(x(t,e))return b(!v.f.call(t,e),t[e])}},T=function(t){if(!g(t))throw TypeError(String(t)+" is not an object");return t},C=Object.defineProperty,P={f:f?C:function(t,e,n){if(T(t),e=p(e,!0),T(n),j)try{return C(t,e,n)}catch(t){}if("get"in n||"set"in n)throw TypeError("Accessors not supported");return"value"in n&&(t[e]=n.value),t}},I=f?function(t,e,n){return P.f(t,e,b(1,n))}:function(t,e,n){return t[e]=n,t},N=function(e,n){try{I(y,e,n)}catch(t){y[e]=n}return n},D="__core-js_shared__",R=y[D]||N(D,{}),L=e(function(t){(t.exports=function(t,e){return R[t]||(R[t]=void 0!==e?e:{})})("versions",[]).push({version:"3.3.6",mode:"global",copyright:"© 2019 Denis Pushkarev (zloirock.ru)"})}),F=L("native-function-to-string",Function.toString),z=y.WeakMap,q="function"==typeof z&&/native code/.test(F.call(z)),Y=0,X=Math.random(),V=function(t){return"Symbol("+String(void 0===t?"":t)+")_"+(++Y+X).toString(36)},H=L("keys"),B=function(t){return H[t]||(H[t]=V(t))},U={},$=y.WeakMap;if(q){var Q=new $,W=Q.get,J=Q.has,Z=Q.set;n=function(t,e){return Z.call(Q,t,e),e},r=function(t){return W.call(Q,t)||{}},i=function(t){return J.call(Q,t)}}else{var K=B("state");U[K]=!0,n=function(t,e){return I(t,K,e),e},r=function(t){return x(t,K)?t[K]:{}},i=function(t){return x(t,K)}}var tt={set:n,get:r,has:i,enforce:function(t){return i(t)?r(t):n(t,{})},getterFor:function(n){return function(t){var e;if(!g(t)||(e=r(t)).type!==n)throw TypeError("Incompatible receiver, "+n+" required");return e}}},et=e(function(t){var e=tt.get,u=tt.enforce,a=String(F).split("toString");L("inspectSource",function(t){return F.call(t)}),(t.exports=function(t,e,n,r){var i=!!r&&!!r.unsafe,o=!!r&&!!r.enumerable,s=!!r&&!!r.noTargetGet;"function"==typeof n&&("string"!=typeof e||x(n,"name")||I(n,"name",e),u(n).source=a.join("string"==typeof e?e:"")),t!==y?(i?!s&&t[e]&&(o=!0):delete t[e],o?t[e]=n:I(t,e,n)):o?t[e]=n:N(e,n)})(Function.prototype,"toString",function(){return"function"==typeof this&&e(this).source||F.call(this)})}),nt=y,rt=function(t){return"function"==typeof t?t:void 0},it=function(t,e){return arguments.length<2?rt(nt[t])||rt(y[t]):nt[t]&&nt[t][e]||y[t]&&y[t][e]},ot=Math.ceil,st=Math.floor,ut=function(t){return isNaN(t=+t)?0:(0<t?st:ot)(t)},at=Math.min,ht=function(t){return 0<t?at(ut(t),9007199254740991):0},lt=Math.max,ct=Math.min,ft=function(t,e){var n=ut(t);return n<0?lt(n+e,0):ct(n,e)},vt=function(u){return function(t,e,n){var r,i=d(t),o=ht(i.length),s=ft(n,o);if(u&&e!=e){for(;s<o;)if((r=i[s++])!=r)return!0}else for(;s<o;s++)if((u||s in i)&&i[s]===e)return u||s||0;return!u&&-1}},dt={includes:vt(!0),indexOf:vt(!1)},pt=dt.indexOf,yt=function(t,e){var n,r=d(t),i=0,o=[];for(n in r)!x(U,n)&&x(r,n)&&o.push(n);for(;e.length>i;)x(r,n=e[i++])&&(~pt(o,n)||o.push(n));return o},mt=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"],gt=mt.concat("length","prototype"),wt={f:Object.getOwnPropertyNames||function(t){return yt(t,gt)}},bt={f:Object.getOwnPropertySymbols},_t=it("Reflect","ownKeys")||function(t){var e=wt.f(T(t)),n=bt.f;return n?e.concat(n(t)):e},xt=function(t,e){for(var n=_t(e),r=P.f,i=E.f,o=0;o<n.length;o++){var s=n[o];x(t,s)||r(t,s,i(e,s))}},kt=/#|\.prototype\./,Ot=function(t,e){var n=At[St(t)];return n==Mt||n!=jt&&("function"==typeof e?m(e):!!e)},St=Ot.normalize=function(t){return String(t).replace(kt,".").toLowerCase()},At=Ot.data={},jt=Ot.NATIVE="N",Mt=Ot.POLYFILL="P",Et=Ot,Tt=E.f,Ct=function(t,e){var n,r,i,o,s,u=t.target,a=t.global,h=t.stat;if(n=a?y:h?y[u]||N(u,{}):(y[u]||{}).prototype)for(r in e){if(o=e[r],i=t.noTargetGet?(s=Tt(n,r))&&s.value:n[r],!Et(a?r:u+(h?".":"#")+r,t.forced)&&void 0!==i){if(typeof o==typeof i)continue;xt(o,i)}(t.sham||i&&i.sham)&&I(o,"sham",!0),et(n,r,o,t)}},Pt=Object.keys||function(t){return yt(t,mt)},It=function(t){return Object(c(t))},Nt=Object.assign,Dt=!Nt||m(function(){var A={},e={},t=Symbol(),n="abcdefghijklmnopqrst";return A[t]=7,n.split("").forEach(function(t){e[t]=t}),7!=Nt({},A)[t]||Pt(Nt({},e)).join("")!=n})?function(t,e){for(var n=It(t),r=arguments.length,i=1,o=bt.f,s=v.f;i<r;)for(var u,a=_(arguments[i++]),h=o?Pt(a).concat(o(a)):Pt(a),l=h.length,c=0;c<l;)u=h[c++],f&&!s.call(a,u)||(n[u]=a[u]);return n}:Nt;Ct({target:"Object",stat:!0,forced:Object.assign!==Dt},{assign:Dt});var Rt,Lt,Ft=Array.isArray||function(t){return"Array"==h(t)},zt=function(t,e,n){var r=p(e);r in t?P.f(t,r,b(0,n)):t[r]=n},qt=!!Object.getOwnPropertySymbols&&!m(function(){return!String(Symbol())}),Yt=y.Symbol,Xt=L("wks"),Gt=function(t){return Xt[t]||(Xt[t]=qt&&Yt[t]||(qt?Yt:V)("Symbol."+t))},Vt=it("navigator","userAgent")||"",Ht=y.process,Bt=Ht&&Ht.versions,Ut=Bt&&Bt.v8;Ut?Lt=(Rt=Ut.split("."))[0]+Rt[1]:Vt&&(!(Rt=Vt.match(/Edge\/(\d+)/))||74<=Rt[1])&&(Rt=Vt.match(/Chrome\/(\d+)/))&&(Lt=Rt[1]);var $t=Lt&&+Lt,Qt=Gt("species"),Wt=function(e){return 51<=$t||!m(function(){var t=[];return(t.constructor={})[Qt]=function(){return{foo:1}},1!==t[e](Boolean).foo})},Jt=Gt("species"),Zt=[].slice,Kt=Math.max;Ct({target:"Array",proto:!0,forced:!Wt("slice")},{slice:function(t,e){var n,r,i,o=d(this),s=ht(o.length),u=ft(t,s),a=ft(void 0===e?s:e,s);if(Ft(o)&&("function"!=typeof(n=o.constructor)||n!==Array&&!Ft(n.prototype)?g(n)&&null===(n=n[Jt])&&(n=void 0):n=void 0,n===Array||void 0===n))return Zt.call(o,u,a);for(r=new(void 0===n?Array:n)(Kt(a-u,0)),i=0;u<a;u++,i++)u in o&&zt(r,i,o[u]);return r.length=i,r}});var te=P.f,ee=Function.prototype,ne=ee.toString,re=/^\s*function ([^ (]*)/;!f||"name"in ee||te(ee,"name",{configurable:!0,get:function(){try{return ne.call(this).match(re)[1]}catch(t){return""}}});var ie=wt.f,oe={}.toString,se="object"==typeof window&&window&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[],ue={f:function(t){return se&&"[object Window]"==oe.call(t)?function(t){try{return ie(t)}catch(t){return se.slice()}}(t):ie(d(t))}},ae=ue.f,he=m(function(){return!Object.getOwnPropertyNames(1)});function le(t){return(le="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function ce(t){return(ce="function"==typeof Symbol&&"symbol"===le(Symbol.iterator)?function(t){return le(t)}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":le(t)})(t)}Ct({target:"Object",stat:!0,forced:he},{getOwnPropertyNames:ae});var fe=f?Object.defineProperties:function(t,e){T(t);for(var n,r=Pt(e),i=r.length,o=0;o<i;)P.f(t,n=r[o++],e[n]);return t},ve=it("document","documentElement"),de=B("IE_PROTO"),pe="prototype",ye=function(){},me=function(){var t,e=S("iframe"),n=mt.length,r="script";for(e.style.display="none",ve.appendChild(e),e.src=String("javascript:"),(t=e.contentWindow.document).open(),t.write("<script>document.F=Object</"+r+">"),t.close(),me=t.F;n--;)delete me[pe][mt[n]];return me()},ge=Object.create||function(t,e){var n;return null!==t?(ye[pe]=T(t),n=new ye,ye[pe]=null,n[de]=t):n=me(),void 0===e?n:fe(n,e)};U[de]=!0;var we={f:Gt},be=P.f,_e=function(t){var Symbol=nt.Symbol||(nt.Symbol={});x(Symbol,t)||be(Symbol,t,{value:we.f(t)})},xe=P.f,ke=Gt("toStringTag"),Oe=function(t,e,n){t&&!x(t=n?t:t.prototype,ke)&&xe(t,ke,{configurable:!0,value:e})},Se=function(t){if("function"!=typeof t)throw TypeError(String(t)+" is not a function");return t},Ae=function(r,i,t){if(Se(r),void 0===i)return r;switch(t){case 0:return function(){return r.call(i)};case 1:return function(t){return r.call(i,t)};case 2:return function(t,e){return r.call(i,t,e)};case 3:return function(t,e,n){return r.call(i,t,e,n)}}return function(){return r.apply(i,arguments)}},je=Gt("species"),Me=function(t,e){var n;return Ft(t)&&("function"!=typeof(n=t.constructor)||n!==Array&&!Ft(n.prototype)?g(n)&&null===(n=n[je])&&(n=void 0):n=void 0),new(void 0===n?Array:n)(0===e?0:e)},Ee=[].push,Te=function(v){var d=1==v,p=2==v,y=3==v,m=4==v,g=6==v,w=5==v||g;return function(t,e,n,r){for(var i,o,s=It(t),u=_(s),a=Ae(e,n,3),h=ht(u.length),l=0,c=r||Me,f=d?c(t,h):p?c(t,0):void 0;l<h;l++)if((w||l in u)&&(o=a(i=u[l],l,s),v))if(d)f[l]=o;else if(o)switch(v){case 3:return!0;case 5:return i;case 6:return l;case 2:Ee.call(f,i)}else if(m)return!1;return g?-1:y||m?m:f}},Ce={forEach:Te(0),map:Te(1),filter:Te(2),some:Te(3),every:Te(4),find:Te(5),findIndex:Te(6)},Pe=Ce.forEach,Ie=B("hidden"),Ne="Symbol",De="prototype",Re=Gt("toPrimitive"),Le=tt.set,Fe=tt.getterFor(Ne),ze=Object[De],qe=y.Symbol,Ye=y.JSON,Xe=Ye&&Ye.stringify,Ge=E.f,Ve=P.f,He=ue.f,Be=v.f,Ue=L("symbols"),$e=L("op-symbols"),Qe=L("string-to-symbol-registry"),We=L("symbol-to-string-registry"),Je=L("wks"),Ze=y.QObject,Ke=!Ze||!Ze[De]||!Ze[De].findChild,tn=f&&m(function(){return 7!=ge(Ve({},"a",{get:function(){return Ve(this,"a",{value:7}).a}})).a})?function(t,e,n){var r=Ge(ze,e);r&&delete ze[e],Ve(t,e,n),r&&t!==ze&&Ve(ze,e,r)}:Ve,en=function(t,e){var n=Ue[t]=ge(qe[De]);return Le(n,{type:Ne,tag:t,description:e}),f||(n.description=e),n},nn=qt&&"symbol"==typeof qe.iterator?function(t){return"symbol"==typeof t}:function(t){return Object(t)instanceof qe},rn=function(t,e,n){t===ze&&rn($e,e,n),T(t);var r=p(e,!0);return T(n),x(Ue,r)?(n.enumerable?(x(t,Ie)&&t[Ie][r]&&(t[Ie][r]=!1),n=ge(n,{enumerable:b(0,!1)})):(x(t,Ie)||Ve(t,Ie,b(1,{})),t[Ie][r]=!0),tn(t,r,n)):Ve(t,r,n)},on=function(e,t){T(e);var n=d(t),r=Pt(n).concat(hn(n));return Pe(r,function(t){f&&!sn.call(n,t)||rn(e,t,n[t])}),e},sn=function(t){var e=p(t,!0),n=Be.call(this,e);return!(this===ze&&x(Ue,e)&&!x($e,e))&&(!(n||!x(this,e)||!x(Ue,e)||x(this,Ie)&&this[Ie][e])||n)},un=function(t,e){var n=d(t),r=p(e,!0);if(n!==ze||!x(Ue,r)||x($e,r)){var i=Ge(n,r);return!i||!x(Ue,r)||x(n,Ie)&&n[Ie][r]||(i.enumerable=!0),i}},an=function(t){var e=He(d(t)),n=[];return Pe(e,function(t){x(Ue,t)||x(U,t)||n.push(t)}),n},hn=function(t){var e=t===ze,n=He(e?$e:d(t)),r=[];return Pe(n,function(t){!x(Ue,t)||e&&!x(ze,t)||r.push(Ue[t])}),r};qt||(et((qe=function(){if(this instanceof qe)throw TypeError("Symbol is not a constructor");var t=arguments.length&&void 0!==arguments[0]?String(arguments[0]):void 0,e=V(t),n=function(t){this===ze&&n.call($e,t),x(this,Ie)&&x(this[Ie],e)&&(this[Ie][e]=!1),tn(this,e,b(1,t))};return f&&Ke&&tn(ze,e,{configurable:!0,set:n}),en(e,t)})[De],"toString",function(){return Fe(this).tag}),v.f=sn,P.f=rn,E.f=un,wt.f=ue.f=an,bt.f=hn,f&&(Ve(qe[De],"description",{configurable:!0,get:function(){return Fe(this).description}}),et(ze,"propertyIsEnumerable",sn,{unsafe:!0})),we.f=function(t){return en(Gt(t),t)}),Ct({global:!0,wrap:!0,forced:!qt,sham:!qt},{Symbol:qe}),Pe(Pt(Je),function(t){_e(t)}),Ct({target:Ne,stat:!0,forced:!qt},{for:function(t){var e=String(t);if(x(Qe,e))return Qe[e];var n=qe(e);return Qe[e]=n,We[n]=e,n},keyFor:function(t){if(!nn(t))throw TypeError(t+" is not a symbol");if(x(We,t))return We[t]},useSetter:function(){Ke=!0},useSimple:function(){Ke=!1}}),Ct({target:"Object",stat:!0,forced:!qt,sham:!f},{create:function(t,e){return void 0===e?ge(t):on(ge(t),e)},defineProperty:rn,defineProperties:on,getOwnPropertyDescriptor:un}),Ct({target:"Object",stat:!0,forced:!qt},{getOwnPropertyNames:an,getOwnPropertySymbols:hn}),Ct({target:"Object",stat:!0,forced:m(function(){bt.f(1)})},{getOwnPropertySymbols:function(t){return bt.f(It(t))}}),Ye&&Ct({target:"JSON",stat:!0,forced:!qt||m(function(){var t=qe();return"[null]"!=Xe([t])||"{}"!=Xe({a:t})||"{}"!=Xe(Object(t))})},{stringify:function(t){for(var e,n,r=[t],i=1;arguments.length>i;)r.push(arguments[i++]);if(n=e=r[1],(g(e)||void 0!==t)&&!nn(t))return Ft(e)||(e=function(t,e){if("function"==typeof n&&(e=n.call(this,t,e)),!nn(e))return e}),r[1]=e,Xe.apply(Ye,r)}}),qe[De][Re]||I(qe[De],Re,qe[De].valueOf),Oe(qe,Ne),U[Ie]=!0;var ln=P.f,cn=y.Symbol;if(f&&"function"==typeof cn&&(!("description"in cn.prototype)||void 0!==cn().description)){var fn={},vn=function(){var t=arguments.length<1||void 0===arguments[0]?void 0:String(arguments[0]),e=this instanceof vn?new cn(t):void 0===t?cn():cn(t);return""===t&&(fn[e]=!0),e};xt(vn,cn);var dn=vn.prototype=cn.prototype;dn.constructor=vn;var pn=dn.toString,yn="Symbol(test)"==String(cn("test")),mn=/^Symbol\((.*)\)[^)]+$/;ln(dn,"description",{configurable:!0,get:function(){var t=g(this)?this.valueOf():this,e=pn.call(t);if(x(fn,t))return"";var n=yn?e.slice(7,-1):e.replace(mn,"$1");return""===n?void 0:n}}),Ct({global:!0,forced:!0},{Symbol:vn})}_e("iterator");var gn=Gt("unscopables"),wn=Array.prototype;null==wn[gn]&&I(wn,gn,ge(null));var bn,_n,xn,kn=function(t){wn[gn][t]=!0},On={},Sn=!m(function(){function t(){}return t.prototype.constructor=null,Object.getPrototypeOf(new t)!==t.prototype}),An=B("IE_PROTO"),jn=Object.prototype,Mn=Sn?Object.getPrototypeOf:function(t){return t=It(t),x(t,An)?t[An]:"function"==typeof t.constructor&&t instanceof t.constructor?t.constructor.prototype:t instanceof Object?jn:null},En=Gt("iterator"),Tn=!1;[].keys&&("next"in(xn=[].keys())?(_n=Mn(Mn(xn)))!==Object.prototype&&(bn=_n):Tn=!0),null==bn&&(bn={}),x(bn,En)||I(bn,En,function(){return this});var Cn={IteratorPrototype:bn,BUGGY_SAFARI_ITERATORS:Tn},Pn=Cn.IteratorPrototype,In=function(){return this},Nn=Object.setPrototypeOf||("__proto__"in{}?function(){var n,r=!1,t={};try{(n=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__").set).call(t,[]),r=t instanceof Array}catch(t){}return function(t,e){return T(t),function(t){if(!g(t)&&null!==t)throw TypeError("Can't set "+String(t)+" as a prototype")}(e),r?n.call(t,e):t.__proto__=e,t}}():void 0),Dn=Cn.IteratorPrototype,Rn=Cn.BUGGY_SAFARI_ITERATORS,Ln=Gt("iterator"),Fn="values",zn="entries",qn=function(){return this},Yn=function(t,e,n,r,i,o,s){var u,a,h;a=r,h=e+" Iterator",(u=n).prototype=ge(Pn,{next:b(1,a)}),Oe(u,h,!1),On[h]=In;var l,c,f,v=function(t){if(t===i&&g)return g;if(!Rn&&t in y)return y[t];switch(t){case"keys":case Fn:case zn:return function(){return new n(this,t)}}return function(){return new n(this)}},d=e+" Iterator",p=!1,y=t.prototype,m=y[Ln]||y["@@iterator"]||i&&y[i],g=!Rn&&m||v(i),w="Array"==e&&y.entries||m;if(w&&(l=Mn(w.call(new t)),Dn!==Object.prototype&&l.next&&(Mn(l)!==Dn&&(Nn?Nn(l,Dn):"function"!=typeof l[Ln]&&I(l,Ln,qn)),Oe(l,d,!0))),i==Fn&&m&&m.name!==Fn&&(p=!0,g=function(){return m.call(this)}),y[Ln]!==g&&I(y,Ln,g),On[e]=g,i)if(c={values:v(Fn),keys:o?g:v("keys"),entries:v(zn)},s)for(f in c)!Rn&&!p&&f in y||et(y,f,c[f]);else Ct({target:e,proto:!0,forced:Rn||p},c);return c},Xn="Array Iterator",Gn=tt.set,Vn=tt.getterFor(Xn),Hn=Yn(Array,"Array",function(t,e){Gn(this,{type:Xn,target:d(t),index:0,kind:e})},function(){var t=Vn(this),e=t.target,n=t.kind,r=t.index++;return!e||r>=e.length?{value:t.target=void 0,done:!0}:"keys"==n?{value:r,done:!1}:"values"==n?{value:e[r],done:!1}:{value:[r,e[r]],done:!1}},"values");On.Arguments=On.Array,kn("keys"),kn("values"),kn("entries");var Bn=Gt("toStringTag"),Un="Arguments"==h(function(){return arguments}()),$n=function(t){var e,n,r;return void 0===t?"Undefined":null===t?"Null":"string"==typeof(n=function(t,e){try{return t[e]}catch(t){}}(e=Object(t),Bn))?n:Un?h(e):"Object"==(r=h(e))&&"function"==typeof e.callee?"Arguments":r},Qn={};Qn[Gt("toStringTag")]="z";var Wn="[object z]"!==String(Qn)?function(){return"[object "+$n(this)+"]"}:Qn.toString,Jn=Object.prototype;Wn!==Jn.toString&&et(Jn,"toString",Wn,{unsafe:!0});var Zn=!m(function(){return Object.isExtensible(Object.preventExtensions({}))}),Kn=e(function(t){var e=P.f,n=V("meta"),r=0,i=Object.isExtensible||function(){return!0},o=function(t){e(t,n,{value:{objectID:"O"+ ++r,weakData:{}}})},s=t.exports={REQUIRED:!1,fastKey:function(t,e){if(!g(t))return"symbol"==typeof t?t:("string"==typeof t?"S":"P")+t;if(!x(t,n)){if(!i(t))return"F";if(!e)return"E";o(t)}return t[n].objectID},getWeakData:function(t,e){if(!x(t,n)){if(!i(t))return!0;if(!e)return!1;o(t)}return t[n].weakData},onFreeze:function(t){return Zn&&s.REQUIRED&&i(t)&&!x(t,n)&&o(t),t}};U[n]=!0}),tr=Gt("iterator"),er=Array.prototype,nr=Gt("iterator"),rr=function(e,t,n,r){try{return r?t(T(n)[0],n[1]):t(n)}catch(t){var i=e.return;throw void 0!==i&&T(i.call(e)),t}},ir=e(function(t){var d=function(t,e){this.stopped=t,this.result=e};(t.exports=function(t,e,n,r,i){var o,s,u,a,h,l,c,f,v=Ae(e,n,r?2:1);if(i)o=t;else{if("function"!=typeof(s=function(t){if(null!=t)return t[nr]||t["@@iterator"]||On[$n(t)]}(t)))throw TypeError("Target is not iterable");if(void 0!==(f=s)&&(On.Array===f||er[tr]===f)){for(u=0,a=ht(t.length);u<a;u++)if((h=r?v(T(c=t[u])[0],c[1]):v(t[u]))&&h instanceof d)return h;return new d(!1)}o=s.call(t)}for(l=o.next;!(c=l.call(o)).done;)if("object"==typeof(h=rr(o,v,c.value,r))&&h&&h instanceof d)return h;return new d(!1)}).stop=function(t){return new d(!0,t)}}),or=function(t,e,n){if(!(t instanceof e))throw TypeError("Incorrect "+(n?n+" ":"")+"invocation");return t},sr=Gt("iterator"),ur=!1;try{var ar=0,hr={next:function(){return{done:!!ar++}},return:function(){ur=!0}};hr[sr]=function(){return this},Array.from(hr,function(){throw 2})}catch(t){}var lr=function(t,e,n){var r,i;return Nn&&"function"==typeof(r=e.constructor)&&r!==n&&g(i=r.prototype)&&i!==n.prototype&&Nn(t,i),t},cr=function(t,e,n){for(var r in e)et(t,r,e[r],n);return t},fr=Gt("species"),vr=P.f,dr=Kn.fastKey,pr=tt.set,yr=tt.getterFor,mr=(function(r,t,e,i,o){var s=y[r],u=s&&s.prototype,a=s,h=i?"set":"add",n={},l=function(t){var n=u[t];et(u,t,"add"==t?function(t){return n.call(this,0===t?0:t),this}:"delete"==t?function(t){return!(o&&!g(t))&&n.call(this,0===t?0:t)}:"get"==t?function(t){return o&&!g(t)?void 0:n.call(this,0===t?0:t)}:"has"==t?function(t){return!(o&&!g(t))&&n.call(this,0===t?0:t)}:function(t,e){return n.call(this,0===t?0:t,e),this})};if(Et(r,"function"!=typeof s||!(o||u.forEach&&!m(function(){(new s).entries().next()}))))a=e.getConstructor(t,r,i,h),Kn.REQUIRED=!0;else if(Et(r,!0)){var c=new a,f=c[h](o?{}:-0,1)!=c,v=m(function(){c.has(1)}),d=function(t,e){if(!e&&!ur)return!1;var n=!1;try{var r={};r[sr]=function(){return{next:function(){return{done:n=!0}}}},t(r)}catch(t){}return n}(function(t){new s(t)}),p=!o&&m(function(){for(var t=new s,e=5;e--;)t[h](e,e);return!t.has(-0)});d||(((a=t(function(t,e){or(t,a,r);var n=lr(new s,t,a);return null!=e&&ir(e,n[h],n,i),n})).prototype=u).constructor=a),(v||p)&&(l("delete"),l("has"),i&&l("get")),(p||f)&&l(h),o&&u.clear&&delete u.clear}n[r]=a,Ct({global:!0,forced:a!=s},n),Oe(a,r),o||e.setStrong(a,r,i)}("Set",function(t){return function(){return t(this,arguments.length?arguments[0]:void 0)}},{getConstructor:function(t,n,r,i){var o=t(function(t,e){or(t,o,n),pr(t,{type:n,index:ge(null),first:void 0,last:void 0,size:0}),f||(t.size=0),null!=e&&ir(e,t[i],t,r)}),u=yr(n),s=function(t,e,n){var r,i,o=u(t),s=a(t,e);return s?s.value=n:(o.last=s={index:i=dr(e,!0),key:e,value:n,previous:r=o.last,next:void 0,removed:!1},o.first||(o.first=s),r&&(r.next=s),f?o.size++:t.size++,"F"!==i&&(o.index[i]=s)),t},a=function(t,e){var n,r=u(t),i=dr(e);if("F"!==i)return r.index[i];for(n=r.first;n;n=n.next)if(n.key==e)return n};return cr(o.prototype,{clear:function(){for(var t=u(this),e=t.index,n=t.first;n;)n.removed=!0,n.previous&&(n.previous=n.previous.next=void 0),delete e[n.index],n=n.next;t.first=t.last=void 0,f?t.size=0:this.size=0},delete:function(t){var e=u(this),n=a(this,t);if(n){var r=n.next,i=n.previous;delete e.index[n.index],n.removed=!0,i&&(i.next=r),r&&(r.previous=i),e.first==n&&(e.first=r),e.last==n&&(e.last=i),f?e.size--:this.size--}return!!n},forEach:function(t){for(var e,n=u(this),r=Ae(t,1<arguments.length?arguments[1]:void 0,3);e=e?e.next:n.first;)for(r(e.value,e.key,this);e&&e.removed;)e=e.previous},has:function(t){return!!a(this,t)}}),cr(o.prototype,r?{get:function(t){var e=a(this,t);return e&&e.value},set:function(t,e){return s(this,0===t?0:t,e)}}:{add:function(t){return s(this,t=0===t?0:t,t)}}),f&&vr(o.prototype,"size",{get:function(){return u(this).size}}),o},setStrong:function(t,e,n){var r,i,o=e+" Iterator",s=yr(e),u=yr(o);Yn(t,e,function(t,e){pr(this,{type:o,target:t,state:s(t),kind:e,last:void 0})},function(){for(var t=u(this),e=t.kind,n=t.last;n&&n.removed;)n=n.previous;return t.target&&(t.last=n=n?n.next:t.state.first)?"keys"==e?{value:n.key,done:!1}:"values"==e?{value:n.value,done:!1}:{value:[n.key,n.value],done:!1}:{value:t.target=void 0,done:!0}},n?"entries":"values",!n,!0),r=it(e),i=P.f,f&&r&&!r[fr]&&i(r,fr,{configurable:!0,get:function(){return this}})}}),function(u){return function(t,e){var n,r,i=String(c(t)),o=ut(e),s=i.length;return o<0||s<=o?u?"":void 0:(n=i.charCodeAt(o))<55296||56319<n||o+1===s||(r=i.charCodeAt(o+1))<56320||57343<r?u?i.charAt(o):n:u?i.slice(o,o+2):r-56320+(n-55296<<10)+65536}}),gr={codeAt:mr(!1),charAt:mr(!0)},wr=gr.charAt,br="String Iterator",_r=tt.set,xr=tt.getterFor(br);Yn(String,"String",function(t){_r(this,{type:br,string:String(t),index:0})},function(){var t,e=xr(this),n=e.string,r=e.index;return r>=n.length?{value:void 0,done:!0}:(t=wr(n,r),e.index+=t.length,{value:t,done:!1})});var kr={CSSRuleList:0,CSSStyleDeclaration:0,CSSValueList:0,ClientRectList:0,DOMRectList:0,DOMStringList:0,DOMTokenList:1,DataTransferItemList:0,FileList:0,HTMLAllCollection:0,HTMLCollection:0,HTMLFormElement:0,HTMLSelectElement:0,MediaList:0,MimeTypeArray:0,NamedNodeMap:0,NodeList:1,PaintRequestList:0,Plugin:0,PluginArray:0,SVGLengthList:0,SVGNumberList:0,SVGPathSegList:0,SVGPointList:0,SVGStringList:0,SVGTransformList:0,SourceBufferList:0,StyleSheetList:0,TextTrackCueList:0,TextTrackList:0,TouchList:0},Or=Gt("iterator"),Sr=Gt("toStringTag"),Ar=Hn.values;for(var jr in kr){var Mr=y[jr],Er=Mr&&Mr.prototype;if(Er){if(Er[Or]!==Ar)try{I(Er,Or,Ar)}catch(t){Er[Or]=Ar}if(Er[Sr]||I(Er,Sr,jr),kr[jr])for(var Tr in Hn)if(Er[Tr]!==Hn[Tr])try{I(Er,Tr,Hn[Tr])}catch(t){Er[Tr]=Hn[Tr]}}}function Cr(t){return function(t){if(Array.isArray(t)){for(var e=0,n=new Array(t.length);e<t.length;e++)n[e]=t[e];return n}}(t)||function(t){if(Symbol.iterator in Object(t)||"[object Arguments]"===Object.prototype.toString.call(t))return Array.from(t)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}var Pr={},Ir=[];function Nr(t,e){if(Array.isArray(t)){var n=!0,r=!1,i=void 0;try{for(var o,s=t[Symbol.iterator]();!(n=(o=s.next()).done);n=!0){Nr(o.value,e)}}catch(t){r=!0,i=t}finally{try{n||null==s.return||s.return()}finally{if(r)throw i}}}else if("object"!==ce(t))Rr(Object.getOwnPropertyNames(e)),Pr[t]=Object.assign(Pr[t]||{},e);else for(var u in t)Nr(u,t[u])}function Dr(t){return Pr[t]||{}}function Rr(t){Ir.push.apply(Ir,Cr(t))}var Lr=dt.includes;Ct({target:"Array",proto:!0},{includes:function(t){return Lr(this,t,1<arguments.length?arguments[1]:void 0)}}),kn("includes");var Fr,zr,qr=function(){var t=T(this),e="";return t.global&&(e+="g"),t.ignoreCase&&(e+="i"),t.multiline&&(e+="m"),t.dotAll&&(e+="s"),t.unicode&&(e+="u"),t.sticky&&(e+="y"),e},Yr=RegExp.prototype.exec,Xr=String.prototype.replace,Gr=Yr,Vr=(Fr=/a/,zr=/b*/g,Yr.call(Fr,"a"),Yr.call(zr,"a"),0!==Fr.lastIndex||0!==zr.lastIndex),Hr=void 0!==/()??/.exec("")[1];(Vr||Hr)&&(Gr=function(t){var e,n,r,i,o=this;return Hr&&(n=new RegExp("^"+o.source+"$(?!\\s)",qr.call(o))),Vr&&(e=o.lastIndex),r=Yr.call(o,t),Vr&&r&&(o.lastIndex=o.global?r.index+r[0].length:e),Hr&&r&&1<r.length&&Xr.call(r[0],n,function(){for(i=1;i<arguments.length-2;i++)void 0===arguments[i]&&(r[i]=void 0)}),r});var Br=Gr;Ct({target:"RegExp",proto:!0,forced:/./.exec!==Br},{exec:Br});var Ur=Gt("match"),$r=function(t){var e;return g(t)&&(void 0!==(e=t[Ur])?!!e:"RegExp"==h(t))},Qr=Gt("match");Ct({target:"String",proto:!0,forced:!function(e){var n=/./;try{"/./"[e](n)}catch(t){try{return n[Qr]=!1,"/./"[e](n)}catch(t){}}return!1}("includes")},{includes:function(t){return!!~String(c(this)).indexOf(function(t){if($r(t))throw TypeError("The method doesn't accept regular expressions");return t}(t),1<arguments.length?arguments[1]:void 0)}});var Wr=Gt("species"),Jr=!m(function(){var t=/./;return t.exec=function(){var t=[];return t.groups={a:"7"},t},"7"!=="".replace(t,"$<a>")}),Zr=!m(function(){var t=/(?:)/,e=t.exec;t.exec=function(){return e.apply(this,arguments)};var n="ab".split(t);return 2!==n.length||"a"!==n[0]||"b"!==n[1]}),Kr=function(n,t,e,r){var i=Gt(n),o=!m(function(){var t={};return t[i]=function(){return 7},7!=""[n](t)}),s=o&&!m(function(){var t=!1,e=/a/;return"split"===n&&((e={constructor:{}}).constructor[Wr]=function(){return e},e.flags="",e[i]=/./[i]),e.exec=function(){return t=!0,null},e[i](""),!t});if(!o||!s||"replace"===n&&!Jr||"split"===n&&!Zr){var u=/./[i],a=e(i,""[n],function(t,e,n,r,i){return e.exec===Br?o&&!i?{done:!0,value:u.call(e,n,r)}:{done:!0,value:t.call(n,e,r)}:{done:!1}}),h=a[0],l=a[1];et(String.prototype,n,h),et(RegExp.prototype,i,2==t?function(t,e){return l.call(t,this,e)}:function(t){return l.call(t,this)}),r&&I(RegExp.prototype[i],"sham",!0)}},ti=gr.charAt,ei=function(t,e,n){return e+(n?ti(t,e).length:1)},ni=function(t,e){var n=t.exec;if("function"==typeof n){var r=n.call(t,e);if("object"!=typeof r)throw TypeError("RegExp exec method returned something other than an Object or null");return r}if("RegExp"!==h(t))throw TypeError("RegExp#exec called on incompatible receiver");return Br.call(t,e)},ri=Math.max,ii=Math.min,oi=Math.floor,si=/\$([$&'`]|\d\d?|<[^>]*>)/g,ui=/\$([$&'`]|\d\d?)/g;Kr("replace",2,function(i,_,x){return[function(t,e){var n=c(this),r=null==t?void 0:t[i];return void 0!==r?r.call(t,n,e):_.call(String(n),t,e)},function(t,e){var n=x(_,t,this,e);if(n.done)return n.value;var r=T(t),i=String(this),o="function"==typeof e;o||(e=String(e));var s=r.global;if(s){var u=r.unicode;r.lastIndex=0}for(var a=[];;){var h=ni(r,i);if(null===h)break;if(a.push(h),!s)break;""===String(h[0])&&(r.lastIndex=ei(i,ht(r.lastIndex),u))}for(var l,c="",f=0,v=0;v<a.length;v++){h=a[v];for(var d=String(h[0]),p=ri(ii(ut(h.index),i.length),0),y=[],m=1;m<h.length;m++)y.push(void 0===(l=h[m])?l:String(l));var g=h.groups;if(o){var w=[d].concat(y,p,i);void 0!==g&&w.push(g);var b=String(e.apply(void 0,w))}else b=k(d,i,p,y,g,e);f<=p&&(c+=i.slice(f,p)+b,f=p+d.length)}return c+i.slice(f)}];function k(o,s,u,a,h,t){var l=u+o.length,c=a.length,e=ui;return void 0!==h&&(h=It(h),e=si),_.call(t,e,function(t,e){var n;switch(e.charAt(0)){case"$":return"$";case"&":return o;case"`":return s.slice(0,u);case"'":return s.slice(l);case"<":n=h[e.slice(1,-1)];break;default:var r=+e;if(0===r)return t;if(c<r){var i=oi(r/10);return 0===i?t:i<=c?void 0===a[i-1]?e.charAt(1):a[i-1]+e.charAt(1):t}n=a[r-1]}return void 0===n?"":n})}});var ai,hi="\t\n\v\f\r                　\u2028\u2029\ufeff",li="["+hi+"]",ci=RegExp("^"+li+li+"*"),fi=RegExp(li+li+"*$"),vi=function(n){return function(t){var e=String(c(t));return 1&n&&(e=e.replace(ci,"")),2&n&&(e=e.replace(fi,"")),e}},di={start:vi(1),end:vi(2),trim:vi(3)},pi=di.trim;function yi(t,e){var n,r=t.length,i=[];for(n=0;n<r;n++)i.push(e(t[n]));return i}function mi(t){return t%360*Math.PI/180}function gi(t){return t.toLowerCase().replace(/-(.)/g,function(t,e){return e.toUpperCase()})}function wi(t){return t.replace(/([A-Z])/g,function(t,e){return"-"+e.toLowerCase()})}function bi(t){return t.charAt(0).toUpperCase()+t.slice(1)}function _i(t,e,n,r){return null!=e&&null!=n||(r=r||t.bbox(),null==e?e=r.width/r.height*n:null==n&&(n=r.height/r.width*e)),{width:e,height:n}}function xi(t,e){var n,r,i=t.origin;if("string"==typeof i||null==i){var o=(i||"center").toLowerCase().trim(),s=e.bbox(),u=s.height,a=s.width,h=s.x,l=s.y,c=o.includes("left")?h:o.includes("right")?h+a:h+a/2,f=o.includes("top")?l:o.includes("bottom")?l+u:l+u/2;n=null!=t.ox?t.ox:c,r=null!=t.oy?t.oy:f}else n=i[0],r=i[1];return[n,r]}Ct({target:"String",proto:!0,forced:(ai="trim",m(function(){return!!hi[ai]()||"​᠎"!="​᠎"[ai]()||hi[ai].name!==ai}))},{trim:function(){return pi(this)}});var ki={__proto__:null,map:yi,filter:function(t,e){var n,r=t.length,i=[];for(n=0;n<r;n++)e(t[n])&&i.push(t[n]);return i},radians:mi,degrees:function(t){return 180*t/Math.PI%360},camelCase:gi,unCamelCase:wi,capitalize:bi,proportionalSize:_i,getOrigin:xi},Oi="http://www.w3.org/2000/svg",Si="http://www.w3.org/2000/xmlns/",Ai="http://www.w3.org/1999/xlink",ji="http://svgjs.com/svgjs",Mi={__proto__:null,ns:Oi,xmlns:Si,xlink:Ai,svgjs:ji},Ei={window:"undefined"==typeof window?null:window,document:"undefined"==typeof document?null:document};function Ti(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}var Ci=function t(){Ti(this,t)},Pi={},Ii="___SYMBOL___ROOT___";function Ni(t){return Ei.document.createElementNS(Oi,t)}function Di(t){if(t instanceof Ci)return t;if("object"===ce(t))return Fi(t);if(null==t)return new Pi[Ii];if("string"==typeof t&&"<"!==t.charAt(0))return Fi(Ei.document.querySelector(t));var e=Ni("svg");return e.innerHTML=t,t=Fi(e.firstChild)}function Ri(t,e){return e instanceof Ei.window.Node?e:Ni(t)}function Li(t){if(!t)return null;if(t.instance instanceof Ci)return t.instance;var e=bi(t.nodeName||"Dom");return"LinearGradient"===e||"RadialGradient"===e?e="Gradient":Pi[e]||(e="Dom"),new Pi[e](t)}var Fi=Li;function zi(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:t.name,n=2<arguments.length&&void 0!==arguments[2]&&arguments[2];return Pi[e]=t,n&&(Pi[Ii]=t),Rr(Object.getOwnPropertyNames(t.prototype)),t}function qi(t){return Pi[t]}var Yi=1e3;function Xi(t){return"Svgjs"+bi(t)+Yi++}function Gi(t){for(var e=t.children.length-1;0<=e;e--)Gi(t.children[e]);return t.id?Li(t).id(Xi(t.nodeName)):Li(t)}function Vi(t,e,n){var r,i;for(i=(t=Array.isArray(t)?t:[t]).length-1;0<=i;i--)for(r in e){var o=e[r];n&&(o=Hi(e[r])),t[i].prototype[r]=o}}function Hi(i){return function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];var r=e[e.length-1];return!r||r.constructor!==Object||r instanceof Array?i.apply(this,e):i.apply(this,e.slice(0,-1)).attr(r)}}Nr("Dom",{siblings:function(){return this.parent().children()},position:function(){return this.parent().index(this)},next:function(){return this.siblings()[this.position()+1]},prev:function(){return this.siblings()[this.position()-1]},forward:function(){var t=this.position()+1,e=this.parent();return e.removeElement(this).add(this,t),"function"==typeof e.isRoot&&e.isRoot()&&e.node.appendChild(e.defs().node),this},backward:function(){var t=this.position();return 0<t&&this.parent().removeElement(this).add(this,t-1),this},front:function(){var t=this.parent();return t.node.appendChild(this.node),"function"==typeof t.isRoot&&t.isRoot()&&t.node.appendChild(t.defs().node),this},back:function(){return 0<this.position()&&this.parent().removeElement(this).add(this,0),this},before:function(t){(t=Di(t)).remove();var e=this.position();return this.parent().add(t,e),this},after:function(t){(t=Di(t)).remove();var e=this.position();return this.parent().add(t,e+1),this},insertBefore:function(t){return(t=Di(t)).before(this),this},insertAfter:function(t){return(t=Di(t)).after(this),this}});var Bi=Ce.filter;Ct({target:"Array",proto:!0,forced:!Wt("filter")},{filter:function(t){return Bi(this,t,1<arguments.length?arguments[1]:void 0)}});var Ui=function(t,e){var n=[][t];return!n||!m(function(){n.call(null,e||function(){throw 1},1)})},$i=dt.indexOf,Qi=[].indexOf,Wi=!!Qi&&1/[1].indexOf(1,-0)<0,Ji=Ui("indexOf");Ct({target:"Array",proto:!0,forced:Wi||Ji},{indexOf:function(t){return Wi?Qi.apply(this,arguments)||0:$i(this,t,1<arguments.length?arguments[1]:void 0)}});var Zi=[].join,Ki=_!=Object,to=Ui("join",",");Ct({target:"Array",proto:!0,forced:Ki||to},{join:function(t){return Zi.call(d(this),void 0===t?",":t)}});var eo=Gt("species"),no=[].push,ro=Math.min,io=4294967295,oo=!m(function(){return!RegExp(io,"y")});Kr("split",2,function(i,g,w){var b;return b="c"=="abbc".split(/(b)*/)[1]||4!="test".split(/(?:)/,-1).length||2!="ab".split(/(?:ab)*/).length||4!=".".split(/(.?)(.?)/).length||1<".".split(/()()/).length||"".split(/.?/).length?function(t,e){var n=String(c(this)),r=void 0===e?io:e>>>0;if(0===r)return[];if(void 0===t)return[n];if(!$r(t))return g.call(n,t,r);for(var i,o,s,u=[],a=(t.ignoreCase?"i":"")+(t.multiline?"m":"")+(t.unicode?"u":"")+(t.sticky?"y":""),h=0,l=new RegExp(t.source,a+"g");(i=Br.call(l,n))&&!(h<(o=l.lastIndex)&&(u.push(n.slice(h,i.index)),1<i.length&&i.index<n.length&&no.apply(u,i.slice(1)),s=i[0].length,h=o,u.length>=r));)l.lastIndex===i.index&&l.lastIndex++;return h===n.length?!s&&l.test("")||u.push(""):u.push(n.slice(h)),u.length>r?u.slice(0,r):u}:"0".split(void 0,0).length?function(t,e){return void 0===t&&0===e?[]:g.call(this,t,e)}:g,[function(t,e){var n=c(this),r=null==t?void 0:t[i];return void 0!==r?r.call(t,n,e):b.call(String(n),t,e)},function(t,e){var n=w(b,t,this,e,b!==g);if(n.done)return n.value;var r,i,o,s=T(t),u=String(this),a=(r=RegExp,void 0===(o=T(s).constructor)||null==(i=T(o)[eo])?r:Se(i)),h=s.unicode,l=(s.ignoreCase?"i":"")+(s.multiline?"m":"")+(s.unicode?"u":"")+(oo?"y":"g"),c=new a(oo?s:"^(?:"+s.source+")",l),f=void 0===e?io:e>>>0;if(0===f)return[];if(0===u.length)return null===ni(c,u)?[u]:[];for(var v=0,d=0,A=[];d<u.length;){c.lastIndex=oo?d:0;var p,y=ni(c,oo?u:u.slice(d));if(null===y||(p=ro(ht(c.lastIndex+(oo?0:d)),u.length))===v)d=ei(u,d,h);else{if(A.push(u.slice(v,d)),A.length===f)return A;for(var m=1;m<=y.length-1;m++)if(A.push(y[m]),A.length===f)return A;d=v=p}}return A.push(u.slice(v)),A}]},!oo);var so=/^([+-]?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?)([a-z%]*)$/i,uo=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i,ao=/rgb\((\d+),(\d+),(\d+)\)/,ho=/(#[a-z0-9\-_]+)/i,lo=/\)\s*,?\s*/,co=/\s/g,fo=/^#[a-f0-9]{3,6}$/i,vo=/^rgb\(/,po=/^(\s+)?$/,yo=/^[+-]?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,mo=/\.(jpg|jpeg|png|gif|svg)(\?[^=]+.*)?/i,go=/[\s,]+/,wo=/([^e])-/gi,bo=/[MLHVCSQTAZ]/gi,_o=/[MLHVCSQTAZ]/i,xo=/((\d?\.\d+(?:e[+-]?\d+)?)((?:\.\d+(?:e[+-]?\d+)?)+))+/gi,ko=/\./g,Oo={__proto__:null,numberAndUnit:so,hex:uo,rgb:ao,reference:ho,transforms:lo,whitespace:co,isHex:fo,isRgb:vo,isCss:/[^:]+:[^;]+;?/,isBlank:po,isNumber:yo,isPercent:/^-?[\d.]+%$/,isImage:mo,delimiter:go,hyphen:wo,pathLetters:bo,isPathLetter:_o,numbersWithDots:xo,dots:ko};Nr("Dom",{classes:function(){var t=this.attr("class");return null==t?[]:t.trim().split(go)},hasClass:function(t){return-1!==this.classes().indexOf(t)},addClass:function(t){if(!this.hasClass(t)){var e=this.classes();e.push(t),this.attr("class",e.join(" "))}return this},removeClass:function(e){return this.hasClass(e)&&this.attr("class",this.classes().filter(function(t){return t!==e}).join(" ")),this},toggleClass:function(t){return this.hasClass(t)?this.removeClass(t):this.addClass(t)}});var So=Ce.forEach,Ao=Ui("forEach")?function(t){return So(this,t,1<arguments.length?arguments[1]:void 0)}:[].forEach;for(var jo in Ct({target:"Array",proto:!0,forced:[].forEach!=Ao},{forEach:Ao}),kr){var Mo=y[jo],Eo=Mo&&Mo.prototype;if(Eo&&Eo.forEach!==Ao)try{I(Eo,"forEach",Ao)}catch(t){Eo.forEach=Ao}}Nr("Dom",{css:function(t,e){var n={};if(0===arguments.length)return this.node.style.cssText.split(/\s*;\s*/).filter(function(t){return!!t.length}).forEach(function(t){var e=t.split(/\s*:\s*/);n[e[0]]=e[1]}),n;if(arguments.length<2){if(Array.isArray(t)){var r=!0,i=!1,o=void 0;try{for(var s,u=t[Symbol.iterator]();!(r=(s=u.next()).done);r=!0){var a=gi(s.value);n[a]=this.node.style[a]}}catch(t){i=!0,o=t}finally{try{r||null==u.return||u.return()}finally{if(i)throw o}}return n}if("string"==typeof t)return this.node.style[gi(t)];if("object"===ce(t))for(var h in t)this.node.style[gi(h)]=null==t[h]||po.test(t[h])?"":t[h]}return 2===arguments.length&&(this.node.style[gi(t)]=null==e||po.test(e)?"":e),this},show:function(){return this.css("display","")},hide:function(){return this.css("display","none")},visible:function(){return"none"!==this.css("display")}}),Nr("Dom",{data:function(e,t,n){if("object"===ce(e))for(t in e)this.data(t,e[t]);else if(arguments.length<2)try{return JSON.parse(this.attr("data-"+e))}catch(t){return this.attr("data-"+e)}else this.attr("data-"+e,null===t?null:!0===n||"string"==typeof t||"number"==typeof t?t:JSON.stringify(t));return this}}),Nr("Dom",{remember:function(t,e){if("object"===ce(t))for(var n in t)this.remember(n,t[n]);else{if(1===arguments.length)return this.memory()[t];this.memory()[t]=e}return this},forget:function(){if(0===arguments.length)this._memory={};else for(var t=arguments.length-1;0<=t;t--)delete this.memory()[arguments[t]];return this},memory:function(){return this._memory=this._memory||{}}});var To=function(h){return function(t,e,n,r){Se(e);var i=It(t),o=_(i),s=ht(i.length),u=h?s-1:0,a=h?-1:1;if(n<2)for(;;){if(u in o){r=o[u],u+=a;break}if(u+=a,h?u<0:s<=u)throw TypeError("Reduce of empty array with no initial value")}for(;h?0<=u:u<s;u+=a)u in o&&(r=e(r,o[u],u,i));return r}},Co={left:To(!1),right:To(!0)}.left;Ct({target:"Array",proto:!0,forced:Ui("reduce")},{reduce:function(t){return Co(this,t,arguments.length,1<arguments.length?arguments[1]:void 0)}});var Po=0,Io={};function No(t){var e=t.getEventHolder();return e===Ei.window&&(e=Io),e.events||(e.events={}),e.events}function Do(t){return t.getEventTarget()}function Ro(t,e,r,n,i){var o=r.bind(n||t),s=Di(t),u=No(s),a=Do(s);e=Array.isArray(e)?e:e.split(go),r._svgjsListenerId||(r._svgjsListenerId=++Po),e.forEach(function(t){var e=t.split(".")[0],n=t.split(".")[1]||"*";u[e]=u[e]||{},u[e][n]=u[e][n]||{},u[e][n][r._svgjsListenerId]=o,a.addEventListener(e,o,i||!1)})}function Lo(t,e,s,u){var a=Di(t),h=No(a),l=Do(a);("function"!=typeof s||(s=s._svgjsListenerId))&&(e=Array.isArray(e)?e:(e||"").split(go)).forEach(function(t){var e,n,r,i=t&&t.split(".")[0],o=t&&t.split(".")[1];if(s)h[i]&&h[i][o||"*"]&&(l.removeEventListener(i,h[i][o||"*"][s],u||!1),delete h[i][o||"*"][s]);else if(i&&o){if(h[i]&&h[i][o]){for(n in h[i][o])Lo(l,[i,o].join("."),n);delete h[i][o]}}else if(o)for(t in h)for(e in h[t])o===e&&Lo(l,[t,o].join("."));else if(i){if(h[i]){for(e in h[i])Lo(l,[i,e].join("."));delete h[i]}}else{for(t in h)Lo(l,t);(r=a.getEventHolder()).events&&(r.events={})}})}function Fo(t,e,n){var r=Do(t);return e instanceof Ei.window.Event||(e=new Ei.window.CustomEvent(e,{detail:n,cancelable:!0})),r.dispatchEvent(e),e}var zo=Gt("isConcatSpreadable"),qo=9007199254740991,Yo="Maximum allowed index exceeded",Xo=51<=$t||!m(function(){var t=[];return t[zo]=!1,t.concat()[0]!==t}),Go=Wt("concat"),Vo=function(t){if(!g(t))return!1;var e=t[zo];return void 0!==e?!!e:Ft(t)};Ct({target:"Array",proto:!0,forced:!Xo||!Go},{concat:function(t){var e,n,r,i,o,s=It(this),A=Me(s,0),u=0;for(e=-1,r=arguments.length;e<r;e++)if(o=-1===e?s:arguments[e],Vo(o)){if(i=ht(o.length),qo<u+i)throw TypeError(Yo);for(n=0;n<i;n++,u++)n in o&&zt(A,u,o[n])}else{if(qo<=u)throw TypeError(Yo);zt(A,u++,o)}return A.length=u,A}});var Ho=Ce.map;Ct({target:"Array",proto:!0,forced:!Wt("map")},{map:function(t){return Ho(this,t,1<arguments.length?arguments[1]:void 0)}});var Bo=Date.prototype,Uo="Invalid Date",$o="toString",Qo=Bo[$o],Wo=Bo.getTime;new Date(NaN)+""!=Uo&&et(Bo,$o,function(){var t=Wo.call(this);return t==t?Qo.call(this):Uo});var Jo=di.trim,Zo=y.parseInt,Ko=/^[+-]?0[Xx]/,ts=8!==Zo(hi+"08")||22!==Zo(hi+"0x16")?function(t,e){var n=Jo(String(t));return Zo(n,e>>>0||(Ko.test(n)?16:10))}:Zo;Ct({global:!0,forced:parseInt!=ts},{parseInt:ts});var es="toString",ns=RegExp.prototype,rs=ns[es],is=m(function(){return"/a/b"!=rs.call({source:"a",flags:"b"})}),os=rs.name!=es;function ss(t,e){return function(t){if(Array.isArray(t))return t}(t)||function(t,e){if(Symbol.iterator in Object(t)||"[object Arguments]"===Object.prototype.toString.call(t)){var n=[],r=!0,i=!1,o=void 0;try{for(var s,u=t[Symbol.iterator]();!(r=(s=u.next()).done)&&(n.push(s.value),!e||n.length!==e);r=!0);}catch(t){i=!0,o=t}finally{try{r||null==u.return||u.return()}finally{if(i)throw o}}return n}}(t,e)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}()}function us(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}function as(t,e,n){return e&&us(t.prototype,e),n&&us(t,n),t}function hs(t){var e=Math.round(t),n=Math.max(0,Math.min(255,e)).toString(16);return 1===n.length?"0"+n:n}function ls(t,e){for(var n=e.length;n--;)if(null==t[e[n]])return!1;return!0}function cs(t,e,n){return n<0&&(n+=1),1<n&&(n-=1),n<1/6?t+6*(e-t)*n:n<.5?e:n<2/3?t+(e-t)*(2/3-n)*6:t}(is||os)&&et(RegExp.prototype,es,function(){var t=T(this),e=String(t.source),n=t.flags;return"/"+e+"/"+String(void 0===n&&t instanceof RegExp&&!("flags"in ns)?qr.call(t):n)},{unsafe:!0});var fs=function(){function T(){Ti(this,T),this.init.apply(this,arguments)}return as(T,[{key:"init",value:function(){var t,e,n,r,i=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,s=2<arguments.length&&void 0!==arguments[2]?arguments[2]:0,u=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0,a=4<arguments.length&&void 0!==arguments[4]?arguments[4]:"rgb";if(i=i||0,this.space)for(var h in this.space)delete this[this.space[h]];if("number"==typeof i)a="string"==typeof u?u:a,u="string"==typeof u?0:u,Object.assign(this,{_a:i,_b:o,_c:s,_d:u,space:a});else if(i instanceof Array)this.space=o||("string"==typeof i[3]?i[3]:i[4])||"rgb",Object.assign(this,{_a:i[0],_b:i[1],_c:i[2],_d:i[3]||0});else if(i instanceof Object){var l=(n=o,(r=ls(e=i,"rgb")?{_a:e.r,_b:e.g,_c:e.b,space:"rgb"}:ls(e,"xyz")?{_a:e.x,_b:e.y,_c:e.z,_d:0,space:"xyz"}:ls(e,"hsl")?{_a:e.h,_b:e.s,_c:e.l,_d:0,space:"hsl"}:ls(e,"lab")?{_a:e.l,_b:e.a,_c:e.b,_d:0,space:"lab"}:ls(e,"lch")?{_a:e.l,_b:e.c,_c:e.h,_d:0,space:"lch"}:ls(e,"cmyk")?{_a:e.c,_b:e.m,_c:e.y,_d:e.k,space:"cmyk"}:{_a:0,_b:0,_c:0,space:"rgb"}).space=n||r.space,r);Object.assign(this,l)}else if("string"==typeof i)if(vo.test(i)){var c=i.replace(co,""),f=ss(ao.exec(c).slice(1,4).map(function(t){return parseInt(t)}),3),v=f[0],d=f[1],p=f[2];Object.assign(this,{_a:v,_b:d,_c:p,_d:0,space:"rgb"})}else{if(!fo.test(i))throw Error("Unsupported string format, can't construct Color");var y=ss(uo.exec((t=i,4===t.length?["#",t.substring(1,2),t.substring(1,2),t.substring(2,3),t.substring(2,3),t.substring(3,4),t.substring(3,4)].join(""):t)).map(function(t){return parseInt(t,16)}),4),m=y[1],g=y[2],w=y[3];Object.assign(this,{_a:m,_b:g,_c:w,_d:0,space:"rgb"})}var b=this._a,_=this._b,x=this._c,k=this._d,O="rgb"===this.space?{r:b,g:_,b:x}:"xyz"===this.space?{x:b,y:_,z:x}:"hsl"===this.space?{h:b,s:_,l:x}:"lab"===this.space?{l:b,a:_,b:x}:"lch"===this.space?{l:b,c:_,h:x}:"cmyk"===this.space?{c:b,m:_,y:x,k:k}:{};Object.assign(this,O)}},{key:"rgb",value:function(){if("rgb"===this.space)return this;if("lab"===(O=this.space)||"xyz"===O||"lch"===O){var t=this.x,e=this.y,n=this.z;if("lab"===this.space||"lch"===this.space){var r=this.l,i=this.a,o=this.b;if("lch"===this.space){var s=this.c,u=this.h,a=Math.PI/180;i=s*Math.cos(a*u),o=s*Math.sin(a*u)}var h=(r+16)/116,l=i/500+h,c=h-o/200,f=16/116,v=.008856;t=.95047*(Math.pow(l,3)>v?Math.pow(l,3):(l-f)/7.787),e=1*(Math.pow(h,3)>v?Math.pow(h,3):(h-f)/7.787),n=1.08883*(Math.pow(c,3)>v?Math.pow(c,3):(c-f)/7.787)}var d=3.2406*t+-1.5372*e+-.4986*n,p=-.9689*t+1.8758*e+.0415*n,y=.0557*t+-.204*e+1.057*n,m=Math.pow,g=.0031308;return new T(255*(g<d?1.055*m(d,1/2.4)-.055:12.92*d),255*(g<p?1.055*m(p,1/2.4)-.055:12.92*p),255*(g<y?1.055*m(y,1/2.4)-.055:12.92*y))}if("hsl"===this.space){var w=this.h,b=this.s,_=this.l;if(w/=360,_/=100,0===(b/=100))return new T(_*=255,_,_);var x=_<.5?_*(1+b):_+b-_*b,k=2*_-x;return new T(255*cs(k,x,w+1/3),255*cs(k,x,w),255*cs(k,x,w-1/3))}if("cmyk"!==this.space)return this;var O,S=this.c,j=this.m,M=this.y,E=this.k;return new T(255*(1-Math.min(1,S*(1-E)+E)),255*(1-Math.min(1,j*(1-E)+E)),255*(1-Math.min(1,M*(1-E)+E)))}},{key:"lab",value:function(){var t=this.xyz(),e=t.x,n=t.y;return new T(116*n-16,500*(e-n),200*(n-t.z),"lab")}},{key:"xyz",value:function(){var t=this.rgb(),e=ss([t._a,t._b,t._c].map(function(t){return t/255}),3),n=e[0],r=e[1],i=e[2],o=.04045<n?Math.pow((n+.055)/1.055,2.4):n/12.92,s=.04045<r?Math.pow((r+.055)/1.055,2.4):r/12.92,u=.04045<i?Math.pow((i+.055)/1.055,2.4):i/12.92,a=(.4124*o+.3576*s+.1805*u)/.95047,h=(.2126*o+.7152*s+.0722*u)/1,l=(.0193*o+.1192*s+.9505*u)/1.08883;return new T(.008856<a?Math.pow(a,1/3):7.787*a+16/116,.008856<h?Math.pow(h,1/3):7.787*h+16/116,.008856<l?Math.pow(l,1/3):7.787*l+16/116,"xyz")}},{key:"lch",value:function(){var t=this.lab(),e=t.l,n=t.a,r=t.b,i=Math.sqrt(Math.pow(n,2)+Math.pow(r,2)),o=180*Math.atan2(r,n)/Math.PI;return o<0&&(o=360-(o*=-1)),new T(e,i,o,"lch")}},{key:"hsl",value:function(){var t=this.rgb(),e=ss([t._a,t._b,t._c].map(function(t){return t/255}),3),n=e[0],r=e[1],i=e[2],o=Math.max(n,r,i),s=Math.min(n,r,i),u=(o+s)/2,a=o===s,h=o-s;return new T(360*(a?0:o===n?((r-i)/h+(r<i?6:0))/6:o===r?((i-n)/h+2)/6:o===i?((n-r)/h+4)/6:0),100*(a?0:.5<u?h/(2-o-s):h/(o+s)),100*u,"hsl")}},{key:"cmyk",value:function(){var t=this.rgb(),e=ss([t._a,t._b,t._c].map(function(t){return t/255}),3),n=e[0],r=e[1],i=e[2],o=Math.min(1-n,1-r,1-i);return 1===o?new T(0,0,0,1,"cmyk"):new T((1-n-o)/(1-o),(1-r-o)/(1-o),(1-i-o)/(1-o),o,"cmyk")}},{key:"_clamped",value:function(){var t=this.rgb(),e=t._a,n=t._b,r=t._c,i=Math.max,o=Math.min,s=Math.round;return[e,n,r].map(function(t){return i(0,o(s(t),255))})}},{key:"toHex",value:function(){var t=ss(this._clamped().map(hs),3),e=t[0],n=t[1],r=t[2];return"#".concat(e).concat(n).concat(r)}},{key:"toString",value:function(){return this.toHex()}},{key:"toRgb",value:function(){var t=ss(this._clamped(),3),e=t[0],n=t[1],r=t[2];return"rgb(".concat(e,",").concat(n,",").concat(r,")")}},{key:"toArray",value:function(){return[this._a,this._b,this._c,this._d,this.space]}}],[{key:"random",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:"vibrant",e=1<arguments.length?arguments[1]:void 0,n=Math.random,r=Math.round,i=Math.sin,o=Math.PI;if("vibrant"===t)return new T(24*n()+57,38*n()+45,360*n(),"lch");if("sine"===t)return new T(r(80*i(2*o*(e=null==e?n():e)/.5+.01)+150),r(50*i(2*o*e/.5+4.6)+200),r(100*i(2*o*e/.5+2.3)+150));if("pastel"===t)return new T(8*n()+86,17*n()+9,360*n(),"lch");if("dark"===t)return new T(10+10*n(),50*n()+86,360*n(),"lch");if("rgb"===t)return new T(255*n(),255*n(),255*n());if("lab"===t)return new T(100*n(),256*n()-128,256*n()-128,"lab");if("grey"===t){var s=255*n();return new T(s,s,s)}}},{key:"test",value:function(t){return"string"==typeof t&&(fo.test(t)||vo.test(t))}},{key:"isRgb",value:function(t){return t&&"number"==typeof t.r&&"number"==typeof t.g&&"number"==typeof t.b}},{key:"isColor",value:function(t){return t&&(t instanceof T||this.isRgb(t)||this.test(t))}}]),T}(),vs=m(function(){Pt(1)});function ds(t){if(void 0===t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return t}function ps(t,e){return!e||"object"!==ce(e)&&"function"!=typeof e?ds(t):e}function ys(t){return(ys=Object.setPrototypeOf?Object.getPrototypeOf:function(t){return t.__proto__||Object.getPrototypeOf(t)})(t)}function ms(t,e,n){return(ms="undefined"!=typeof Reflect&&Reflect.get?Reflect.get:function(t,e,n){var r=function(t,e){for(;!Object.prototype.hasOwnProperty.call(t,e)&&null!==(t=ys(t)););return t}(t,e);if(r){var i=Object.getOwnPropertyDescriptor(r,e);return i.get?i.get.call(n):i.value}})(t,e,n||t)}function gs(t,e){return(gs=Object.setPrototypeOf||function(t,e){return t.__proto__=e,t})(t,e)}function ws(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function");t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,writable:!0,configurable:!0}}),e&&gs(t,e)}Ct({target:"Object",stat:!0,forced:vs},{keys:function(t){return Pt(It(t))}}),Kr("match",1,function(r,a,h){return[function(t){var e=c(this),n=null==t?void 0:t[r];return void 0!==n?n.call(t,e):new RegExp(t)[r](String(e))},function(t){var e=h(a,t,this);if(e.done)return e.value;var n=T(t),r=String(this);if(!n.global)return ni(n,r);for(var i,o=n.unicode,A=[],s=n.lastIndex=0;null!==(i=ni(n,r));){var u=String(i[0]);""===(A[s]=u)&&(n.lastIndex=ei(r,ht(n.lastIndex),o)),s++}return 0===s?null:A}]});var bs=wt.f,_s=E.f,xs=P.f,ks=di.trim,Os="Number",Ss=y[Os],As=Ss.prototype,js=h(ge(As))==Os,Ms=function(t){var e,n,r,i,o,s,u,a,h=p(t,!1);if("string"==typeof h&&2<h.length)if(43===(e=(h=ks(h)).charCodeAt(0))||45===e){if(88===(n=h.charCodeAt(2))||120===n)return NaN}else if(48===e){switch(h.charCodeAt(1)){case 66:case 98:r=2,i=49;break;case 79:case 111:r=8,i=55;break;default:return+h}for(s=(o=h.slice(2)).length,u=0;u<s;u++)if((a=o.charCodeAt(u))<48||i<a)return NaN;return parseInt(o,r)}return+h};if(Et(Os,!Ss(" 0o1")||!Ss("0b1")||Ss("+0x1"))){for(var Es,Ts=function(t){var e=arguments.length<1?0:t,n=this;return n instanceof Ts&&(js?m(function(){As.valueOf.call(n)}):h(n)!=Os)?lr(new Ss(Ms(e)),n,Ts):Ms(e)},Cs=f?bs(Ss):"MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger".split(","),Ps=0;Cs.length>Ps;Ps++)x(Ss,Es=Cs[Ps])&&!x(Ts,Es)&&xs(Ts,Es,_s(Ss,Es));(Ts.prototype=As).constructor=Ts,et(y,Os,Ts)}var Is=di.trim,Ns=y.parseFloat,Ds=1/Ns(hi+"-0")!=-1/0?function(t){var e=Is(String(t)),n=Ns(e);return 0===n&&"-"==e.charAt(0)?-0:n}:Ns;Ct({global:!0,forced:parseFloat!=Ds},{parseFloat:Ds});var Rs=function(){function t(){Ti(this,t),this.init.apply(this,arguments)}return as(t,[{key:"init",value:function(t,e){var n=0,r=0,i=Array.isArray(t)?{x:t[0],y:t[1]}:"object"===ce(t)?{x:t.x,y:t.y}:{x:t,y:e};return this.x=null==i.x?n:i.x,this.y=null==i.y?r:i.y,this}},{key:"clone",value:function(){return new t(this)}},{key:"transform",value:function(t){return this.clone().transformO(t)}},{key:"transformO",value:function(t){Fs.isMatrixLike(t)||(t=new Fs(t));var e=this.x,n=this.y;return this.x=t.a*e+t.c*n+t.e,this.y=t.b*e+t.d*n+t.f,this}},{key:"toArray",value:function(){return[this.x,this.y]}}]),t}();function Ls(t,e,n){return Math.abs(e-t)<(n||1e-6)}var Fs=function(){function h(){Ti(this,h),this.init.apply(this,arguments)}return as(h,[{key:"init",value:function(t){var e=h.fromArray([1,0,0,1,0,0]);return t=t instanceof Element?t.matrixify():"string"==typeof t?h.fromArray(t.split(go).map(parseFloat)):Array.isArray(t)?h.fromArray(t):"object"===ce(t)&&h.isMatrixLike(t)?t:"object"===ce(t)?(new h).transform(t):6===arguments.length?h.fromArray([].slice.call(arguments)):e,this.a=null!=t.a?t.a:e.a,this.b=null!=t.b?t.b:e.b,this.c=null!=t.c?t.c:e.c,this.d=null!=t.d?t.d:e.d,this.e=null!=t.e?t.e:e.e,this.f=null!=t.f?t.f:e.f,this}},{key:"clone",value:function(){return new h(this)}},{key:"transform",value:function(t){if(h.isMatrixLike(t))return new h(t).multiplyO(this);var e=h.formatTransforms(t),n=new Rs(e.ox,e.oy).transform(this),r=n.x,i=n.y,o=(new h).translateO(e.rx,e.ry).lmultiplyO(this).translateO(-r,-i).scaleO(e.scaleX,e.scaleY).skewO(e.skewX,e.skewY).shearO(e.shear).rotateO(e.theta).translateO(r,i);if(isFinite(e.px)||isFinite(e.py)){var s=new Rs(r,i).transform(o),u=e.px?e.px-s.x:0,a=e.py?e.py-s.y:0;o.translateO(u,a)}return o.translateO(e.tx,e.ty),o}},{key:"compose",value:function(t){t.origin&&(t.originX=t.origin[0],t.originY=t.origin[1]);var e=t.originX||0,n=t.originY||0,r=t.scaleX||1,i=t.scaleY||1,o=t.shear||0,s=t.rotate||0,u=t.translateX||0,a=t.translateY||0;return(new h).translateO(-e,-n).scaleO(r,i).shearO(o).rotateO(s).translateO(u,a).lmultiplyO(this).translateO(e,n)}},{key:"decompose",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,n=this.a,r=this.b,i=this.c,o=this.d,s=this.e,u=this.f,a=n*o-r*i,h=0<a?1:-1,l=h*Math.sqrt(n*n+r*r),c=Math.atan2(h*r,h*n),f=180/Math.PI*c,v=Math.cos(c),d=Math.sin(c),p=(n*i+r*o)/a,y=i*l/(p*n-r)||o*l/(p*r+n);return{scaleX:l,scaleY:y,shear:p,rotate:f,translateX:s-t+t*v*l+e*(p*v*l-d*y),translateY:u-e+t*d*l+e*(p*d*l+v*y),originX:t,originY:e,a:this.a,b:this.b,c:this.c,d:this.d,e:this.e,f:this.f}}},{key:"multiply",value:function(t){return this.clone().multiplyO(t)}},{key:"multiplyO",value:function(t){var e=t instanceof h?t:new h(t);return h.matrixMultiply(this,e,this)}},{key:"lmultiply",value:function(t){return this.clone().lmultiplyO(t)}},{key:"lmultiplyO",value:function(t){var e=t instanceof h?t:new h(t);return h.matrixMultiply(e,this,this)}},{key:"inverseO",value:function(){var t=this.a,e=this.b,n=this.c,r=this.d,i=this.e,o=this.f,s=t*r-e*n;if(!s)throw new Error("Cannot invert "+this);var u=r/s,a=-e/s,h=-n/s,l=t/s,c=-(u*i+h*o),f=-(a*i+l*o);return this.a=u,this.b=a,this.c=h,this.d=l,this.e=c,this.f=f,this}},{key:"inverse",value:function(){return this.clone().inverseO()}},{key:"translate",value:function(t,e){return this.clone().translateO(t,e)}},{key:"translateO",value:function(t,e){return this.e+=t||0,this.f+=e||0,this}},{key:"scale",value:function(t,e,n,r){var i;return(i=this.clone()).scaleO.apply(i,arguments)}},{key:"scaleO",value:function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:t,n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:0,r=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0;3===arguments.length&&(r=n,n=e,e=t);var i=this.a,o=this.b,s=this.c,u=this.d,a=this.e,h=this.f;return this.a=i*t,this.b=o*e,this.c=s*t,this.d=u*e,this.e=a*t-n*t+n,this.f=h*e-r*e+r,this}},{key:"rotate",value:function(t,e,n){return this.clone().rotateO(t,e,n)}},{key:"rotateO",value:function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:0;t=mi(t);var r=Math.cos(t),i=Math.sin(t),o=this.a,s=this.b,u=this.c,a=this.d,h=this.e,l=this.f;return this.a=o*r-s*i,this.b=s*r+o*i,this.c=u*r-a*i,this.d=a*r+u*i,this.e=h*r-l*i+n*i-e*r+e,this.f=l*r+h*i-e*i-n*r+n,this}},{key:"flip",value:function(t,e){return this.clone().flipO(t,e)}},{key:"flipO",value:function(t,e){return"x"===t?this.scaleO(-1,1,e,0):"y"===t?this.scaleO(1,-1,0,e):this.scaleO(-1,-1,t,e||t)}},{key:"shear",value:function(t,e,n){return this.clone().shearO(t,e,n)}},{key:"shearO",value:function(t){var e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:0,n=this.a,r=this.b,i=this.c,o=this.d,s=this.e,u=this.f;return this.a=n+r*t,this.c=i+o*t,this.e=s+u*t-e*t,this}},{key:"skew",value:function(t,e,n,r){var i;return(i=this.clone()).skewO.apply(i,arguments)}},{key:"skewO",value:function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:t,n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:0,r=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0;3===arguments.length&&(r=n,n=e,e=t),t=mi(t),e=mi(e);var i=Math.tan(t),o=Math.tan(e),s=this.a,u=this.b,a=this.c,h=this.d,l=this.e,c=this.f;return this.a=s+u*i,this.b=u+s*o,this.c=a+h*i,this.d=h+a*o,this.e=l+c*i-r*i,this.f=c+l*o-n*o,this}},{key:"skewX",value:function(t,e,n){return this.skew(t,0,e,n)}},{key:"skewXO",value:function(t,e,n){return this.skewO(t,0,e,n)}},{key:"skewY",value:function(t,e,n){return this.skew(0,t,e,n)}},{key:"skewYO",value:function(t,e,n){return this.skewO(0,t,e,n)}},{key:"aroundO",value:function(t,e,n){var r=t||0,i=e||0;return this.translateO(-r,-i).lmultiplyO(n).translateO(r,i)}},{key:"around",value:function(t,e,n){return this.clone().aroundO(t,e,n)}},{key:"equals",value:function(t){var e=new h(t);return Ls(this.a,e.a)&&Ls(this.b,e.b)&&Ls(this.c,e.c)&&Ls(this.d,e.d)&&Ls(this.e,e.e)&&Ls(this.f,e.f)}},{key:"toString",value:function(){return"matrix("+this.a+","+this.b+","+this.c+","+this.d+","+this.e+","+this.f+")"}},{key:"toArray",value:function(){return[this.a,this.b,this.c,this.d,this.e,this.f]}},{key:"valueOf",value:function(){return{a:this.a,b:this.b,c:this.c,d:this.d,e:this.e,f:this.f}}}],[{key:"fromArray",value:function(t){return{a:t[0],b:t[1],c:t[2],d:t[3],e:t[4],f:t[5]}}},{key:"isMatrixLike",value:function(t){return null!=t.a||null!=t.b||null!=t.c||null!=t.d||null!=t.e||null!=t.f}},{key:"formatTransforms",value:function(t){var e="both"===t.flip||!0===t.flip,n=t.flip&&(e||"x"===t.flip)?-1:1,r=t.flip&&(e||"y"===t.flip)?-1:1,i=t.skew&&t.skew.length?t.skew[0]:isFinite(t.skew)?t.skew:isFinite(t.skewX)?t.skewX:0,o=t.skew&&t.skew.length?t.skew[1]:isFinite(t.skew)?t.skew:isFinite(t.skewY)?t.skewY:0,s=t.scale&&t.scale.length?t.scale[0]*n:isFinite(t.scale)?t.scale*n:isFinite(t.scaleX)?t.scaleX*n:n,u=t.scale&&t.scale.length?t.scale[1]*r:isFinite(t.scale)?t.scale*r:isFinite(t.scaleY)?t.scaleY*r:r,a=t.shear||0,h=t.rotate||t.theta||0,l=new Rs(t.origin||t.around||t.ox||t.originX,t.oy||t.originY),c=l.x,f=l.y,v=new Rs(t.position||t.px||t.positionX,t.py||t.positionY),d=v.x,p=v.y,y=new Rs(t.translate||t.tx||t.translateX,t.ty||t.translateY),m=y.x,g=y.y,w=new Rs(t.relative||t.rx||t.relativeX,t.ry||t.relativeY);return{scaleX:s,scaleY:u,skewX:i,skewY:o,shear:a,theta:h,rx:w.x,ry:w.y,tx:m,ty:g,ox:c,oy:f,px:d,py:p}}},{key:"matrixMultiply",value:function(t,e,n){var r=t.a*e.a+t.c*e.b,i=t.b*e.a+t.d*e.b,o=t.a*e.c+t.c*e.d,s=t.b*e.c+t.d*e.d,u=t.e+t.a*e.e+t.c*e.f,a=t.f+t.b*e.e+t.d*e.f;return n.a=r,n.b=i,n.c=o,n.d=s,n.e=u,n.f=a,n}}]),h}();function zs(){if(!zs.nodes){var t=Di().size(2,0);t.node.style.cssText=["opacity: 0","position: absolute","left: -100%","top: -100%","overflow: hidden"].join(";"),t.attr("focusable","false"),t.attr("aria-hidden","true");var e=t.path().node;zs.nodes={svg:t,path:e}}if(!zs.nodes.svg.node.parentNode){var n=Ei.document.body||Ei.document.documentElement;zs.nodes.svg.addTo(n)}return zs.nodes}function qs(t){return!(t.width||t.height||t.x||t.y)}zi(Fs,"Matrix");var Ys=function(){function s(){Ti(this,s),this.init.apply(this,arguments)}return as(s,[{key:"init",value:function(t){return t="string"==typeof t?t.split(go).map(parseFloat):Array.isArray(t)?t:"object"===ce(t)?[null!=t.left?t.left:t.x,null!=t.top?t.top:t.y,t.width,t.height]:4===arguments.length?[].slice.call(arguments):[0,0,0,0],this.x=t[0]||0,this.y=t[1]||0,this.width=this.w=t[2]||0,this.height=this.h=t[3]||0,this.x2=this.x+this.w,this.y2=this.y+this.h,this.cx=this.x+this.w/2,this.cy=this.y+this.h/2,this}},{key:"merge",value:function(t){var e=Math.min(this.x,t.x),n=Math.min(this.y,t.y);return new s(e,n,Math.max(this.x+this.width,t.x+t.width)-e,Math.max(this.y+this.height,t.y+t.height)-n)}},{key:"transform",value:function(e){e instanceof Fs||(e=new Fs(e));var n=1/0,r=-1/0,i=1/0,o=-1/0;return[new Rs(this.x,this.y),new Rs(this.x2,this.y),new Rs(this.x,this.y2),new Rs(this.x2,this.y2)].forEach(function(t){t=t.transform(e),n=Math.min(n,t.x),r=Math.max(r,t.x),i=Math.min(i,t.y),o=Math.max(o,t.y)}),new s(n,i,r-n,o-i)}},{key:"addOffset",value:function(){return this.x+=Ei.window.pageXOffset,this.y+=Ei.window.pageYOffset,this}},{key:"toString",value:function(){return this.x+" "+this.y+" "+this.width+" "+this.height}},{key:"toArray",value:function(){return[this.x,this.y,this.width,this.height]}},{key:"isNulled",value:function(){return qs(this)}}]),s}();function Xs(t,e){var n,r;try{if(qs(n=t(this.node))&&((r=this.node)!==Ei.document&&!(Ei.document.documentElement.contains||function(t){for(;t.parentNode;)t=t.parentNode;return t===Ei.document}).call(Ei.document.documentElement,r)))throw new Error("Element not in the dom")}catch(t){n=e(this)}return n}Nr({viewbox:{viewbox:function(t,e,n,r){return null==t?new Ys(this.attr("viewBox")):this.attr("viewBox",new Ys(t,e,n,r))},zoom:function(t,e){var n=this.node.clientWidth,r=this.node.clientHeight,i=this.viewbox();if(!n&&!r){var o=window.getComputedStyle(this.node);n=parseFloat(o.getPropertyValue("width")),r=parseFloat(o.getPropertyValue("height"))}var s=n/i.width,u=r/i.height,a=Math.min(s,u);if(null==t)return a;var h=a/t;h===1/0&&(h=Number.MIN_VALUE),e=e||new Rs(n/2/s+i.x,r/2/u+i.y);var l=new Ys(i).transform(new Fs({scale:h,origin:e}));return this.viewbox(l)}}}),zi(Ys,"Box");var Gs=function(){try{return Function("name","baseClass","_constructor",["baseClass = baseClass || Array","return {","  [name]: class extends baseClass {","    constructor (...args) {","      super(...args)","      _constructor && _constructor.apply(this, args)","    }","  }","}[name]"].join("\n"))}catch(t){return function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:Array,n=2<arguments.length?arguments[2]:void 0,r=function(){e.apply(this,arguments),n&&n.apply(this,arguments)};return((r.prototype=Object.create(e.prototype)).constructor=r).prototype.map=function(t){var e=new r;return e.push.apply(e,Array.prototype.map.call(this,t)),e},r}}}(),Vs=Gs("List",Array,function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:[];if("number"==typeof t)return this;this.length=0,this.push.apply(this,Cr(t))});Vi(Vs,{each:function(e){for(var t=arguments.length,n=new Array(1<t?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];return"function"==typeof e?this.map(function(t){return e.call(t,t)}):this.map(function(t){return t[e].apply(t,n)})},toArray:function(){return Array.prototype.concat.apply([],this)}});var Hs=["toArray","constructor","each"];function Bs(t,e){return new Vs(yi((e||Ei.document).querySelectorAll(t),function(t){return Li(t)}))}Vs.extend=function(t){t=t.reduce(function(t,r){return Hs.includes(r)||"_"===r[0]||(t[r]=function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return this.each.apply(this,[r].concat(e))}),t},{}),Vi(Vs,t)};var Us=function(t){function r(){var t,e=(0<arguments.length&&void 0!==arguments[0]?arguments[0]:{}).events,n=void 0===e?{}:e;return Ti(this,r),(t=ps(this,ys(r).call(this))).events=n,t}return ws(r,Ci),as(r,[{key:"addEventListener",value:function(){}},{key:"dispatch",value:function(t,e){return Fo(this,t,e)}},{key:"dispatchEvent",value:function(t){var e=this.getEventHolder().events;if(!e)return!0;var n=e[t.type];for(var r in n)for(var i in n[r])n[r][i](t);return!t.defaultPrevented}},{key:"fire",value:function(t,e){return this.dispatch(t,e),this}},{key:"getEventHolder",value:function(){return this}},{key:"getEventTarget",value:function(){return this}},{key:"off",value:function(t,e){return Lo(this,t,e),this}},{key:"on",value:function(t,e,n,r){return Ro(this,t,e,n,r),this}},{key:"removeEventListener",value:function(){}}]),r}();function $s(){}zi(Us,"EventTarget");var Qs={duration:400,ease:">",delay:0},Ws={"fill-opacity":1,"stroke-opacity":1,"stroke-width":0,"stroke-linejoin":"miter","stroke-linecap":"butt",fill:"#000000",stroke:"#000000",opacity:1,x:0,y:0,cx:0,cy:0,width:0,height:0,r:0,rx:0,ry:0,offset:0,"stop-opacity":1,"stop-color":"#000000","text-anchor":"start"},Js={__proto__:null,noop:$s,timeline:Qs,attrs:Ws},Zs=Gs("SVGArray",Array,function(t){this.init(t)});Vi(Zs,{init:function(t){return"number"==typeof t||(this.length=0,this.push.apply(this,Cr(this.parse(t)))),this},toArray:function(){return Array.prototype.concat.apply([],this)},toString:function(){return this.join(" ")},valueOf:function(){var t=[];return t.push.apply(t,Cr(this)),t},parse:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:[];return t instanceof Array?t:t.trim().split(go).map(parseFloat)},clone:function(){return new this.constructor(this)},toSet:function(){return new Set(this)}});var Ks=function(){function n(){Ti(this,n),this.init.apply(this,arguments)}return as(n,[{key:"init",value:function(t,e){return e=Array.isArray(t)?t[1]:e,t=Array.isArray(t)?t[0]:t,this.value=0,this.unit=e||"","number"==typeof t?this.value=isNaN(t)?0:isFinite(t)?t:t<0?-34e37:34e37:"string"==typeof t?(e=t.match(so))&&(this.value=parseFloat(e[1]),"%"===e[5]?this.value/=100:"s"===e[5]&&(this.value*=1e3),this.unit=e[5]):t instanceof n&&(this.value=t.valueOf(),this.unit=t.unit),this}},{key:"toString",value:function(){return("%"===this.unit?~~(1e8*this.value)/1e6:"s"===this.unit?this.value/1e3:this.value)+this.unit}},{key:"toJSON",value:function(){return this.toString()}},{key:"toArray",value:function(){return[this.value,this.unit]}},{key:"valueOf",value:function(){return this.value}},{key:"plus",value:function(t){return new n(this+(t=new n(t)),this.unit||t.unit)}},{key:"minus",value:function(t){return new n(this-(t=new n(t)),this.unit||t.unit)}},{key:"times",value:function(t){return new n(this*(t=new n(t)),this.unit||t.unit)}},{key:"divide",value:function(t){return new n(this/(t=new n(t)),this.unit||t.unit)}},{key:"convert",value:function(t){return new n(this.value,t)}}]),n}(),tu=[];var Dom=function(t){function Dom(t,e){var n;return Ti(this,Dom),(n=ps(this,ys(Dom).call(this,t))).node=t,n.type=t.nodeName,e&&t!==e&&n.attr(e),n}return ws(Dom,Us),as(Dom,[{key:"add",value:function(t,e){return t=Di(t),null==e?this.node.appendChild(t.node):t.node!==this.node.childNodes[e]&&this.node.insertBefore(t.node,this.node.childNodes[e]),this}},{key:"addTo",value:function(t){return Di(t).put(this)}},{key:"children",value:function(){return new Vs(yi(this.node.children,function(t){return Li(t)}))}},{key:"clear",value:function(){for(;this.node.hasChildNodes();)this.node.removeChild(this.node.lastChild);return this}},{key:"clone",value:function(){return this.writeDataToDom(),Gi(this.node.cloneNode(!0))}},{key:"each",value:function(t,e){var n,r,i=this.children();for(n=0,r=i.length;n<r;n++)t.apply(i[n],[n,i]),e&&i[n].each(t,e);return this}},{key:"element",value:function(t){return this.put(new Dom(Ni(t)))}},{key:"first",value:function(){return Li(this.node.firstChild)}},{key:"get",value:function(t){return Li(this.node.childNodes[t])}},{key:"getEventHolder",value:function(){return this.node}},{key:"getEventTarget",value:function(){return this.node}},{key:"has",value:function(t){return 0<=this.index(t)}},{key:"id",value:function(t){return void 0!==t||this.node.id||(this.node.id=Xi(this.type)),this.attr("id",t)}},{key:"index",value:function(t){return[].slice.call(this.node.childNodes).indexOf(t.node)}},{key:"last",value:function(){return Li(this.node.lastChild)}},{key:"matches",value:function(t){var e=this.node;return(e.matches||e.matchesSelector||e.msMatchesSelector||e.mozMatchesSelector||e.webkitMatchesSelector||e.oMatchesSelector).call(e,t)}},{key:"parent",value:function(t){var e=this;if(!e.node.parentNode)return null;if(e=Li(e.node.parentNode),!t)return e;for(;e;){if("string"==typeof t?e.matches(t):e instanceof t)return e;if(!e.node.parentNode||"#document"===e.node.parentNode.nodeName||"#document-fragment"===e.node.parentNode.nodeName)return null;e=Li(e.node.parentNode)}}},{key:"put",value:function(t,e){return this.add(t,e),t}},{key:"putIn",value:function(t){return Di(t).add(this)}},{key:"remove",value:function(){return this.parent()&&this.parent().removeElement(this),this}},{key:"removeElement",value:function(t){return this.node.removeChild(t.node),this}},{key:"replace",value:function(t){return t=Di(t),this.node.parentNode.replaceChild(t.node,this.node),t}},{key:"round",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:2,e=1<arguments.length?arguments[1]:void 0,n=Math.pow(10,t),r=this.attr();e||(e=Object.keys(r));var i={};return e.forEach(function(t){i[t]=Math.round(r[t]*n)/n}),this.attr(i),this}},{key:"toString",value:function(){return this.id()}},{key:"svg",value:function(n,t){var e,r,i;if(!1===n&&(t=!1,n=null),null==n||"function"==typeof n){t=null==t||t,this.writeDataToDom();var o=this;if(null!=n){if(o=Li(o.node.cloneNode(!0)),t){var s=n(o);if(o=s||o,!1===s)return""}o.each(function(){var t=n(this),e=t||this;!1===t?this.remove():t&&this!==e&&this.replace(e)},!0)}return t?o.node.outerHTML:o.node.innerHTML}for(t=null!=t&&t,e=Ei.document.createElementNS(Oi,"svg"),i=Ei.document.createDocumentFragment(),e.innerHTML=n,r=e.children.length;r--;)i.appendChild(e.firstElementChild);var u=this.parent();return t?this.replace(i)&&u:this.add(i)}},{key:"words",value:function(t){return this.node.textContent=t,this}},{key:"writeDataToDom",value:function(){return this.each(function(){this.writeDataToDom()}),this}}]),Dom}();Vi(Dom,{attr:function(n,t,e){var r=this;if(null==n){n={},t=this.node.attributes;var i=!0,o=!1,s=void 0;try{for(var u,a=t[Symbol.iterator]();!(i=(u=a.next()).done);i=!0){var h=u.value;n[h.nodeName]=yo.test(h.nodeValue)?parseFloat(h.nodeValue):h.nodeValue}}catch(t){o=!0,s=t}finally{try{i||null==a.return||a.return()}finally{if(o)throw s}}return n}if(n instanceof Array)return n.reduce(function(t,e){return t[e]=r.attr(e),t},{});if("object"===ce(n)&&n.constructor===Object)for(t in n)this.attr(t,n[t]);else if(null===t)this.node.removeAttribute(n);else{if(null==t)return null==(t=this.node.getAttribute(n))?Ws[n]:yo.test(t)?parseFloat(t):t;"number"==typeof(t=tu.reduce(function(t,e){return e(n,t,r)},t))?t=new Ks(t):fs.isColor(t)?t=new fs(t):t.constructor===Array&&(t=new Zs(t)),"leading"===n?this.leading&&this.leading(t):"string"==typeof e?this.node.setAttributeNS(e,n,t.toString()):this.node.setAttribute(n,t.toString()),!this.rebuild||"font-size"!==n&&"x"!==n||this.rebuild()}return this},find:function(t){return Bs(t,this.node)},findOne:function(t){return Li(this.node.querySelector(t))}}),zi(Dom,"Dom");var Element=function(t){function Element(t,e){var n;return Ti(this,Element),(n=ps(this,ys(Element).call(this,t,e))).dom={},n.node.instance=ds(n),t.hasAttribute("svgjs:data")&&n.setData(JSON.parse(t.getAttribute("svgjs:data"))||{}),n}return ws(Element,Dom),as(Element,[{key:"center",value:function(t,e){return this.cx(t).cy(e)}},{key:"cx",value:function(t){return null==t?this.x()+this.width()/2:this.x(t-this.width()/2)}},{key:"cy",value:function(t){return null==t?this.y()+this.height()/2:this.y(t-this.height()/2)}},{key:"defs",value:function(){return this.root().defs()}},{key:"dmove",value:function(t,e){return this.dx(t).dy(e)}},{key:"dx",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0;return this.x(new Ks(t).plus(this.x()))}},{key:"dy",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0;return this.y(new Ks(t).plus(this.y()))}},{key:"root",value:function(){var t=this.parent(qi(Ii));return t&&t.root()}},{key:"getEventHolder",value:function(){return this}},{key:"height",value:function(t){return this.attr("height",t)}},{key:"inside",value:function(t,e){var n=this.bbox();return t>n.x&&e>n.y&&t<n.x+n.width&&e<n.y+n.height}},{key:"move",value:function(t,e){return this.x(t).y(e)}},{key:"parents",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:Ei.document;t=Di(t);for(var e=new Vs,n=this;(n=n.parent())&&n.node!==t.node&&n.node!==Ei.document;)e.push(n);return e}},{key:"reference",value:function(t){if(!(t=this.attr(t)))return null;var e=t.match(ho);return e?Di(e[1]):null}},{key:"setData",value:function(t){return this.dom=t,this}},{key:"size",value:function(t,e){var n=_i(this,t,e);return this.width(new Ks(n.width)).height(new Ks(n.height))}},{key:"width",value:function(t){return this.attr("width",t)}},{key:"writeDataToDom",value:function(){return this.node.removeAttribute("svgjs:data"),Object.keys(this.dom).length&&this.node.setAttribute("svgjs:data",JSON.stringify(this.dom)),ms(ys(Element.prototype),"writeDataToDom",this).call(this)}},{key:"x",value:function(t){return this.attr("x",t)}},{key:"y",value:function(t){return this.attr("y",t)}}]),Element}();Vi(Element,{bbox:function(){return new Ys(Xs.call(this,function(t){return t.getBBox()},function(e){try{var t=e.clone().addTo(zs().svg).show(),n=t.node.getBBox();return t.remove(),n}catch(t){throw new Error('Getting bbox of element "'+e.node.nodeName+'" is not possible. '+t.toString())}}))},rbox:function(t){var e=new Ys(Xs.call(this,function(t){return t.getBoundingClientRect()},function(t){throw new Error('Getting rbox of element "'+t.node.nodeName+'" is not possible')}));return t?e.transform(t.screenCTM().inverse()):e.addOffset()},point:function(t,e){return new Rs(t,e).transform(this.screenCTM().inverse())},ctm:function(){return new Fs(this.node.getCTM())},screenCTM:function(){if("function"!=typeof this.isRoot||this.isRoot())return new Fs(this.node.getScreenCTM());var t=this.rect(1,1),e=t.node.getScreenCTM();return t.remove(),new Fs(e)}}),zi(Element,"Element");var eu={stroke:["color","width","opacity","linecap","linejoin","miterlimit","dasharray","dashoffset"],fill:["color","opacity","rule"],prefix:function(t,e){return"color"===e?t:t+"-"+e}};["fill","stroke"].forEach(function(e){var n,t={};t[e]=function(t){if(void 0===t)return this.attr(e);if("string"==typeof t||t instanceof fs||fs.isRgb(t)||t instanceof Element)this.attr(e,t);else for(n=eu[e].length-1;0<=n;n--)null!=t[eu[e][n]]&&this.attr(eu.prefix(e,eu[e][n]),t[eu[e][n]]);return this},Nr(["Element","Runner"],t)}),Nr(["Element","Runner"],{matrix:function(t,e,n,r,i,o){return null==t?new Fs(this):this.attr("transform",new Fs(t,e,n,r,i,o))},rotate:function(t,e,n){return this.transform({rotate:t,ox:e,oy:n},!0)},skew:function(t,e,n,r){return 1===arguments.length||3===arguments.length?this.transform({skew:t,ox:e,oy:n},!0):this.transform({skew:[t,e],ox:n,oy:r},!0)},shear:function(t,e,n){return this.transform({shear:t,ox:e,oy:n},!0)},scale:function(t,e,n,r){return 1===arguments.length||3===arguments.length?this.transform({scale:t,ox:e,oy:n},!0):this.transform({scale:[t,e],ox:n,oy:r},!0)},translate:function(t,e){return this.transform({translate:[t,e]},!0)},relative:function(t,e){return this.transform({relative:[t,e]},!0)},flip:function(t,e){var n="string"==typeof t?t:(isFinite(t),"both"),r="both"===t&&isFinite(e)?[e,e]:"x"===t?[e,0]:"y"===t?[0,e]:isFinite(t)?[t,t]:[0,0];return this.transform({flip:n,origin:r},!0)},opacity:function(t){return this.attr("opacity",t)}}),Nr("radius",{radius:function(t,e){var n=(this._element||this).type;return"radialGradient"===n||"radialGradient"===n?this.attr("r",new Ks(t)):this.rx(t).ry(null==e?t:e)}}),Nr("Path",{length:function(){return this.node.getTotalLength()},pointAt:function(t){return new Rs(this.node.getPointAtLength(t))}}),Nr(["Element","Runner"],{font:function(t,e){if("object"!==ce(t))return"leading"===t?this.leading(e):"anchor"===t?this.attr("text-anchor",e):"size"===t||"family"===t||"weight"===t||"stretch"===t||"variant"===t||"style"===t?this.attr("font-"+t,e):this.attr(t,e);for(e in t)this.font(e,t[e]);return this}}),Nr("Text",{ax:function(t){return this.attr("x",t)},ay:function(t){return this.attr("y",t)},amove:function(t,e){return this.ax(t).ay(e)}}),Nr("Element",["click","dblclick","mousedown","mouseup","mouseover","mouseout","mousemove","mouseenter","mouseleave","touchstart","touchmove","touchleave","touchend","touchcancel"].reduce(function(t,e){return t[e]=function(t){return null===t?Lo(this,e):Ro(this,e,t),this},t},{}));var nu=[].reverse,ru=[1,2];Ct({target:"Array",proto:!0,forced:String(ru)===String(ru.reverse())},{reverse:function(){return Ft(this)&&(this.length=this.length),nu.call(this)}}),Ct({target:"Object",stat:!0,forced:!f,sham:!f},{defineProperties:fe}),Ct({target:"Object",stat:!0,forced:!f,sham:!f},{defineProperty:P.f});var iu=E.f,ou=m(function(){iu(1)});function su(t,e,n){return e in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}function uu(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function au(t){return this.attr("rx",t)}function hu(t){return this.attr("ry",t)}function lu(t){return null==t?this.cx()-this.rx():this.cx(t+this.rx())}function cu(t){return null==t?this.cy()-this.ry():this.cy(t+this.ry())}function fu(t){return null==t?this.attr("cx"):this.attr("cx",t)}function vu(t){return null==t?this.attr("cy"):this.attr("cy",t)}function du(t){return null==t?2*this.rx():this.rx(new Ks(t).divide(2))}function pu(t){return null==t?2*this.ry():this.ry(new Ks(t).divide(2))}Ct({target:"Object",stat:!0,forced:!f||ou,sham:!f},{getOwnPropertyDescriptor:function(t,e){return iu(d(t),e)}}),Ct({target:"Object",stat:!0,sham:!f},{getOwnPropertyDescriptors:function(t){for(var e,n,r=d(t),i=E.f,o=_t(r),s={},u=0;o.length>u;)void 0!==(n=i(r,e=o[u++]))&&zt(s,e,n);return s}}),Nr("Element",{untransform:function(){return this.attr("transform",null)},matrixify:function(){return(this.attr("transform")||"").split(lo).slice(0,-1).map(function(t){var e=t.trim().split("(");return[e[0],e[1].split(go).map(function(t){return parseFloat(t)})]}).reverse().reduce(function(t,e){return"matrix"===e[0]?t.lmultiply(Fs.fromArray(e[1])):t[e[0]].apply(t,e[1])},new Fs)},toParent:function(t){if(this===t)return this;var e=this.screenCTM(),n=t.screenCTM().inverse();return this.addTo(t).untransform().transform(n.multiply(e)),this},toRoot:function(){return this.toParent(this.root())},transform:function(t,e){if(null==t||"string"==typeof t){var n=new Fs(this).decompose();return null==t?n:n[t]}Fs.isMatrixLike(t)||(t=function(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?uu(n,!0).forEach(function(t){su(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):uu(n).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}({},t,{origin:xi(t,this)}));var r=new Fs(!0===e?this:e||!1).transform(t);return this.attr("transform",r)}});var yu={__proto__:null,rx:au,ry:hu,x:lu,y:cu,cx:fu,cy:vu,width:du,height:pu},Shape=function(t){function Shape(){return Ti(this,Shape),ps(this,ys(Shape).apply(this,arguments))}return ws(Shape,Element),Shape}();zi(Shape,"Shape");var Circle=function(t){function Circle(t){return Ti(this,Circle),ps(this,ys(Circle).call(this,Ri("circle",t),t))}return ws(Circle,Shape),as(Circle,[{key:"radius",value:function(t){return this.attr("r",t)}},{key:"rx",value:function(t){return this.attr("r",t)}},{key:"ry",value:function(t){return this.rx(t)}},{key:"size",value:function(t){return this.radius(new Ks(t).divide(2))}}]),Circle}();Vi(Circle,{x:lu,y:cu,cx:fu,cy:vu,width:du,height:pu}),Nr({Container:{circle:Hi(function(t){return this.put(new Circle).size(t).move(0,0)})}}),zi(Circle,"Circle");var Container=function(t){function Container(){return Ti(this,Container),ps(this,ys(Container).apply(this,arguments))}return ws(Container,Element),as(Container,[{key:"flatten",value:function(t){return this.each(function(){return this instanceof Container?this.flatten(t).ungroup(t):this.toParent(t)}),this.node.firstElementChild||this.remove(),this}},{key:"ungroup",value:function(t){return t=t||this.parent(),this.each(function(){return this.toParent(t)}),this.remove(),this}}]),Container}();zi(Container,"Container");var Defs=function(t){function Defs(t){return Ti(this,Defs),ps(this,ys(Defs).call(this,Ri("defs",t),t))}return ws(Defs,Container),as(Defs,[{key:"flatten",value:function(){return this}},{key:"ungroup",value:function(){return this}}]),Defs}();zi(Defs,"Defs");var Ellipse=function(t){function Ellipse(t){return Ti(this,Ellipse),ps(this,ys(Ellipse).call(this,Ri("ellipse",t),t))}return ws(Ellipse,Shape),as(Ellipse,[{key:"size",value:function(t,e){var n=_i(this,t,e);return this.rx(new Ks(n.width).divide(2)).ry(new Ks(n.height).divide(2))}}]),Ellipse}();Vi(Ellipse,yu),Nr("Container",{ellipse:Hi(function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:t;return this.put(new Ellipse).size(t,e).move(0,0)})}),zi(Ellipse,"Ellipse");var Stop=function(t){function Stop(t){return Ti(this,Stop),ps(this,ys(Stop).call(this,Ri("stop",t),t))}return ws(Stop,Element),as(Stop,[{key:"update",value:function(t){return("number"==typeof t||t instanceof Ks)&&(t={offset:arguments[0],color:arguments[1],opacity:arguments[2]}),null!=t.opacity&&this.attr("stop-opacity",t.opacity),null!=t.color&&this.attr("stop-color",t.color),null!=t.offset&&this.attr("offset",new Ks(t.offset)),this}}]),Stop}();function mu(t,e){return"radialGradient"===(this._element||this).type?this.attr({fx:new Ks(t),fy:new Ks(e)}):this.attr({x1:new Ks(t),y1:new Ks(e)})}function gu(t,e){return"radialGradient"===(this._element||this).type?this.attr({cx:new Ks(t),cy:new Ks(e)}):this.attr({x2:new Ks(t),y2:new Ks(e)})}zi(Stop,"Stop");var wu={__proto__:null,from:mu,to:gu},Gradient=function(t){function Gradient(t,e){return Ti(this,Gradient),ps(this,ys(Gradient).call(this,Ri(t+"Gradient","string"==typeof t?null:t),e))}return ws(Gradient,Container),as(Gradient,[{key:"stop",value:function(t,e,n){return this.put(new Stop).update(t,e,n)}},{key:"update",value:function(t){return this.clear(),"function"==typeof t&&t.call(this,this),this}},{key:"url",value:function(){return"url(#"+this.id()+")"}},{key:"toString",value:function(){return this.url()}},{key:"attr",value:function(t,e,n){return"transform"===t&&(t="gradientTransform"),ms(ys(Gradient.prototype),"attr",this).call(this,t,e,n)}},{key:"targets",value:function(){return Bs('svg [fill*="'+this.id()+'"]')}},{key:"bbox",value:function(){return new Ys}}]),Gradient}();Vi(Gradient,wu),Nr({Container:{gradient:Hi(function(t,e){return this.defs().gradient(t,e)})},Defs:{gradient:Hi(function(t,e){return this.put(new Gradient(t)).update(e)})}}),zi(Gradient,"Gradient");var Pattern=function(t){function Pattern(t){return Ti(this,Pattern),ps(this,ys(Pattern).call(this,Ri("pattern",t),t))}return ws(Pattern,Container),as(Pattern,[{key:"url",value:function(){return"url(#"+this.id()+")"}},{key:"update",value:function(t){return this.clear(),"function"==typeof t&&t.call(this,this),this}},{key:"toString",value:function(){return this.url()}},{key:"attr",value:function(t,e,n){return"transform"===t&&(t="patternTransform"),ms(ys(Pattern.prototype),"attr",this).call(this,t,e,n)}},{key:"targets",value:function(){return Bs('svg [fill*="'+this.id()+'"]')}},{key:"bbox",value:function(){return new Ys}}]),Pattern}();Nr({Container:{pattern:function(){var t;return(t=this.defs()).pattern.apply(t,arguments)}},Defs:{pattern:Hi(function(t,e,n){return this.put(new Pattern).update(n).attr({x:0,y:0,width:t,height:e,patternUnits:"userSpaceOnUse"})})}}),zi(Pattern,"Pattern");var bu,Image=function(t){function Image(t){return Ti(this,Image),ps(this,ys(Image).call(this,Ri("image",t),t))}return ws(Image,Shape),as(Image,[{key:"load",value:function(t,n){if(!t)return this;var r=new Ei.window.Image;return Ro(r,"load",function(t){var e=this.parent(Pattern);0===this.width()&&0===this.height()&&this.size(r.width,r.height),e instanceof Pattern&&0===e.width()&&0===e.height()&&e.size(this.width(),this.height()),"function"==typeof n&&n.call(this,t)},this),Ro(r,"load error",function(){Lo(r)}),this.attr("href",r.src=t,Ai)}}]),Image}();bu=function(t,e,n){return"fill"!==t&&"stroke"!==t||mo.test(e)&&(e=n.root().defs().image(e)),e instanceof Image&&(e=n.root().defs().pattern(0,0,function(t){t.add(e)})),e},tu.push(bu),Nr({Container:{image:Hi(function(t,e){return this.put(new Image).size(0,0).load(t,e)})}}),zi(Image,"Image");var _u=Gs("PointArray",Zs);Vi(_u,{toString:function(){for(var t=0,e=this.length,n=[];t<e;t++)n.push(this[t].join(","));return n.join(" ")},toLine:function(){return{x1:this[0][0],y1:this[0][1],x2:this[1][0],y2:this[1][1]}},at:function(t){if(!this.destination)return this;for(var e=0,n=this.length,r=[];e<n;e++)r.push([this[e][0]+(this.destination[e][0]-this[e][0])*t,this[e][1]+(this.destination[e][1]-this[e][1])*t]);return new _u(r)},parse:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:[[0,0]],e=[];if(t instanceof Array){if(t[0]instanceof Array)return t}else t=t.trim().split(go).map(parseFloat);t.length%2!=0&&t.pop();for(var n=0,r=t.length;n<r;n+=2)e.push([t[n],t[n+1]]);return e},transform:function(t){for(var e=[],n=0;n<this.length;n++){var r=this[n];e.push([t.a*r[0]+t.c*r[1]+t.e,t.b*r[0]+t.d*r[1]+t.f])}return new _u(e)},move:function(t,e){var n=this.bbox();if(t-=n.x,e-=n.y,!isNaN(t)&&!isNaN(e))for(var r=this.length-1;0<=r;r--)this[r]=[this[r][0]+t,this[r][1]+e];return this},size:function(t,e){var n,r=this.bbox();for(n=this.length-1;0<=n;n--)r.width&&(this[n][0]=(this[n][0]-r.x)*t/r.width+r.x),r.height&&(this[n][1]=(this[n][1]-r.y)*e/r.height+r.y);return this},bbox:function(){var e=-1/0,n=-1/0,r=1/0,i=1/0;return this.forEach(function(t){e=Math.max(t[0],e),n=Math.max(t[1],n),r=Math.min(t[0],r),i=Math.min(t[1],i)}),{x:r,y:i,width:e-r,height:n-i}}});var xu={__proto__:null,MorphArray:_u,x:function(t){return null==t?this.bbox().x:this.move(t,this.bbox().y)},y:function(t){return null==t?this.bbox().y:this.move(this.bbox().x,t)},width:function(t){var e=this.bbox();return null==t?e.width:this.size(t,e.height)},height:function(t){var e=this.bbox();return null==t?e.height:this.size(e.width,t)}},Line=function(t){function Line(t){return Ti(this,Line),ps(this,ys(Line).call(this,Ri("line",t),t))}return ws(Line,Shape),as(Line,[{key:"array",value:function(){return new _u([[this.attr("x1"),this.attr("y1")],[this.attr("x2"),this.attr("y2")]])}},{key:"plot",value:function(t,e,n,r){return null==t?this.array():(t=void 0!==e?{x1:t,y1:e,x2:n,y2:r}:new _u(t).toLine(),this.attr(t))}},{key:"move",value:function(t,e){return this.attr(this.array().move(t,e).toLine())}},{key:"size",value:function(t,e){var n=_i(this,t,e);return this.attr(this.array().size(n.width,n.height).toLine())}}]),Line}();Vi(Line,xu),Nr({Container:{line:Hi(function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return Line.prototype.plot.apply(this.put(new Line),null!=e[0]?e:[0,0,0,0])})}}),zi(Line,"Line");var Marker=function(t){function Marker(t){return Ti(this,Marker),ps(this,ys(Marker).call(this,Ri("marker",t),t))}return ws(Marker,Container),as(Marker,[{key:"width",value:function(t){return this.attr("markerWidth",t)}},{key:"height",value:function(t){return this.attr("markerHeight",t)}},{key:"ref",value:function(t,e){return this.attr("refX",t).attr("refY",e)}},{key:"update",value:function(t){return this.clear(),"function"==typeof t&&t.call(this,this),this}},{key:"toString",value:function(){return"url(#"+this.id()+")"}}]),Marker}();Nr({Container:{marker:function(){var t;return(t=this.defs()).marker.apply(t,arguments)}},Defs:{marker:Hi(function(t,e,n){return this.put(new Marker).size(t,e).ref(t/2,e/2).viewbox(0,0,t,e).attr("orient","auto").update(n)})},marker:{marker:function(t,e,n,r){var i=["marker"];return"all"!==t&&i.push(t),i=i.join("-"),t=e instanceof Marker?e:this.defs().marker(e,n,r),this.attr(i,t)}}}),zi(Marker,"Marker");var ku=[].sort,Ou=[1,2,3],Su=m(function(){Ou.sort(void 0)}),Au=m(function(){Ou.sort(null)}),ju=Ui("sort");function Mu(e,n){return function(t){return null==t?this[t]:(this[e]=t,n&&n.call(this),this)}}Ct({target:"Array",proto:!0,forced:Su||!Au||ju},{sort:function(t){return void 0===t?ku.call(It(this)):ku.call(It(this),Se(t))}});var Eu={"-":function(t){return t},"<>":function(t){return-Math.cos(t*Math.PI)/2+.5},">":function(t){return Math.sin(t*Math.PI/2)},"<":function(t){return 1-Math.cos(t*Math.PI/2)},bezier:function(e,n,r,i){return function(t){return t<0?0<e?n/e*t:0<r?i/r*t:0:1<t?r<1?(1-i)/(1-r)*t+(i-r)/(1-r):e<1?(1-n)/(1-e)*t+(n-e)/(1-e):1:3*t*Math.pow(1-t,2)*n+3*Math.pow(t,2)*(1-t)*i+Math.pow(t,3)}},steps:function(i){var o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"end";o=o.split("-").reverse()[0];var s=i;return"none"===o?--s:"both"===o&&++s,function(t){var e=1<arguments.length&&void 0!==arguments[1]&&arguments[1],n=Math.floor(t*i),r=t*n%1==0;return"start"!==o&&"both"!==o||++n,e&&r&&--n,0<=t&&n<0&&(n=0),t<=1&&s<n&&(n=s),n/s}}},Tu=function(){function t(){Ti(this,t)}return as(t,[{key:"done",value:function(){return!1}}]),t}(),Cu=function(t){function n(t){var e;return Ti(this,n),(e=ps(this,ys(n).call(this))).ease=Eu[t||Qs.ease]||t,e}return ws(n,Tu),as(n,[{key:"step",value:function(t,e,n){return"number"!=typeof t?n<1?t:e:t+(e-t)*this.ease(n)}}]),n}(),Pu=function(t){function n(t){var e;return Ti(this,n),(e=ps(this,ys(n).call(this))).stepper=t,e}return ws(n,Tu),as(n,[{key:"step",value:function(t,e,n,r){return this.stepper(t,e,n,r)}},{key:"done",value:function(t){return t.done}}]),n}();function Iu(){var t=(this._duration||500)/1e3,e=this._overshoot||0,n=Math.PI,r=Math.log(e/100+1e-10),i=-r/Math.sqrt(n*n+r*r),o=3.9/(i*t);this.d=2*i*o,this.k=o*o}var Nu=function(t){function r(t,e){var n;return Ti(this,r),(n=ps(this,ys(r).call(this))).duration(t||500).overshoot(e||0),n}return ws(r,Pu),as(r,[{key:"step",value:function(t,e,n,r){if("string"==typeof t)return t;if(r.done=n===1/0,n===1/0)return e;if(0===n)return t;100<n&&(n=16),n/=1e3;var i=r.velocity||0,o=-this.d*i-this.k*(t-e),s=t+i*n+o*n*n/2;return r.velocity=i+o*n,r.done=Math.abs(e-s)+Math.abs(i)<.002,r.done?e:s}}]),r}();Vi(Nu,{duration:Mu("_duration",Iu),overshoot:Mu("_overshoot",Iu)});var Du=function(t){function o(t,e,n,r){var i;return Ti(this,o),t=null==t?.1:t,e=null==e?.01:e,n=null==n?0:n,r=null==r?1e3:r,(i=ps(this,ys(o).call(this))).p(t).i(e).d(n).windup(r),i}return ws(o,Pu),as(o,[{key:"step",value:function(t,e,n,r){if("string"==typeof t)return t;if(r.done=n===1/0,n===1/0)return e;if(0===n)return t;var i=e-t,o=(r.integral||0)+i*n,s=(i-(r.error||0))/n,u=this.windup;return!1!==u&&(o=Math.max(-u,Math.min(o,u))),r.error=i,r.integral=o,r.done=Math.abs(i)<.001,r.done?e:t+(this.P*i+this.I*o+this.D*s)}}]),o}();Vi(Du,{windup:Mu("windup"),p:Mu("P"),i:Mu("I"),d:Mu("D")});var Ru=Gs("PathArray",Zs);function Lu(t,e,n,r){return n+r.replace(ko," .")}for(var Fu={M:function(t,e,n){return e.x=n.x=t[0],e.y=n.y=t[1],["M",e.x,e.y]},L:function(t,e){return e.x=t[0],e.y=t[1],["L",t[0],t[1]]},H:function(t,e){return e.x=t[0],["H",t[0]]},V:function(t,e){return e.y=t[0],["V",t[0]]},C:function(t,e){return e.x=t[4],e.y=t[5],["C",t[0],t[1],t[2],t[3],t[4],t[5]]},S:function(t,e){return e.x=t[2],e.y=t[3],["S",t[0],t[1],t[2],t[3]]},Q:function(t,e){return e.x=t[2],e.y=t[3],["Q",t[0],t[1],t[2],t[3]]},T:function(t,e){return e.x=t[0],e.y=t[1],["T",t[0],t[1]]},Z:function(t,e,n){return e.x=n.x,e.y=n.y,["Z"]},A:function(t,e){return e.x=t[5],e.y=t[6],["A",t[0],t[1],t[2],t[3],t[4],t[5],t[6]]}},zu="mlhvqtcsaz".split(""),qu=0,Yu=zu.length;qu<Yu;++qu)Fu[zu[qu]]=function(o){return function(t,e,n){if("H"===o)t[0]=t[0]+e.x;else if("V"===o)t[0]=t[0]+e.y;else if("A"===o)t[5]=t[5]+e.x,t[6]=t[6]+e.y;else for(var r=0,i=t.length;r<i;++r)t[r]=t[r]+(r%2?e.y:e.x);return Fu[o](t,e,n)}}(zu[qu].toUpperCase());Vi(Ru,{toString:function(){return function(t){for(var e=0,n=t.length,r="";e<n;e++)r+=t[e][0],null!=t[e][1]&&(r+=t[e][1],null!=t[e][2]&&(r+=" ",r+=t[e][2],null!=t[e][3]&&(r+=" ",r+=t[e][3],r+=" ",r+=t[e][4],null!=t[e][5]&&(r+=" ",r+=t[e][5],r+=" ",r+=t[e][6],null!=t[e][7]&&(r+=" ",r+=t[e][7])))));return r+" "}(this)},move:function(t,e){var n=this.bbox();if(t-=n.x,e-=n.y,!isNaN(t)&&!isNaN(e))for(var r,i=this.length-1;0<=i;i--)"M"===(r=this[i][0])||"L"===r||"T"===r?(this[i][1]+=t,this[i][2]+=e):"H"===r?this[i][1]+=t:"V"===r?this[i][1]+=e:"C"===r||"S"===r||"Q"===r?(this[i][1]+=t,this[i][2]+=e,this[i][3]+=t,this[i][4]+=e,"C"===r&&(this[i][5]+=t,this[i][6]+=e)):"A"===r&&(this[i][6]+=t,this[i][7]+=e);return this},size:function(t,e){var n,r,i=this.bbox();for(i.width=0===i.width?1:i.width,i.height=0===i.height?1:i.height,n=this.length-1;0<=n;n--)"M"===(r=this[n][0])||"L"===r||"T"===r?(this[n][1]=(this[n][1]-i.x)*t/i.width+i.x,this[n][2]=(this[n][2]-i.y)*e/i.height+i.y):"H"===r?this[n][1]=(this[n][1]-i.x)*t/i.width+i.x:"V"===r?this[n][1]=(this[n][1]-i.y)*e/i.height+i.y:"C"===r||"S"===r||"Q"===r?(this[n][1]=(this[n][1]-i.x)*t/i.width+i.x,this[n][2]=(this[n][2]-i.y)*e/i.height+i.y,this[n][3]=(this[n][3]-i.x)*t/i.width+i.x,this[n][4]=(this[n][4]-i.y)*e/i.height+i.y,"C"===r&&(this[n][5]=(this[n][5]-i.x)*t/i.width+i.x,this[n][6]=(this[n][6]-i.y)*e/i.height+i.y)):"A"===r&&(this[n][1]=this[n][1]*t/i.width,this[n][2]=this[n][2]*e/i.height,this[n][6]=(this[n][6]-i.x)*t/i.width+i.x,this[n][7]=(this[n][7]-i.y)*e/i.height+i.y);return this},equalCommands:function(t){var e,n,r;for(t=new Ru(t),r=this.length===t.length,e=0,n=this.length;r&&e<n;e++)r=this[e][0]===t[e][0];return r},morph:function(t){return t=new Ru(t),this.equalCommands(t)?this.destination=t:this.destination=null,this},at:function(t){if(!this.destination)return this;var e,n,r,i,o=this,s=this.destination.value,u=[],a=new Ru;for(e=0,n=o.length;e<n;e++){for(u[e]=[o[e][0]],r=1,i=o[e].length;r<i;r++)u[e][r]=o[e][r]+(s[e][r]-o[e][r])*t;"A"===u[e][0]&&(u[e][4]=+(0!==u[e][4]),u[e][5]=+(0!==u[e][5]))}return a.value=u,a},parse:function(){var t,e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:[["M",0,0]];if(e instanceof Ru)return e;var n={M:2,L:2,H:1,V:1,C:6,S:4,Q:4,T:2,A:7,Z:0};e="string"==typeof e?e.replace(xo,Lu).replace(bo," $& ").replace(wo,"$1 -").trim().split(go):e.reduce(function(t,e){return[].concat.call(t,e)},[]);for(var r=[],i=new Rs,o=new Rs,s=0,u=e.length;_o.test(e[s])?(t=e[s],++s):"M"===t?t="L":"m"===t&&(t="l"),r.push(Fu[t].call(null,e.slice(s,s+=n[t.toUpperCase()]).map(parseFloat),i,o)),s<u;);return r},bbox:function(){return zs().path.setAttribute("d",this.toString()),zs.nodes.path.getBBox()}});var Xu=function(){function e(t){Ti(this,e),this._stepper=t||new Cu("-"),this._from=null,this._to=null,this._type=null,this._context=null,this._morphObj=null}return as(e,[{key:"from",value:function(t){return null==t?this._from:(this._from=this._set(t),this)}},{key:"to",value:function(t){return null==t?this._to:(this._to=this._set(t),this)}},{key:"type",value:function(t){return null==t?this._type:(this._type=t,this)}},{key:"_set",value:function(t){if(!this._type){var e=ce(t);"number"===e?this.type(Ks):"string"===e?fs.isColor(t)?this.type(fs):go.test(t)?this.type(bo.test(t)?Ru:Zs):so.test(t)?this.type(Ks):this.type(Gu):-1<Bu.indexOf(t.constructor)?this.type(t.constructor):Array.isArray(t)?this.type(Zs):"object"===e?this.type(Hu):this.type(Gu)}var n=new this._type(t);return this._type===fs&&(n=this._to?n[this._to[4]]():this._from?n[this._from[4]]():n),n=n.toArray(),this._morphObj=this._morphObj||new this._type,this._context=this._context||Array.apply(null,Array(n.length)).map(Object).map(function(t){return t.done=!0,t}),n}},{key:"stepper",value:function(t){return null==t?this._stepper:(this._stepper=t,this)}},{key:"done",value:function(){return this._context.map(this._stepper.done).reduce(function(t,e){return t&&e},!0)}},{key:"at",value:function(n){var r=this;return this._morphObj.fromArray(this._from.map(function(t,e){return r._stepper.step(t,r._to[e],n,r._context[e],r._context)}))}}]),e}(),Gu=function(){function t(){Ti(this,t),this.init.apply(this,arguments)}return as(t,[{key:"init",value:function(t){return t=Array.isArray(t)?t[0]:t,this.value=t,this}},{key:"valueOf",value:function(){return this.value}},{key:"toArray",value:function(){return[this.value]}}]),t}(),Vu=function(){function e(){Ti(this,e),this.init.apply(this,arguments)}return as(e,[{key:"init",value:function(t){return Array.isArray(t)&&(t={scaleX:t[0],scaleY:t[1],shear:t[2],rotate:t[3],translateX:t[4],translateY:t[5],originX:t[6],originY:t[7]}),Object.assign(this,e.defaults,t),this}},{key:"toArray",value:function(){var t=this;return[t.scaleX,t.scaleY,t.shear,t.rotate,t.translateX,t.translateY,t.originX,t.originY]}}]),e}();Vu.defaults={scaleX:1,scaleY:1,shear:0,rotate:0,translateX:0,translateY:0,originX:0,originY:0};var Hu=function(){function t(){Ti(this,t),this.init.apply(this,arguments)}return as(t,[{key:"init",value:function(t){if(this.values=[],!Array.isArray(t)){t=t||{};var e=[];for(var n in t)e.push([n,t[n]]);return e.sort(function(t,e){return t[0]-e[0]}),this.values=e.reduce(function(t,e){return t.concat(e)},[]),this}this.values=t}},{key:"valueOf",value:function(){for(var t={},e=this.values,n=0,r=e.length;n<r;n+=2)t[e[n]]=e[n+1];return t}},{key:"toArray",value:function(){return this.values}}]),t}(),Bu=[Gu,Vu,Hu];function Uu(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:[];Bu.push.apply(Bu,Cr([].concat(t)))}function $u(){Vi(Bu,{to:function(t){return(new Xu).type(this.constructor).from(this.valueOf()).to(t)},fromArray:function(t){return this.init(t),this}})}var Path=function(t){function Path(t){return Ti(this,Path),ps(this,ys(Path).call(this,Ri("path",t),t))}return ws(Path,Shape),as(Path,[{key:"array",value:function(){return this._array||(this._array=new Ru(this.attr("d")))}},{key:"plot",value:function(t){return null==t?this.array():this.clear().attr("d","string"==typeof t?t:this._array=new Ru(t))}},{key:"clear",value:function(){return delete this._array,this}},{key:"move",value:function(t,e){return this.attr("d",this.array().move(t,e))}},{key:"x",value:function(t){return null==t?this.bbox().x:this.move(t,this.bbox().y)}},{key:"y",value:function(t){return null==t?this.bbox().y:this.move(this.bbox().x,t)}},{key:"size",value:function(t,e){var n=_i(this,t,e);return this.attr("d",this.array().size(n.width,n.height))}},{key:"width",value:function(t){return null==t?this.bbox().width:this.size(t,this.bbox().height)}},{key:"height",value:function(t){return null==t?this.bbox().height:this.size(this.bbox().width,t)}},{key:"targets",value:function(){return Bs('svg textpath [href*="'+this.id()+'"]')}}]),Path}();Path.prototype.MorphArray=Ru,Nr({Container:{path:Hi(function(t){return this.put(new Path).plot(t||new Ru)})}}),zi(Path,"Path");var Qu={__proto__:null,array:function(){return this._array||(this._array=new _u(this.attr("points")))},plot:function(t){return null==t?this.array():this.clear().attr("points","string"==typeof t?t:this._array=new _u(t))},clear:function(){return delete this._array,this},move:function(t,e){return this.attr("points",this.array().move(t,e))},size:function(t,e){var n=_i(this,t,e);return this.attr("points",this.array().size(n.width,n.height))}},Polygon=function(t){function Polygon(t){return Ti(this,Polygon),ps(this,ys(Polygon).call(this,Ri("polygon",t),t))}return ws(Polygon,Shape),Polygon}();Nr({Container:{polygon:Hi(function(t){return this.put(new Polygon).plot(t||new _u)})}}),Vi(Polygon,xu),Vi(Polygon,Qu),zi(Polygon,"Polygon");var Polyline=function(t){function Polyline(t){return Ti(this,Polyline),ps(this,ys(Polyline).call(this,Ri("polyline",t),t))}return ws(Polyline,Shape),Polyline}();Nr({Container:{polyline:Hi(function(t){return this.put(new Polyline).plot(t||new _u)})}}),Vi(Polyline,xu),Vi(Polyline,Qu),zi(Polyline,"Polyline");var Rect=function(t){function Rect(t){return Ti(this,Rect),ps(this,ys(Rect).call(this,Ri("rect",t),t))}return ws(Rect,Shape),Rect}();Vi(Rect,{rx:au,ry:hu}),Nr({Container:{rect:Hi(function(t,e){return this.put(new Rect).size(t,e)})}}),zi(Rect,"Rect");var Wu=Math.max,Ju=Math.min;Ct({target:"Array",proto:!0,forced:!Wt("splice")},{splice:function(t,e){var n,r,A,i,o,s,u=It(this),a=ht(u.length),h=ft(t,a),l=arguments.length;if(0===l?n=r=0:r=1===l?(n=0,a-h):(n=l-2,Ju(Wu(ut(e),0),a-h)),9007199254740991<a+n-r)throw TypeError("Maximum allowed length exceeded");for(A=Me(u,r),i=0;i<r;i++)(o=h+i)in u&&zt(A,i,u[o]);if(n<(A.length=r)){for(i=h;i<a-r;i++)s=i+n,(o=i+r)in u?u[s]=u[o]:delete u[s];for(i=a;a-r+n<i;i--)delete u[i-1]}else if(r<n)for(i=a-r;h<i;i--)s=i+n-1,(o=i+r-1)in u?u[s]=u[o]:delete u[s];for(i=0;i<n;i++)u[i+h]=arguments[i+2];return u.length=a-r+n,A}});var Zu=function(){function t(){Ti(this,t),this._first=null,this._last=null}return as(t,[{key:"push",value:function(t){var e=t.next?t:{value:t,next:null,prev:null};return this._last?(e.prev=this._last,this._last.next=e,this._last=e):(this._last=e,this._first=e),e}},{key:"shift",value:function(){var t=this._first;return t?(this._first=t.next,this._first&&(this._first.prev=null),this._last=this._first?this._last:null,t.value):null}},{key:"first",value:function(){return this._first&&this._first.value}},{key:"last",value:function(){return this._last&&this._last.value}},{key:"remove",value:function(t){t.prev&&(t.prev.next=t.next),t.next&&(t.next.prev=t.prev),t===this._last&&(this._last=t.prev),t===this._first&&(this._first=t.next),t.prev=null,t.next=null}}]),t}(),Ku={nextDraw:null,frames:new Zu,timeouts:new Zu,immediates:new Zu,timer:function(){return Ei.window.performance||Ei.window.Date},transforms:[],frame:function(t){var e=Ku.frames.push({run:t});return null===Ku.nextDraw&&(Ku.nextDraw=Ei.window.requestAnimationFrame(Ku._draw)),e},timeout:function(t,e){e=e||0;var n=Ku.timer().now()+e,r=Ku.timeouts.push({run:t,time:n});return null===Ku.nextDraw&&(Ku.nextDraw=Ei.window.requestAnimationFrame(Ku._draw)),r},immediate:function(t){var e=Ku.immediates.push(t);return null===Ku.nextDraw&&(Ku.nextDraw=Ei.window.requestAnimationFrame(Ku._draw)),e},cancelFrame:function(t){null!=t&&Ku.frames.remove(t)},clearTimeout:function(t){null!=t&&Ku.timeouts.remove(t)},cancelImmediate:function(t){null!=t&&Ku.immediates.remove(t)},_draw:function(t){for(var e=null,n=Ku.timeouts.last();(e=Ku.timeouts.shift())&&(t>=e.time?e.run():Ku.timeouts.push(e),e!==n););for(var r=null,i=Ku.frames.last();r!==i&&(r=Ku.frames.shift());)r.run(t);for(var o=null;o=Ku.immediates.shift();)o();Ku.nextDraw=Ku.timeouts.first()||Ku.frames.first()?Ei.window.requestAnimationFrame(Ku._draw):null}},ta=function(t){var e=t.start,n=t.runner.duration();return{start:e,duration:n,end:e+n,runner:t.runner}},ea=function(){var t=Ei.window;return(t.performance||t.Date).now()},na=function(t){function n(){var t,e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:ea;return Ti(this,n),(t=ps(this,ys(n).call(this)))._timeSource=e,t._startTime=0,t._speed=1,t._persist=0,t._nextFrame=null,t._paused=!0,t._runners=[],t._runnerIds=[],t._lastRunnerId=-1,t._time=0,t._lastSourceTime=0,t._lastStepTime=0,t._step=t._stepFn.bind(ds(t),!1),t._stepImmediate=t._stepFn.bind(ds(t),!0),t}return ws(n,Us),as(n,[{key:"schedule",value:function(t,e,n){if(null==t)return this._runners.map(ta);var r=0,i=this.getEndTime();if(e=e||0,null==n||"last"===n||"after"===n)r=i;else if("absolute"===n||"start"===n)r=e,e=0;else if("now"===n)r=this._time;else{if("relative"!==n)throw new Error('Invalid value for the "when" parameter');var o=this._runners[t.id];o&&(r=o.start+e,e=0)}t.unschedule(),t.timeline(this);var s=t.persist(),u={persist:null===s?this._persist:s,start:r+e,runner:t};return this._lastRunnerId=t.id,this._runners.push(u),this._runners.sort(function(t,e){return t.start-e.start}),this._runnerIds=this._runners.map(function(t){return t.runner.id}),this.updateTime()._continue(),this}},{key:"unschedule",value:function(t){var e=this._runnerIds.indexOf(t.id);return e<0||(this._runners.splice(e,1),this._runnerIds.splice(e,1),t.timeline(null)),this}},{key:"getEndTime",value:function(){var t=this._runners[this._runnerIds.indexOf(this._lastRunnerId)],e=t?t.runner.duration():0;return(t?t.start:0)+e}},{key:"getEndTimeOfTimeline",value:function(){for(var t=0,e=0;e<this._runners.length;e++){var n=this._runners[e],r=n?n.runner.duration():0,i=(n?n.start:0)+r;t<i&&(t=i)}return t}},{key:"updateTime",value:function(){return this.active()||(this._lastSourceTime=this._timeSource()),this}},{key:"play",value:function(){return this._paused=!1,this.updateTime()._continue()}},{key:"pause",value:function(){return this._paused=!0,this._continue()}},{key:"stop",value:function(){return this.time(0),this.pause()}},{key:"finish",value:function(){return this.time(this.getEndTimeOfTimeline()+1),this.pause()}},{key:"speed",value:function(t){return null==t?this._speed:(this._speed=t,this)}},{key:"reverse",value:function(t){var e=this.speed();if(null==t)return this.speed(-e);var n=Math.abs(e);return this.speed(t?n:-n)}},{key:"seek",value:function(t){return this.time(this._time+t)}},{key:"time",value:function(t){return null==t?this._time:(this._time=t,this._continue(!0))}},{key:"persist",value:function(t){return null==t?this._persist:(this._persist=t,this)}},{key:"source",value:function(t){return null==t?this._timeSource:(this._timeSource=t,this)}},{key:"_stepFn",value:function(){var t=0<arguments.length&&void 0!==arguments[0]&&arguments[0],e=this._timeSource(),n=e-this._lastSourceTime;t&&(n=0);var r=this._speed*n+(this._time-this._lastStepTime);this._lastSourceTime=e,t||(this._time+=r,this._time=this._time<0?0:this._time),this._lastStepTime=this._time,this.fire("time",this._time);for(var i=this._runners.length;i--;){var o=this._runners[i],s=o.runner;this._time-o.start<=0&&s.reset()}for(var u=!1,a=0,h=this._runners.length;a<h;a++){var l=this._runners[a],c=l.runner,f=r,v=this._time-l.start;if(v<=0)u=!0;else if(v<f&&(f=v),c.active())if(c.step(f).done){if(!0!==l.persist){c.duration()-c.time()+this._time+l.persist<this._time&&(c.unschedule(),--a,--h)}}else u=!0}return u&&!(this._speed<0&&0===this._time)||this._runnerIds.length&&this._speed<0&&0<this._time?this._continue():(this.pause(),this.fire("finished")),this}},{key:"_continue",value:function(){var t=0<arguments.length&&void 0!==arguments[0]&&arguments[0];return Ku.cancelFrame(this._nextFrame),this._nextFrame=null,t?this._stepImmediate():(this._paused||(this._nextFrame=Ku.frame(this._step)),this)}},{key:"active",value:function(){return!!this._nextFrame}}]),n}();function ra(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function ia(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?ra(n,!0).forEach(function(t){su(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):ra(n).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}Nr({Element:{timeline:function(t){return null==t?(this._timeline=this._timeline||new na,this._timeline):(this._timeline=t,this)}}});var oa=function(t){function o(t){var e;return Ti(this,o),(e=ps(this,ys(o).call(this))).id=o.id++,t="function"==typeof(t=null==t?Qs.duration:t)?new Pu(t):t,e._element=null,e._timeline=null,e.done=!1,e._queue=[],e._duration="number"==typeof t&&t,e._isDeclarative=t instanceof Pu,e._stepper=e._isDeclarative?t:new Cu,e._history={},e.enabled=!0,e._time=0,e._lastTime=0,e._reseted=!0,e.transforms=new Fs,e.transformId=1,e._haveReversed=!1,e._reverse=!1,e._loopsDone=0,e._swing=!1,e._wait=0,e._times=1,e._frameId=null,e._persist=!!e._isDeclarative||null,e}return ws(o,Us),as(o,[{key:"element",value:function(t){return null==t?this._element:((this._element=t)._prepareRunner(),this)}},{key:"timeline",value:function(t){return void 0===t?this._timeline:(this._timeline=t,this)}},{key:"animate",value:function(t,e,n){var r=o.sanitise(t,e,n),i=new o(r.duration);return this._timeline&&i.timeline(this._timeline),this._element&&i.element(this._element),i.loop(r).schedule(r.delay,r.when)}},{key:"schedule",value:function(t,e,n){if(t instanceof na||(n=e,e=t,t=this.timeline()),!t)throw Error("Runner cannot be scheduled without timeline");return t.schedule(this,e,n),this}},{key:"unschedule",value:function(){var t=this.timeline();return t&&t.unschedule(this),this}},{key:"loop",value:function(t,e,n){return"object"===ce(t)&&(e=t.swing,n=t.wait,t=t.times),this._times=t||1/0,this._swing=e||!1,this._wait=n||0,!0===this._times&&(this._times=1/0),this}},{key:"delay",value:function(t){return this.animate(0,t)}},{key:"queue",value:function(t,e,n,r){return this._queue.push({initialiser:t||$s,runner:e||$s,retarget:n,isTransform:r,initialised:!1,finished:!1}),this.timeline()&&this.timeline()._continue(),this}},{key:"during",value:function(t){return this.queue(null,t)}},{key:"after",value:function(t){return this.on("finished",t)}},{key:"time",value:function(t){if(null==t)return this._time;var e=t-this._time;return this.step(e),this}},{key:"duration",value:function(){return this._times*(this._wait+this._duration)-this._wait}},{key:"loops",value:function(t){var e=this._duration+this._wait;if(null==t){var n=Math.floor(this._time/e),r=(this._time-n*e)/this._duration;return Math.min(n+r,this._times)}var i=t%1,o=e*Math.floor(t)+this._duration*i;return this.time(o)}},{key:"persist",value:function(t){return null==t?this._persist:(this._persist=t,this)}},{key:"position",value:function(t){var e,n=this._time,i=this._duration,o=this._wait,r=this._times,s=this._swing,u=this._reverse;if(null==t){var a=function(t){var e=s*Math.floor(t%(2*(o+i))/(o+i)),n=e&&!u||!e&&u,r=Math.pow(-1,n)*(t%(o+i))/i+n;return Math.max(Math.min(r,1),0)},h=r*(o+i)-o;return e=n<=0?Math.round(a(1e-5)):n<h?a(n):Math.round(a(h-1e-5)),e}var l=Math.floor(this.loops()),c=s&&l%2==0;return e=l+(c&&!u||u&&c?t:1-t),this.loops(e)}},{key:"progress",value:function(t){return null==t?Math.min(1,this._time/this.duration()):this.time(t*this.duration())}},{key:"step",value:function(t){if(!this.enabled)return this;t=null==t?16:t,this._time+=t;var e=this.position(),n=this._lastPosition!==e&&0<=this._time;this._lastPosition=e;var r=this.duration(),i=this._lastTime<=0&&0<this._time,o=this._lastTime<r&&this._time>=r;this._lastTime=this._time,i&&this.fire("start",this);var s=this._isDeclarative;if(this.done=!s&&!o&&this._time>=r,this._reseted=!1,n||s){this._initialise(n),this.transforms=new Fs;var u=this._run(s?t:e);this.fire("step",this)}return this.done=this.done||u&&s,o&&this.fire("finished",this),this}},{key:"reset",value:function(){return this._reseted||(this.time(0),this._reseted=!0),this}},{key:"finish",value:function(){return this.step(1/0)}},{key:"reverse",value:function(t){return this._reverse=null==t?!this._reverse:t,this}},{key:"ease",value:function(t){return this._stepper=new Cu(t),this}},{key:"active",value:function(t){return null==t?this.enabled:(this.enabled=t,this)}},{key:"_rememberMorpher",value:function(t,e){if(this._history[t]={morpher:e,caller:this._queue[this._queue.length-1]},this._isDeclarative){var n=this.timeline();n&&n.play()}}},{key:"_tryRetarget",value:function(t,e,n){if(this._history[t]){if(!this._history[t].caller.initialised){var r=this._queue.indexOf(this._history[t].caller);return this._queue.splice(r,1),!1}this._history[t].caller.retarget?this._history[t].caller.retarget(e,n):this._history[t].morpher.to(e),this._history[t].caller.finished=!1;var i=this.timeline();return i&&i.play(),!0}return!1}},{key:"_initialise",value:function(t){if(t||this._isDeclarative)for(var e=0,n=this._queue.length;e<n;++e){var r=this._queue[e],i=this._isDeclarative||!r.initialised&&t;t=!r.finished,i&&t&&(r.initialiser.call(this),r.initialised=!0)}}},{key:"_run",value:function(t){for(var e=!0,n=0,r=this._queue.length;n<r;++n){var i=this._queue[n],o=i.runner.call(this,t);i.finished=i.finished||!0===o,e=e&&i.finished}return e}},{key:"addTransform",value:function(t,e){return this.transforms.lmultiplyO(t),this}},{key:"clearTransform",value:function(){return this.transforms=new Fs,this}},{key:"clearTransformsFromQueue",value:function(){this.done&&this._timeline&&this._timeline._runnerIds.includes(this.id)||(this._queue=this._queue.filter(function(t){return!t.isTransform}))}}],[{key:"sanitise",value:function(t,e,n){var r=1,i=!1,o=0;return e=e||Qs.delay,n=n||"last","object"!==ce(t=t||Qs.duration)||t instanceof Tu||(e=t.delay||e,n=t.when||n,i=t.swing||i,r=t.times||r,o=t.wait||o,t=t.duration||Qs.duration),{duration:t,delay:e,swing:i,times:r,wait:o,when:n}}}]),o}();oa.id=0;var sa=function(){function r(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:new Fs,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:-1,n=!(2<arguments.length&&void 0!==arguments[2])||arguments[2];Ti(this,r),this.transforms=t,this.id=e,this.done=n}return as(r,[{key:"clearTransformsFromQueue",value:function(){}}]),r}();Vi([oa,sa],{mergeWith:function(t){return new sa(t.transforms.lmultiply(this.transforms),t.id)}});var ua=function(t,e){return t.lmultiplyO(e)},aa=function(t){return t.transforms};var ha=function(){function t(){Ti(this,t),this.runners=[],this.ids=[]}return as(t,[{key:"add",value:function(t){if(!this.runners.includes(t)){var e=t.id+1;return this.runners.push(t),this.ids.push(e),this}}},{key:"getByID",value:function(t){return this.runners[this.ids.indexOf(t+1)]}},{key:"remove",value:function(t){var e=this.ids.indexOf(t+1);return this.ids.splice(e,1),this.runners.splice(e,1),this}},{key:"merge",value:function(){var n=this,r=null;return this.runners.forEach(function(t,e){r&&t.done&&r.done&&(!t._timeline||!t._timeline._runnerIds.includes(t.id))&&(!r._timeline||!r._timeline._runnerIds.includes(r.id))&&(n.remove(t.id),n.edit(r.id,t.mergeWith(r))),r=t}),this}},{key:"edit",value:function(t,e){var n=this.ids.indexOf(t+1);return this.ids.splice(n,1,t+1),this.runners.splice(n,1,e),this}},{key:"length",value:function(){return this.ids.length}},{key:"clearBefore",value:function(t){var e=this.ids.indexOf(t+1)||1;return this.ids.splice(0,e,0),this.runners.splice(0,e,new sa).forEach(function(t){return t.clearTransformsFromQueue()}),this}}]),t}();Nr({Element:{animate:function(t,e,n){var r=oa.sanitise(t,e,n),i=this.timeline();return new oa(r.duration).loop(r).element(this).timeline(i.play()).schedule(r.delay,r.when)},delay:function(t,e){return this.animate(0,t,e)},_clearTransformRunnersBefore:function(t){this._transformationRunners.clearBefore(t.id)},_currentTransform:function(e){return this._transformationRunners.runners.filter(function(t){return t.id<=e.id}).map(aa).reduce(ua,new Fs)},_addRunner:function(t){this._transformationRunners.add(t),Ku.cancelImmediate(this._frameId),this._frameId=Ku.immediate(function(){var t=this._transformationRunners.runners.map(aa).reduce(ua,new Fs);this.transform(t),this._transformationRunners.merge(),1===this._transformationRunners.length()&&(this._frameId=null)}.bind(this))},_prepareRunner:function(){null==this._frameId&&(this._transformationRunners=(new ha).add(new sa(new Fs(this))))}}}),Vi(oa,{attr:function(t,e){return this.styleAttr("attr",t,e)},css:function(t,e){return this.styleAttr("css",t,e)},styleAttr:function(e,n,t){if("object"===ce(n)){for(var r in n)this.styleAttr(e,r,n[r]);return this}var i=new Xu(this._stepper).to(t);return this.queue(function(){i=i.from(this.element()[e](n))},function(t){return this.element()[e](n,i.at(t)),i.done()}),this},zoom:function(t,n){if(this._tryRetarget("zoom",gu,n))return this;var r=new Xu(this._stepper).to(new Ks(t));return this.queue(function(){r=r.from(this.element().zoom())},function(t){return this.element().zoom(r.at(t),n),r.done()},function(t,e){n=e,r.to(t)}),this._rememberMorpher("zoom",r),this},transform:function(v,d,p){if(d=v.relative||d,this._isDeclarative&&!d&&this._tryRetarget("transform",v))return this;var y=Fs.isMatrixLike(v);p=null!=v.affine?v.affine:null!=p?p:!y;var m,g,w,b,_,x=new Xu(this._stepper).type(p?Vu:Fs);return this.queue(function(){g=g||this.element(),m=m||xi(v,g),_=new Fs(d?void 0:g),g._addRunner(this),d||g._clearTransformRunnersBefore(this)},function(t){d||this.clearTransform();var e=new Rs(m).transform(g._currentTransform(this)),n=e.x,r=e.y,i=new Fs(ia({},v,{origin:[n,r]})),o=this._isDeclarative&&w?w:_;if(p){i=i.decompose(n,r),o=o.decompose(n,r);var s=i.rotate,u=o.rotate,a=[s-360,s,s+360],h=a.map(function(t){return Math.abs(t-u)}),l=Math.min.apply(Math,Cr(h)),c=h.indexOf(l);i.rotate=a[c]}d&&(y||(i.rotate=v.rotate||0),this._isDeclarative&&b&&(o.rotate=b)),x.from(o),x.to(i);var f=x.at(t);return b=f.rotate,w=new Fs(f),this.addTransform(w),g._addRunner(this),x.done()},function(t){(t.origin||"center").toString()!==(v.origin||"center").toString()&&(m=xi(v,g)),v=ia({},t,{origin:m})},!0),this._isDeclarative&&this._rememberMorpher("transform",x),this},x:function(t,e){return this._queueNumber("x",t)},y:function(t){return this._queueNumber("y",t)},dx:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0;return this._queueNumberDelta("x",t)},dy:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0;return this._queueNumberDelta("y",t)},dmove:function(t,e){return this.dx(t).dy(e)},_queueNumberDelta:function(e,t){if(t=new Ks(t),this._tryRetarget(e,t))return this;var n=new Xu(this._stepper).to(t),r=null;return this.queue(function(){r=this.element()[e](),n.from(r),n.to(r+t)},function(t){return this.element()[e](n.at(t)),n.done()},function(t){n.to(r+new Ks(t))}),this._rememberMorpher(e,n),this},_queueObject:function(e,t){if(this._tryRetarget(e,t))return this;var n=new Xu(this._stepper).to(t);return this.queue(function(){n.from(this.element()[e]())},function(t){return this.element()[e](n.at(t)),n.done()}),this._rememberMorpher(e,n),this},_queueNumber:function(t,e){return this._queueObject(t,new Ks(e))},cx:function(t){return this._queueNumber("cx",t)},cy:function(t){return this._queueNumber("cy",t)},move:function(t,e){return this.x(t).y(e)},center:function(t,e){return this.cx(t).cy(e)},size:function(t,e){var n;return t&&e||(n=this._element.bbox()),t||(t=n.width/n.height*e),e||(e=n.height/n.width*t),this.width(t).height(e)},width:function(t){return this._queueNumber("width",t)},height:function(t){return this._queueNumber("height",t)},plot:function(t,e,n,r){if(4===arguments.length)return this.plot([t,e,n,r]);if(this._tryRetarget("plot",t))return this;var i=new Xu(this._stepper).type(this._element.MorphArray).to(t);return this.queue(function(){i.from(this._element.array())},function(t){return this._element.plot(i.at(t)),i.done()}),this._rememberMorpher("plot",i),this},leading:function(t){return this._queueNumber("leading",t)},viewbox:function(t,e,n,r){return this._queueObject("viewbox",new Ys(t,e,n,r))},update:function(t){return"object"!==ce(t)?this.update({offset:t,color:arguments[1],opacity:arguments[2]}):(null!=t.opacity&&this.attr("stop-opacity",t.opacity),null!=t.color&&this.attr("stop-color",t.color),null!=t.offset&&this.attr("offset",t.offset),this)}}),Vi(oa,{rx:au,ry:hu,from:mu,to:gu}),zi(oa,"Runner");var Svg=function(t){function Svg(t){var e;return Ti(this,Svg),(e=ps(this,ys(Svg).call(this,Ri("svg",t),t))).namespace(),e}return ws(Svg,Container),as(Svg,[{key:"isRoot",value:function(){return!(this.node.parentNode&&this.node.parentNode instanceof Ei.window.SVGElement&&"#document"!==this.node.parentNode.nodeName)}},{key:"root",value:function(){return this.isRoot()?this:ms(ys(Svg.prototype),"root",this).call(this)}},{key:"namespace",value:function(){return this.isRoot()?this.attr({xmlns:Oi,version:"1.1"}).attr("xmlns:xlink",Ai,Si).attr("xmlns:svgjs",ji,Si):this.root().namespace()}},{key:"defs",value:function(){return this.isRoot()?Li(this.node.querySelector("defs"))||this.put(new Defs):this.root().defs()}},{key:"parent",value:function(t){return this.isRoot()?"#document"===this.node.parentNode.nodeName?null:Li(this.node.parentNode):ms(ys(Svg.prototype),"parent",this).call(this,t)}},{key:"clear",value:function(){for(;this.node.hasChildNodes();)this.node.removeChild(this.node.lastChild);return delete this._defs,this}}]),Svg}();Nr({Container:{nested:Hi(function(){return this.put(new Svg)})}}),zi(Svg,"Svg",!0);var la=function(t){function e(t){return Ti(this,e),ps(this,ys(e).call(this,Ri("symbol",t),t))}return ws(e,Container),e}();Nr({Container:{symbol:Hi(function(){return this.put(new la)})}}),zi(la,"Symbol");var ca={__proto__:null,plain:function(t){return!1===this._build&&this.clear(),this.node.appendChild(Ei.document.createTextNode(t)),this},length:function(){return this.node.getComputedTextLength()}},Text=function(t){function Text(t){var e;return Ti(this,Text),(e=ps(this,ys(Text).call(this,Ri("text",t),t))).dom.leading=new Ks(1.3),e._rebuild=!0,e._build=!1,e}return ws(Text,Shape),as(Text,[{key:"x",value:function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:this.bbox();return null==t?e.x:this.attr("x",this.attr("x")+t-e.x)}},{key:"y",value:function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:this.bbox();return null==t?e.y:this.attr("y",this.attr("y")+t-e.y)}},{key:"move",value:function(t,e){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:this.bbox();return this.x(t,n).y(e,n)}},{key:"cx",value:function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:this.bbox();return null==t?e.cx:this.attr("x",this.attr("x")+t-e.cx)}},{key:"cy",value:function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:this.bbox();return null==t?e.cy:this.attr("y",this.attr("y")+t-e.cy)}},{key:"center",value:function(t,e){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:this.bbox();return this.cx(t,n).cy(e,n)}},{key:"text",value:function(t){if(void 0===t){var e=this.node.childNodes,n=0;t="";for(var r=0,i=e.length;r<i;++r)"textPath"!==e[r].nodeName?(r!==n&&3!==e[r].nodeType&&!0===Li(e[r]).dom.newLined&&(t+="\n"),t+=e[r].textContent):0===r&&(n=1);return t}if(this.clear().build(!0),"function"==typeof t)t.call(this,this);else for(var o=0,s=(t=t.split("\n")).length;o<s;o++)this.tspan(t[o]).newLine();return this.build(!1).rebuild()}},{key:"leading",value:function(t){return null==t?this.dom.leading:(this.dom.leading=new Ks(t),this.rebuild())}},{key:"rebuild",value:function(t){if("boolean"==typeof t&&(this._rebuild=t),this._rebuild){var n=this,r=0,i=this.dom.leading;this.each(function(){var t=Ei.window.getComputedStyle(this.node).getPropertyValue("font-size"),e=i*new Ks(t);this.dom.newLined&&(this.attr("x",n.attr("x")),"\n"===this.text()?r+=e:(this.attr("dy",e+r),r=0))}),this.fire("rebuild")}return this}},{key:"build",value:function(t){return this._build=!!t,this}},{key:"setData",value:function(t){return this.dom=t,this.dom.leading=new Ks(t.leading||1.3),this}}]),Text}();Vi(Text,ca),Nr({Container:{text:Hi(function(t){return this.put(new Text).text(t)}),plain:Hi(function(t){return this.put(new Text).plain(t)})}}),zi(Text,"Text");var Tspan=function(t){function Tspan(t){return Ti(this,Tspan),ps(this,ys(Tspan).call(this,Ri("tspan",t),t))}return ws(Tspan,Text),as(Tspan,[{key:"text",value:function(t){return null==t?this.node.textContent+(this.dom.newLined?"\n":""):("function"==typeof t?t.call(this,this):this.plain(t),this)}},{key:"dx",value:function(t){return this.attr("dx",t)}},{key:"dy",value:function(t){return this.attr("dy",t)}},{key:"x",value:function(t){return this.attr("x",t)}},{key:"y",value:function(t){return this.attr("x",t)}},{key:"move",value:function(t,e){return this.x(t).y(e)}},{key:"newLine",value:function(){var t=this.parent(Text);this.dom.newLined=!0;var e=Ei.window.getComputedStyle(this.node).getPropertyValue("font-size"),n=t.dom.leading*new Ks(e);return this.dy(n).attr("x",t.x())}}]),Tspan}();Vi(Tspan,ca),Nr({Tspan:{tspan:Hi(function(t){var e=new Tspan;return this._build||this.clear(),this.node.appendChild(e.node),e.text(t)})}}),zi(Tspan,"Tspan");var ClipPath=function(t){function ClipPath(t){return Ti(this,ClipPath),ps(this,ys(ClipPath).call(this,Ri("clipPath",t),t))}return ws(ClipPath,Container),as(ClipPath,[{key:"remove",value:function(){return this.targets().forEach(function(t){t.unclip()}),ms(ys(ClipPath.prototype),"remove",this).call(this)}},{key:"targets",value:function(){return Bs('svg [clip-path*="'+this.id()+'"]')}}]),ClipPath}();Nr({Container:{clip:Hi(function(){return this.defs().put(new ClipPath)})},Element:{clipWith:function(t){var e=t instanceof ClipPath?t:this.parent().clip().add(t);return this.attr("clip-path",'url("#'+e.id()+'")')},unclip:function(){return this.attr("clip-path",null)},clipper:function(){return this.reference("clip-path")}}}),zi(ClipPath,"ClipPath");var fa=function(t){function e(t){return Ti(this,e),ps(this,ys(e).call(this,Ri("foreignObject",t),t))}return ws(e,Element),e}();Nr({Container:{foreignObject:Hi(function(t,e){return this.put(new fa).size(t,e)})}}),zi(fa,"ForeignObject");var G=function(t){function G(t){return Ti(this,G),ps(this,ys(G).call(this,Ri("g",t),t))}return ws(G,Container),as(G,[{key:"x",value:function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:this.bbox();return null==t?e.x:this.move(t,e.y,e)}},{key:"y",value:function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:this.bbox();return null==t?e.y:this.move(e.x,t,e)}},{key:"move",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:this.bbox(),r=t-n.x,i=e-n.y;return this.dmove(r,i)}},{key:"dx",value:function(t){return this.dmove(t,0)}},{key:"dy",value:function(t){return this.dmove(0,t)}},{key:"dmove",value:function(s,u){return this.children().forEach(function(t,e){var n=t.bbox(),r=new Fs(t),i=r.translate(s,u).transform(r.inverse()),o=new Rs(n.x,n.y).transform(i);t.move(o.x,o.y)}),this}},{key:"width",value:function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:this.bbox();return null==t?e.width:this.size(t,e.height,e)}},{key:"height",value:function(t){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:this.bbox();return null==t?e.height:this.size(e.width,t,e)}},{key:"size",value:function(t,e){var r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:this.bbox(),n=_i(this,t,e,r),i=n.width/r.width,o=n.height/r.height;return this.children().forEach(function(t,e){var n=new Rs(r).transform(new Fs(t).inverse());t.scale(i,o,n.x,n.y)}),this}}]),G}();Nr({Container:{group:Hi(function(){return this.put(new G)})}}),zi(G,"G");var A=function(t){function A(t){return Ti(this,A),ps(this,ys(A).call(this,Ri("a",t),t))}return ws(A,Container),as(A,[{key:"to",value:function(t){return this.attr("href",t,Ai)}},{key:"target",value:function(t){return this.attr("target",t)}}]),A}();Nr({Container:{link:Hi(function(t){return this.put(new A).to(t)})},Element:{linkTo:function(t){var e=new A;return"function"==typeof t?t.call(e,e):e.to(t),this.parent().put(e).put(this)}}}),zi(A,"A");var Mask=function(t){function Mask(t){return Ti(this,Mask),ps(this,ys(Mask).call(this,Ri("mask",t),t))}return ws(Mask,Container),as(Mask,[{key:"remove",value:function(){return this.targets().forEach(function(t){t.unmask()}),ms(ys(Mask.prototype),"remove",this).call(this)}},{key:"targets",value:function(){return Bs('svg [mask*="'+this.id()+'"]')}}]),Mask}();function va(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}Nr({Container:{mask:Hi(function(){return this.defs().put(new Mask)})},Element:{maskWith:function(t){var e=t instanceof Mask?t:this.parent().mask().add(t);return this.attr("mask",'url("#'+e.id()+'")')},unmask:function(){return this.attr("mask",null)},masker:function(){return this.reference("mask")}}}),zi(Mask,"Mask");var Style=function(t){function Style(t){return Ti(this,Style),ps(this,ys(Style).call(this,Ri("style",t),t))}return ws(Style,Element),as(Style,[{key:"addText",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:"";return this.node.textContent+=t,this}},{key:"font",value:function(t,e){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};return this.rule("@font-face",function(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?va(n,!0).forEach(function(t){su(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):va(n).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}({fontFamily:t,src:e},n))}},{key:"rule",value:function(t,e){return this.addText(function(t,e){if(!t)return"";if(!e)return t;var n=t+"{";for(var r in e)n+=wi(r)+":"+e[r]+";";return n+="}"}(t,e))}}]),Style}();Nr("Dom",{style:Hi(function(t,e){return this.put(new Style).rule(t,e)}),fontface:Hi(function(t,e,n){return this.put(new Style).font(t,e,n)})}),zi(Style,"Style");var TextPath=function(t){function TextPath(t){return Ti(this,TextPath),ps(this,ys(TextPath).call(this,Ri("textPath",t),t))}return ws(TextPath,Text),as(TextPath,[{key:"array",value:function(){var t=this.track();return t?t.array():null}},{key:"plot",value:function(t){var e=this.track(),n=null;return e&&(n=e.plot(t)),null==t?n:this}},{key:"track",value:function(){return this.reference("href")}}]),TextPath}();Nr({Container:{textPath:Hi(function(t,e){return t instanceof Text||(t=this.text(t)),t.path(e)})},Text:{path:Hi(function(t){var e,n=!(1<arguments.length&&void 0!==arguments[1])||arguments[1],r=new TextPath;if(t instanceof Path||(t=this.defs().path(t)),r.attr("href","#"+t,Ai),n)for(;e=this.node.firstChild;)r.node.appendChild(e);return this.put(r)}),textPath:function(){return this.findOne("textPath")}},Path:{text:Hi(function(t){return t instanceof Text||(t=(new Text).addTo(this.parent()).text(t)),t.path(this)}),targets:function(){return Bs('svg [href*="'+this.id()+'"]')}}}),TextPath.prototype.MorphArray=Ru,zi(TextPath,"TextPath");var Use=function(t){function Use(t){return Ti(this,Use),ps(this,ys(Use).call(this,Ri("use",t),t))}return ws(Use,Shape),as(Use,[{key:"element",value:function(t,e){return this.attr("href",(e||"")+"#"+t,Ai)}}]),Use}();Nr({Container:{use:Hi(function(t,e){return this.put(new Use).element(t,e)})}}),zi(Use,"Use");var da=Di;Vi([Svg,la,Image,Pattern,Marker],Dr("viewbox")),Vi([Line,Polyline,Polygon,Path],Dr("marker")),Vi(Text,Dr("Text")),Vi(Path,Dr("Path")),Vi(Defs,Dr("Defs")),Vi([Text,Tspan],Dr("Tspan")),Vi([Rect,Ellipse,Circle,Gradient],Dr("radius")),Vi(Us,Dr("EventTarget")),Vi(Dom,Dr("Dom")),Vi(Element,Dr("Element")),Vi(Shape,Dr("Shape")),Vi(Container,Dr("Container")),Vi(oa,Dr("Runner")),Vs.extend(Cr(new Set(Ir))),Uu([Ks,fs,Ys,Fs,Zs,_u,Ru]),$u();var pa={__proto__:null,Morphable:Xu,registerMorphableType:Uu,makeMorphable:$u,TransformBag:Vu,ObjectBag:Hu,NonMorphable:Gu,defaults:Js,utils:ki,namespaces:Mi,regex:Oo,SVG:da,parser:zs,find:Bs,registerWindow:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;Ei.window=t,Ei.document=e},Animator:Ku,Controller:Pu,Ease:Cu,PID:Du,Spring:Nu,easing:Eu,Queue:Zu,Runner:oa,Timeline:na,Array:Zs,Box:Ys,Color:fs,EventTarget:Us,Matrix:Fs,Number:Ks,PathArray:Ru,Point:Rs,PointArray:_u,List:Vs,Circle:Circle,ClipPath:ClipPath,Container:Container,Defs:Defs,Dom:Dom,Element:Element,Ellipse:Ellipse,ForeignObject:fa,Gradient:Gradient,G:G,A:A,Image:Image,Line:Line,Marker:Marker,Mask:Mask,Path:Path,Pattern:Pattern,Polygon:Polygon,Polyline:Polyline,Rect:Rect,Shape:Shape,Stop:Stop,Style:Style,Svg:Svg,Symbol:la,Text:Text,TextPath:TextPath,Tspan:Tspan,Use:Use,on:Ro,off:Lo,dispatch:Fo,root:Ii,create:Ni,makeInstance:Di,nodeOrNew:Ri,adopt:Li,mockAdopt:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:Li;Fi=t},register:zi,getClass:qi,eid:Xi,assignNewId:Gi,extend:Vi,wrapWithAttrCheck:Hi,invent:function(e){var t="function"==typeof e.create?e.create:function(t){this.constructor(t||Ni(e.create))};return e.inherit&&(t.prototype=new e.inherit,t.prototype.constructor=t),e.extend&&Vi(t,e.extend),e.construct&&Vi(e.parent||Pi.Container,e.construct),t}};function ya(t){return Di(t)}return Object.assign(ya,pa),ya}();