#### `le_pivot_index(M)`
##### `M :: Matrix`
returns the pivot-index of `M`, i.e. the index of `M`'s first non-zero entry when scanned column-wise.

---

#### `le_rank(M)`
##### `M :: Matrix`
returns the rank of the `M`

---

#### `le_bareiss(M)`
##### `M :: Matrix` 
returns a echelon form of `M`, whose pivot elements are not yet normalized.

---

#### `le_echelon(M)`
##### `M :: Matrix`
returns a echelon form of `M`.

---

#### `le_red_echelon(M)`
##### `M :: Matrix`
returns the reduced echelon form of `M`

---

#### `le_random_red_echelon([row_num,col_num], pivot_columns, range]`
##### `row_num, col_num :: Integer`, &nbsp; `pivot_columns :: [Intger]`, &nbsp; `range :: [Number]`
returns a random (`row_num` x `col_num`)-Matrix in reduced echelon form,
whose pivot columns are specified in `pivot_columns` and whose undetermined entries are drawn from `range`.

---

#### `le_from_to(a,b)`
##### `a, b :: Integer`
returns a list of numbers ranging from `a` to `b`.

---

#### `le_choose_from(n,L)`
##### `a :: Integer, L :: List`
returns a list of `n` numbers chosen randomly from `L`.

---

#### `le_row_shuffle(M, a, b)`
##### `M :: Matrix` &nbsp; `a, b :: Integer`
returns a matrix obtained from random row operations on the matrix `M`.
The alghorithms first shuffles the rows of `M` and then does `b` random row operations of each of the other (non swapping) row-operation types.
The factors appearing in these operations are randomly drawn from [-`a`,...`a`].

---

#### `le_row_shuffle(M)` = le_row_shuffle(M,1,40)
##### `M :: Matrix`

---

#### `le_random_row_operation(M,[a,b,c],d)`
##### `M :: Matrix`, &nbsp; `a, b, c, d :: Integer`
returns a matrix one random row operation away from `M`.
The integers `a,b,c` determine how likely which of the row operations is carried out.
`a` corresponds to "switch two rows", `b` to "add a multiple row to another row" and `c` to "multiply row by a factor".
For the two latter row operations, the factor involved is drawn from [-`d`,...`d`].

---

#### `le_zero_matrix(colnum,rownum)`
##### `colnum, rownum :: Integer`
returns a (`colnum` x `rownum`)-zero-matrix.

---

#### `le_kernel(M)`
##### `M :: Matrix`
returns a matrix whose row space is the kernal of `M`.

---

#### `inverse_pair(n,k)`
##### `n,k :: Integer`
returns a pair of inverse `n x n` matrices with integer entries.
The bigger `k`, the more the inverse pair differs from the identity matrix.

#### `le_print_columns(M)`
##### `s :: String`
returns a latex expression `s`, which contains the column-vectors of `M` separated by commas.