Numbas.addExtension('working-out',['jme','jme-display'],function(extension) {
  var jme = Numbas.jme;
  var types = Numbas.jme.types;
  var scope = extension.scope;
  
  var TWorkingOut = function(value) {
    this.value = value;
  }
  jme.registerType(TWorkingOut, 'workingout',{ string: function(tok) { return new types.TString(tok.value.message); } });
  jme.display.registerType(TWorkingOut, {
    tex: function(thing, tok, texArgs, settings) {
      return '\\text{'+tok.value.message+'}';
    },
    jme: function(tree,tok,bits,settings) {
      return 'comment("'+tok.value.message+'")';
    },
    displayString: function(tok) {
      return tok.value.message;
    }
  });

  
  scope.addFunction(new jme.funcObj('working_out',['list of name', '?', '[name]', '[html]'],'?',null, {
    evaluate: function(args, scope) {
      var columns = args[0].args.map(function(a) { return {header: a.args[0].tok, expr: a.args[1] }; });
      var algorithm = args[1];
      var steps = [];
      var working_scope = new jme.Scope([scope]);
      working_scope.working_steps = [];
      working_scope.add_step = function(scope,value,first) {
        var column_values = [];
        if(!value.no_columns) {
          columns.forEach(function(column) {
            var v;
            try {
              v = scope.evaluate(column.expr);
            } catch(e) {
              v = new types.TNothing();
            }
            column_values.push(v);
          });
        }
        var step = {
          message: value.message,
          column_values: column_values
        };
        if(first) {
          working_scope.working_steps.splice(0,0,step);
        } else {
        	working_scope.working_steps.push(step);
        }
      }
      var result = working_scope.evaluate(algorithm);
      var working;
      if(args.length >= 4) {
        var steps_vars = {};
        var steps_name = args[2].tok.name;
        var render = args[3];
        steps_vars[steps_name] = new types.TList(working_scope.working_steps.map(function(step) {
          return new types.TDict({
            message: step.message,
            column_values: new types.TList(step.column_values)
          });
        }));
        working = scope.evaluate(render,steps_vars);
      } else {
        var table = document.createElement('table');
        table.classList.add('working-out');
        var thead = document.createElement('thead');
        table.appendChild(thead);
        var tr_head = document.createElement('tr');
        thead.appendChild(tr_head);
        var td_comment = document.createElement('td');
        tr_head.appendChild(td_comment);
        columns.forEach(function(column) {
          var th = document.createElement('th');
          th.textContent = '{header}';
          var s = new jme.Scope([scope,{variables: {header: column.header}}]);
          jme.variables.DOMcontentsubvars(th,s);
          tr_head.appendChild(th);
        });
        var last_values = [];
        working_scope.working_steps.forEach(function(step) {
          var tr = document.createElement('tr');
          var td_message = document.createElement('td');
          tr.appendChild(td_message);
          var message_s = new jme.Scope([scope,{variables: {message: step.message}}]);
          td_message.textContent = '{message}';
          jme.variables.DOMcontentsubvars(td_message,message_s);
          columns.forEach(function(column,i) {
            var td = document.createElement('td');
            var v = step.column_values[i];
            if(v && (last_values[i]===undefined || !Numbas.util.eq(last_values[i],v))) {
              td.innerHTML = '$'+jme.display.texify({tok: v})+'$';
              last_values[i] = v;
            }
            tr.appendChild(td);
          });
          table.appendChild(tr);
        });
        working = new types.THTML(table);
      }
      return new types.TList([result, working]);
    }
  }));
  Numbas.jme.lazyOps.push('working_out');
  jme.findvarsOps.working_out = function(tree,boundvars,scope) {
      var vars = [];
      vars = vars.merge(jme.findvars(tree.args[1],boundvars,scope)); // vars from algorithm
      if(tree.args.length >= 4) {
        var steps_name = tree.args[2].tok.name; // name for the list of steps
        boundvars = boundvars.concat([steps_name]);
        vars = vars.merge(jme.findvars(tree.args[3],boundvars,scope)); // vars from the render expression
      }
      return vars;
  }
  

  scope.addFunction(new jme.funcObj('comment',['string or html'],TWorkingOut, null, {
    evaluate: function(args,scope) {
      return new TWorkingOut({message: args[0]});
    }
  }));
  scope.addFunction(new jme.funcObj('just_comment',['string or html'],TWorkingOut, null, {
    evaluate: function(args,scope) {
      return new TWorkingOut({message: args[0], no_columns: true});
    }
  }));
  
  function add_workingout(scope,working,first) {
      var working_scope = scope;
      while(working_scope && working_scope.working_steps === undefined) {
        working_scope = working_scope.parent;
      }
      if(working_scope) {
        working_scope.add_step(scope,working,first);
      }
  }

  scope.addFunction(new jme.funcObj(';', ['?','workingout'], '?', null, {
    evaluate: function(args, scope) {
      add_workingout(scope,args[1].value);
      return args[0];
    }
  }));
  
  scope.addFunction(new jme.funcObj(';', ['workingout','?'], '?', null, {
    evaluate: function(args, scope) {
      add_workingout(scope,args[0].value,true);
      return args[1];
    }
  }));
});