# SageMath Cell

Embeds a [SageMath Cell](https://sagecell.sagemath.org/) in a content area.

## Usage

In a content area (for example the question statement or a part prompt), write the following:

```
{sagecell(code)}
```

where `code` is a string containing Sage code.

You can optionally give a dictionary of options to configure the cell. The [available options](https://github.com/sagemath/sagecell/blob/master/doc/embedding.rst) are described in the Sage Cell documentation.

```
{sagecell(code,options)}
```

## Example

Define a variable ``plot_code`` as follows:

```
safe("""
var("x,y")
f(x,y) = 15*(4*x+3*y^2)/(x^2+y^2+4)^2
curvas_nivel = contour_plot(f(x,y), (x,-4,4), (y,-4,4), contours=25, cmap="jet", colorbar=True)
x0 = (-3,1)
punto = point(x0,color="black",size=40,zorder=3)
u = (-4/5,3/5)
v = (1/sqrt(5),-2/sqrt(5))
vec_u = arrow(x0,vector(x0)+vector(u),color="red")
vec_v = arrow(x0,vector(x0)+vector(v),color="green")
show(curvas_nivel + vec_u + vec_v + punto, figsize=5)
""")
```

Then in a content area, write:

```
{sagecell(plot_code, ["autoeval": true, "hide": ["editor", "evalButton", "permalink"]])}
```