Numbas.addExtension('sagemath-cell',['jme'],function(extension) {
  var scope = extension.scope;
  
  var jme = Numbas.jme;
  var funcObj = jme.funcObj;
  
  var TString = jme.types.TString;
  var TDict = jme.types.TDict;
  var THTML = jme.types.THTML;

  var sagePromise;
  
  function load_sage() {
    if(sagePromise) {
      return sagePromise;
    }
    
    var jQuery = window.jQuery;
    var script = document.createElement('script');
    extension.sagecell_url = extension.sagecell_url || 'https://sagecell.sagemath.org/static/embedded_sagecell.js';
    script.setAttribute('src',extension.sagecell_url);
    document.head.appendChild(script);

    sagePromise = new Promise(function(resolve, reject) {
      var checkInterval = setInterval(function() {
        if(window.sagecell) {
          window['jQuery'] = window['$'] = jQuery;
          clearInterval(checkInterval);
          resolve(sagecell);
        }
      },50);
  	});
    return sagePromise;
  }
  
  function sage_cell(code,options) {
    var container = document.createElement('div');
    var script = document.createElement('script');
    script.setAttribute('type','text/x-sage');
    script.textContent = code;
    container.appendChild(script);
    options = options || {};
    console.log(JSON.stringify(options));
    options.inputLocation = container;
    load_sage().then(function(sagecell) {
      sagecell.makeSagecell(options);
    });
    return container;
  }
  
  scope.addFunction(new funcObj('sagecell',[TString],THTML,function(code) {
    return sage_cell();
  }));
  scope.addFunction(new funcObj('sagecell',[TString,TDict],THTML,null, {
    evaluate: function(args, scope) {
      var code = jme.unwrapValue(args[0]);
      var options = jme.unwrapValue(args[1]);
      console.log(JSON.stringify(options));
      return new THTML(sage_cell(code,options));
    }
  }));
});