# Propositional Logic Extension for Numbas

This extension provides jme and javascript functions to generate and assess problems in boolean logic.

## JME functions


### `generateExpression(num_operators,atoms)`

generates a random boolean expression, with `num_operators` operations, using `atoms` atomic propositions.

Example usage: `generateExpression(4,['p','q'])` could generate an expression like "(not p) and (q or not p)"

### `equivExpressions(boolean expression,boolean expression)`

returns `true` if the two boolean expressions are logically equivalent, `false` otherwise.

Example usage: `equivExpressions(expression("not (p or q)"),expression("not p and not q"))` will return `true`.

### `truthColumn(boolean expression)`

returns a list of booleans, corresponding to the last column in the truth table of the boolean expression.

### `stringify(boolean expression)`

returns a string representing the boolean expression with unicode symbols.

Example usage: `stringify(expression("(not p) and (q or not p)"))` will return the unicode string "&not;p &and; (q &or; &not;p)".

### `latexify(boolean expression)`

returns a string representing the boolean expression in LaTeX.

Example usage: `latexify(expression("(not p) and (q or not p)"))` will return the string "\neg p \land (q \lor \neg p)".


### `truthTable(boolean expression)`

returns the truth table of the expression, as a list containing two sublists:

* the subexpressions
* the truth table, with the columns in the same order as the expressions
 
### `simplifyProposition(boolean expression)`

Simplify a boolean proposition

### `findLaw(boolean expression,boolean expression)`

Find a boolean law that was applied to go from the first to the second expression.

### `getMarkingMatrix(boolean expression,boolean expression)`
 
### `compareExprLists(list, list)`

Check whether two lists contain the same expressions, not necessarily in the same order.
 
### `checkSubExprList(list,boolean expression)`

Check whether a list contains all the subexpressions of the expression.
 

## javascript functions

Those functions are intended to be used in marking scripts.

###  `propositionallogic.generateExpression` 
 
###  `propositionallogic.equivExpr`
 
###  `propositionallogic.getFeedbackLaw`